/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.framework.dockable;

import com.nepxion.swing.framework.JFrameWorkStatusBar;
import com.nepxion.swing.framework.JFrameWorkWindow;
import com.nepxion.swing.framework.dockable.JDockable;
import com.nepxion.swing.framework.dockable.JDockableContainer;
import com.nepxion.swing.framework.dockable.JDockableHierarchy;
import com.nepxion.swing.framework.dockable.JDockableSplitPane;
import com.nepxion.swing.framework.dockable.JDockableTabbedPane;
import com.nepxion.swing.framework.dockable.JDockableView;
import com.nepxion.swing.fullscreen.FullScreenRegister;
import com.nepxion.swing.fullscreen.FullScreenSupport;
import com.nepxion.swing.keystroke.KeyStrokeManager;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.menu.JBasicMenu;
import com.nepxion.swing.menuitem.JBasicCheckBoxMenuItem;
import com.nepxion.swing.toolbar.JBasicToolBar;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;

public class DockableManager {
    public static JDockableTabbedPane getDockableTabbedPane(JDockableContainer dockableContainer, String title, String tabbedPaneName) {
        List tabbedPanes = DockableManager.getDockableTabbedPanes(dockableContainer, title);
        if (tabbedPanes == null) {
            return null;
        }
        for (JDockableTabbedPane tabbedPane : tabbedPanes) {
            if (!tabbedPane.getName().equals(tabbedPaneName)) continue;
            return tabbedPane;
        }
        return null;
    }

    public static List getDockableTabbedPanes(JDockableContainer dockableContainer, String title) {
        JDockableView dockableView = DockableManager.getDockableView(dockableContainer, title);
        if (dockableView == null) {
            return null;
        }
        Component contentPane = dockableView.getContentPane();
        if (contentPane instanceof JDockableSplitPane) {
            JDockableSplitPane dockableSplitPane = (JDockableSplitPane)((Object)contentPane);
            return dockableSplitPane.getTabbedPanes();
        }
        if (contentPane instanceof JDockableTabbedPane) {
            ArrayList<Component> tabbedPanes = new ArrayList<Component>();
            tabbedPanes.add(contentPane);
            return tabbedPanes;
        }
        return null;
    }

    public static JDockableView getDockableView(JDockableContainer dockableContainer, String title) {
        JDockableView dockableView;
        Component contentPane = dockableContainer.getContentPane();
        if (contentPane instanceof JDockable) {
            JDockable dockable = (JDockable)((Object)contentPane);
            return DockableManager.getDockableView(dockable, title);
        }
        if (contentPane instanceof JDockableView && (dockableView = (JDockableView)contentPane).getTitle().equals(title)) {
            return dockableView;
        }
        return null;
    }

    public static JDockableView getDockableView(JDockable dockable, String title) {
        for (int i = 0; i < dockable.getPaneCount(); ++i) {
            JDockable childDockable;
            JDockableView dockableView;
            Component component = dockable.getPaneAt(i);
            if (component instanceof JDockableView) {
                JDockableView dockableView2 = (JDockableView)component;
                if (!dockableView2.getTitle().equals(title)) continue;
                return dockableView2;
            }
            if (!(component instanceof JDockable) || (dockableView = DockableManager.getDockableView(childDockable = (JDockable)((Object)component), title)) == null) continue;
            return dockableView;
        }
        return null;
    }

    public static List getDockableViews(JDockableContainer dockableContainer) {
        ArrayList<JDockableView> dockableViews = new ArrayList<JDockableView>();
        Component component = dockableContainer.getContentPane();
        if (component instanceof JDockable) {
            JDockable dockable = (JDockable)((Object)component);
            DockableManager.putDockableViews(dockable, dockableViews);
        } else if (component instanceof JDockableView) {
            JDockableView dockableView = (JDockableView)component;
            dockableViews.add(dockableView);
        }
        return dockableViews;
    }

    public static List getDockableViews(JDockable dockable) {
        ArrayList dockableViews = new ArrayList();
        DockableManager.putDockableViews(dockable, dockableViews);
        return dockableViews;
    }

    private static void putDockableViews(JDockable dockable, List dockableViews) {
        for (int i = 0; i < dockable.getPaneCount(); ++i) {
            Component component = dockable.getPaneAt(i);
            if (component instanceof JDockableView) {
                JDockableView dockableView = (JDockableView)component;
                dockableViews.add(dockableView);
                continue;
            }
            if (!(component instanceof JDockable)) continue;
            JDockable childDockable = (JDockable)((Object)component);
            DockableManager.putDockableViews(childDockable, dockableViews);
        }
    }

    public static JDockable getDockable(Component component) {
        Container container = component.getParent();
        if (container == null) {
            return null;
        }
        if (container instanceof JDockable) {
            return (JDockable)((Object)container);
        }
        return DockableManager.getDockable(container);
    }

    public static JDockableContainer getDockableContainer(Component component) {
        Container container = component.getParent();
        if (container == null) {
            return null;
        }
        if (container instanceof JDockableContainer) {
            return (JDockableContainer)container;
        }
        return DockableManager.getDockableContainer(container);
    }

    public static JDockableView getDockableView(JFrameWorkWindow frameWorkWindow, String title) {
        if (frameWorkWindow == null) {
            return null;
        }
        JDockableHierarchy dockableHierarchy = (JDockableHierarchy)frameWorkWindow.getHierarchy();
        return DockableManager.getDockableView(dockableHierarchy, title);
    }

    public static JDockableView getDockableView(JDockableHierarchy dockableHierarchy, String title) {
        if (dockableHierarchy == null) {
            return null;
        }
        JDockableContainer dockableContainer = dockableHierarchy.getDockableContainer();
        Component component = dockableContainer.getContentPane();
        if (component instanceof JDockable) {
            JDockable dockable = (JDockable)((Object)component);
            return DockableManager.getDockableView(dockable, title);
        }
        return null;
    }

    public static JBasicMenu getToggleMenu(final JDockableHierarchy dockableHierarchy) {
        JBasicMenu toggleMenu = new JBasicMenu(SwingLocale.getString("view"), SwingLocale.getString("view") + "(V)");
        toggleMenu.setMnemonic('V');
        JBasicCheckBoxMenuItem toolBarToggleMenuItem = new JBasicCheckBoxMenuItem(SwingLocale.getString("toolbar"), SwingLocale.getString("toolbar"), true);
        toolBarToggleMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JBasicToolBar toolBar;
                ((Component)toolBar).setVisible(!(toolBar = dockableHierarchy.getToolBar()).isVisible());
            }
        });
        toggleMenu.add(toolBarToggleMenuItem);
        JBasicCheckBoxMenuItem statusBarToggleMenuItem = new JBasicCheckBoxMenuItem(SwingLocale.getString("statusbar"), SwingLocale.getString("statusbar"), true);
        statusBarToggleMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFrameWorkStatusBar statusBar;
                ((Component)statusBar).setVisible(!(statusBar = dockableHierarchy.getStatusBar()).isVisible());
            }
        });
        toggleMenu.add(statusBarToggleMenuItem);
        toggleMenu.addSeparator();
        List dockableViews = dockableHierarchy.getDockableViews();
        for (final JDockableView dockableView : dockableViews) {
            JBasicCheckBoxMenuItem dockableViewToggleMenuItem = new JBasicCheckBoxMenuItem(dockableView.getTitle(), dockableView.getTitle(), true);
            dockableView.registerForeignButton(dockableViewToggleMenuItem);
            dockableViewToggleMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    dockableView.setVisible(!dockableView.isVisible());
                }
            });
            toggleMenu.add(dockableViewToggleMenuItem);
        }
        toggleMenu.addSeparator();
        JBasicCheckBoxMenuItem screenToggleMenuItem = new JBasicCheckBoxMenuItem(SwingLocale.getString("fullscreen"), SwingLocale.getString("fullscreen"));
        KeyStrokeManager.registerButton((AbstractButton)screenToggleMenuItem, 123, 'F');
        toggleMenu.add(screenToggleMenuItem);
        FullScreenSupport fullScreenSupport = new FullScreenSupport(dockableHierarchy);
        FullScreenRegister fullScreenRegister = new FullScreenRegister(fullScreenSupport);
        fullScreenRegister.register(dockableHierarchy.getMenuBar());
        fullScreenRegister.register(dockableHierarchy.getToolBar());
        fullScreenRegister.register(screenToggleMenuItem);
        return toggleMenu;
    }
}

