/*
 * Decompiled with CFR 0.152.
 */
package twaver.table;

import java.util.HashMap;
import java.util.Map;
import javax.swing.table.TableCellRenderer;
import twaver.ElementAttribute;
import twaver.TUIManager;
import twaver.base.A.E.H;

public class CellRendererManager {
    protected Map registry = new HashMap();
    protected Map typeToRendererCache = new HashMap();
    protected Map attributeToRendererCache = new HashMap();

    public void registerRenderer(Class propertyType, Class rendererClass) {
        if (rendererClass == null) {
            this.registerRenderer(propertyType, (String)null);
        } else {
            this.registerRenderer(propertyType, rendererClass.getName());
        }
    }

    public void registerRenderer(Class propertyType, String rendererClass) {
        if (rendererClass == null) {
            this.registry.remove(propertyType);
        } else {
            this.registry.put(propertyType, rendererClass);
        }
        this.typeToRendererCache.remove(propertyType);
    }

    public void clearCache() {
        this.typeToRendererCache.clear();
        this.attributeToRendererCache.clear();
    }

    public TableCellRenderer findRenderer(ElementAttribute attribute, Object cellValue) {
        TableCellRenderer renderer = (TableCellRenderer)this.attributeToRendererCache.get(attribute);
        if (renderer == null && attribute != null) {
            renderer = attribute.getRenderer();
            if (renderer == null && attribute.getJavaClass() != null) {
                renderer = this.findRenderer(attribute.getJavaClass());
            }
            if (renderer != null) {
                this.attributeToRendererCache.put(attribute, renderer);
            }
        }
        if (renderer == null && cellValue != null) {
            renderer = this.findRenderer(cellValue.getClass());
        }
        return renderer;
    }

    public TableCellRenderer findRenderer(Class propertyType) {
        TableCellRenderer renderer = (TableCellRenderer)this.typeToRendererCache.get(propertyType);
        if (renderer != null) {
            return renderer;
        }
        String rendererClass = (String)this.registry.get(propertyType);
        if (rendererClass == null) {
            rendererClass = TUIManager.getTableCellRenderer(propertyType);
        }
        if (rendererClass != null) {
            renderer = (TableCellRenderer)H.B(rendererClass);
            this.typeToRendererCache.put(propertyType, renderer);
        }
        return renderer;
    }
}

