/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import twaver.BaseEquipment;
import twaver.Node;
import twaver.Shelf;
import twaver.TWaverConst;
import twaver.base.A.E.b;
import twaver.base.Direction;

public class Slot
extends BaseEquipment {
    private int \u00a3 = 1;
    private int \u00a2 = -1;

    public Slot() {
        this.U();
    }

    public Slot(Object id) {
        super(id);
        this.U();
    }

    protected void hostPropertyChange(PropertyChangeEvent evt) {
        String propertyName = b.A(evt);
        if (propertyName.equals("location") || propertyName.equals("equip.direction") || propertyName.equals("equipCount") || propertyName.equals("size") || propertyName.equals("shelf.border") || propertyName.equals("shelf.inner.border") || propertyName.equals("slot.border") || propertyName.equals("slot.inner.border")) {
            this.adjustBounds();
        }
    }

    private void U() {
        this.setSize(35, 105);
        this.getClientProperties().put("body.fill", Boolean.FALSE);
        this.getClientProperties().put("border.insets", TWaverConst.INTEGER0);
    }

    public int getEquipCount() {
        return this.\u00a3;
    }

    public void setEquipCount(int equipCount) {
        int oldValue = this.\u00a3;
        this.\u00a3 = equipCount;
        this.firePropertyChange("equipCount", oldValue, equipCount);
    }

    public int getEquipIndex() {
        return this.\u00a2;
    }

    public void setEquipIndex(int equipIndex) {
        int oldValue = this.\u00a2;
        this.\u00a2 = equipIndex;
        this.firePropertyChange("equipIndex", oldValue, equipIndex);
        this.adjustBounds();
    }

    public Rectangle getEquipBoundsByIndex(int equipIndex) {
        if (this.\u00a3 <= 0 || equipIndex < 0 || equipIndex >= this.\u00a3) {
            return null;
        }
        int slotBorder = b.J(this, "slot.border");
        int slotInnerBorder = b.J(this, "slot.inner.border");
        Point location = this.getLocation();
        int x = location.x + slotBorder;
        int y = location.y + slotBorder;
        int w = this.getWidth() - slotBorder * 2;
        int h2 = this.getHeight() - slotBorder * 2;
        if (Direction.VERTICAL.equals(this.getEquipDirection())) {
            double span = (double)w / (double)this.\u00a3;
            x = (int)((double)x + span * (double)equipIndex);
            return new Rectangle(x + slotInnerBorder, y + slotInnerBorder, (int)span - slotInnerBorder * 2, h2 - slotInnerBorder * 2);
        }
        double span = (double)h2 / (double)this.\u00a3;
        y = (int)((double)y + span * (double)equipIndex);
        return new Rectangle(x + slotInnerBorder, y + slotInnerBorder, w - slotInnerBorder * 2, (int)span - slotInnerBorder * 2);
    }

    public void adjustBounds() {
        Rectangle bounds;
        Node host = this.getHost();
        if (host instanceof Shelf) {
            Shelf shelf = (Shelf)host;
            if (this.\u00a2 >= 0 && this.\u00a2 < shelf.getEquipCount() && (bounds = shelf.getEquipBoundsByIndex(this.\u00a2)) != null) {
                this.setLocation(bounds.x, bounds.y);
                this.setSize(bounds.width, bounds.height);
            }
        }
        if (host instanceof Slot) {
            Slot slot = (Slot)host;
            if (this.\u00a2 >= 0 && this.\u00a2 < slot.getEquipCount() && (bounds = slot.getEquipBoundsByIndex(this.\u00a2)) != null) {
                this.setLocation(bounds.x, bounds.y);
                this.setSize(bounds.width, bounds.height);
            }
        }
    }

    public String getUIClassID() {
        return "SlotUI";
    }

    public String getSVGUIClassID() {
        return "SlotSVGUI";
    }

    public void putEquipDirection(Direction equipDirection) {
        this.putClientProperty((Object)"equip.direction", equipDirection);
    }

    public Direction getEquipDirection() {
        return b.E(this, "equip.direction");
    }

    public void putSlotBorder(int slotBorder) {
        this.putClientProperty((Object)"slot.border", slotBorder);
    }

    public int getSlotBorder() {
        return b.J(this, "slot.border");
    }

    public void putSlotInnerBorder(int slotInnerBorder) {
        this.putClientProperty((Object)"slot.inner.border", slotInnerBorder);
    }

    public int getSlotInnerBorder() {
        return b.J(this, "slot.inner.border");
    }
}

