/*
 * Decompiled with CFR 0.152.
 */
package y.view;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import y.base.Node;
import y.geom.YDimension;
import y.geom.YPoint;
import y.geom.YRectangle;
import y.io.BadVersionException;
import y.layout.DiscreteNodeLabelModel;
import y.layout.EdgeOppositeNodeLabelModel;
import y.layout.FreeNodeLabelModel;
import y.layout.NodeLabelLayout;
import y.layout.NodeLabelModel;
import y.view.Graph2D;
import y.view.NodeRealizer;
import y.view.YLabel;

public class NodeLabel
extends YLabel
implements NodeLabelLayout {
    public static final byte CENTER = 100;
    public static final byte BOTTOM = 101;
    public static final byte TOP = 102;
    public static final byte TOP_LEFT = 117;
    public static final byte TOP_RIGHT = 118;
    public static final byte BOTTOM_LEFT = 119;
    public static final byte BOTTOM_RIGHT = 120;
    public static final byte LEFT = 115;
    public static final byte RIGHT = 116;
    public static final byte CENTER_X = 103;
    public static final byte NW = 104;
    public static final byte NE = 105;
    public static final byte SE = 106;
    public static final byte SW = 107;
    public static final byte N = 108;
    public static final byte S = 109;
    public static final byte E = 110;
    public static final byte W = 111;
    public static final byte DYNAMIC = 112;
    public static final byte ANYWHERE = 114;
    public static final byte UNDEFINED = 113;
    public static final byte CORNERS = 0;
    public static final byte INTERNAL = 1;
    public static final byte SANDWICH = 2;
    public static final byte SIDES = 3;
    public static final byte FREE = 4;
    public static final byte EIGHT_POS = 5;
    public static final byte EDGE_OPPOSITE = 6;
    private static final byte u = 6;
    private static final byte[][] x = new byte[][]{{104, 105, 106, 107}, {100, 102, 101, 115, 116, 117, 118, 119, 120}, {108, 109}, {108, 109, 111, 110}, {114}, {108, 109, 110, 111, 104, 105, 107, 106}, {112}};
    NodeRealizer z;
    private Color w = Color.black;
    private NodeLabelModel y;
    private Object t = new Integer(1);
    private double v = 4.0;

    public NodeLabel(String string, byte by) {
        this.y = new DiscreteNodeLabelModel(130816, this.v);
        this.t = this.y.getDefaultParameter();
        this.setModel(by);
        this.setText(string);
    }

    public NodeLabel(String string) {
        this(string, 1);
    }

    public NodeLabel() {
        this("");
    }

    public Object clone() {
        NodeLabel nodeLabel = new NodeLabel();
        nodeLabel.adoptValues(this);
        return nodeLabel;
    }

    public void setOffset(double d2, double d3) {
        super.setOffset(d2, d3);
        if (this.y instanceof FreeNodeLabelModel) {
            ((FreeNodeLabelModel)this.y).setLocation(this.getOffsetX(), this.getOffsetY());
        }
    }

    public void setText(String string) {
        String string2 = this.getText();
        super.setText(string);
        Graph2D graph2D = this.getGraph2D();
        if (graph2D != null) {
            graph2D.fireGraph2DEvent(this, "text", string2, this.getText());
        }
    }

    public void setDistance(double d2) {
        this.v = d2;
        if (this.y instanceof DiscreteNodeLabelModel) {
            ((DiscreteNodeLabelModel)this.y).setDistance(this.v);
        }
        this.setOffsetDirty();
    }

    public double getDistance() {
        return this.v;
    }

    public NodeLabelModel getLabelModel() {
        return this.y;
    }

    public void setLabelModel(NodeLabelModel nodeLabelModel) {
        this.y = nodeLabelModel;
        this.setOffsetDirty();
    }

    public Object getModelParameter() {
        return this.t;
    }

    public void setModelParameter(Object object) {
        this.t = object;
        this.placement = this.getPosition();
        this.setOffsetDirty();
    }

    public void setModel(byte by) {
        if (by >= 0 && by <= 6) {
            NodeLabelModel nodeLabelModel;
            this.model = by;
            NodeLabelModel nodeLabelModel2 = this.y;
            this.setOffsetDirty();
            switch (this.model) {
                case 0: {
                    this.y = new DiscreteNodeLabelModel(198, this.v);
                    break;
                }
                case 1: {
                    this.y = new DiscreteNodeLabelModel(130816, this.v);
                    break;
                }
                case 2: {
                    this.y = new DiscreteNodeLabelModel(33, this.v);
                    break;
                }
                case 3: {
                    this.y = new DiscreteNodeLabelModel(57, this.v);
                    break;
                }
                case 4: {
                    this.y = new FreeNodeLabelModel();
                    break;
                }
                case 5: {
                    this.y = new DiscreteNodeLabelModel(255, this.v);
                    break;
                }
                case 6: {
                    this.y = new EdgeOppositeNodeLabelModel(this.getGraph2D(), this.getNode());
                }
            }
            if (nodeLabelModel2 instanceof DiscreteNodeLabelModel && this.y instanceof DiscreteNodeLabelModel && ((DiscreteNodeLabelModel)(nodeLabelModel = (DiscreteNodeLabelModel)this.y)).isParameterValid(this.t)) {
                return;
            }
            if (this.y instanceof FreeNodeLabelModel) {
                nodeLabelModel = (FreeNodeLabelModel)this.y;
                ((FreeNodeLabelModel)nodeLabelModel).setLocation(this.offsetX, this.offsetY);
            }
            this.t = this.y.getDefaultParameter();
            this.placement = this.getPosition();
        }
    }

    public boolean hasFreePositioning() {
        return this.model == 4;
    }

    public void setPosition(byte by) {
        if (!(this.y instanceof DiscreteNodeLabelModel)) {
            return;
        }
        DiscreteNodeLabelModel discreteNodeLabelModel = (DiscreteNodeLabelModel)this.y;
        int n = 0;
        switch (by) {
            case 100: {
                n = 256;
                break;
            }
            case 101: {
                n = 512;
                break;
            }
            case 102: {
                n = 1024;
                break;
            }
            case 117: {
                n = 8192;
                break;
            }
            case 118: {
                n = 16384;
                break;
            }
            case 119: {
                n = 32768;
                break;
            }
            case 120: {
                n = 65536;
                break;
            }
            case 115: {
                n = 2048;
                break;
            }
            case 116: {
                n = 4096;
                break;
            }
            case 104: {
                n = 2;
                break;
            }
            case 105: {
                n = 4;
                break;
            }
            case 106: {
                n = 128;
                break;
            }
            case 107: {
                n = 64;
                break;
            }
            case 108: {
                n = 1;
                break;
            }
            case 109: {
                n = 32;
                break;
            }
            case 110: {
                n = 8;
                break;
            }
            case 111: {
                n = 16;
            }
        }
        Integer n2 = new Integer(n);
        if (!discreteNodeLabelModel.isParameterValid(n2)) {
            System.err.println("NLabel::setPos: ERROR: pos " + by + " not valid for model " + this.model);
            return;
        }
        this.t = n2;
        this.setOffsetDirty();
    }

    public byte getPosition() {
        if (this.y instanceof DiscreteNodeLabelModel) {
            int n = (Integer)this.t;
            switch (n) {
                case 256: {
                    return 100;
                }
                case 1024: {
                    return 102;
                }
                case 512: {
                    return 101;
                }
                case 8192: {
                    return 117;
                }
                case 16384: {
                    return 118;
                }
                case 32768: {
                    return 119;
                }
                case 65536: {
                    return 120;
                }
                case 2048: {
                    return 115;
                }
                case 4096: {
                    return 116;
                }
                case 4: {
                    return 105;
                }
                case 2: {
                    return 104;
                }
                case 128: {
                    return 106;
                }
                case 64: {
                    return 107;
                }
                case 1: {
                    return 108;
                }
                case 8: {
                    return 110;
                }
                case 16: {
                    return 111;
                }
                case 32: {
                    return 109;
                }
            }
        }
        if (this.y instanceof FreeNodeLabelModel) {
            return 114;
        }
        if (this.y instanceof EdgeOppositeNodeLabelModel) {
            return 112;
        }
        return 113;
    }

    public void setFreeOffset(double d2, double d3) {
        if (this.model != 4) {
            System.err.println("WARNING: cannot set label offset directly. Label is not freely positionable.");
            return;
        }
        FreeNodeLabelModel freeNodeLabelModel = (FreeNodeLabelModel)this.y;
        FreeNodeLabelModel.ModelParameter modelParameter = (FreeNodeLabelModel.ModelParameter)this.t;
        modelParameter.setPoint(d2, d3);
        this.setOffsetDirty();
    }

    public YPoint getLocation() {
        return new YPoint(this.z.getX() + this.getOffsetX(), this.z.getY() + this.getOffsetY());
    }

    public static Map modelToStringMap() {
        HashMap<Byte, String> hashMap = new HashMap<Byte, String>(11);
        hashMap.put(new Byte(1), "Internal");
        hashMap.put(new Byte(0), "Corners");
        hashMap.put(new Byte(2), "Sandwich");
        hashMap.put(new Byte(3), "Sides");
        hashMap.put(new Byte(4), "Free");
        hashMap.put(new Byte(5), "8-Pos");
        hashMap.put(new Byte(6), "Edge Opposite");
        return hashMap;
    }

    public static Map positionToStringMap() {
        Hashtable<Byte, String> hashtable = new Hashtable<Byte, String>(21);
        hashtable.put(new Byte(100), "Center");
        hashtable.put(new Byte(101), "Bottom");
        hashtable.put(new Byte(102), "Top");
        hashtable.put(new Byte(117), "Topleft");
        hashtable.put(new Byte(118), "Topright");
        hashtable.put(new Byte(119), "Bottomleft");
        hashtable.put(new Byte(120), "Bottomright");
        hashtable.put(new Byte(115), "Left");
        hashtable.put(new Byte(116), "Right");
        hashtable.put(new Byte(103), "Center X");
        hashtable.put(new Byte(104), "NorthWest");
        hashtable.put(new Byte(105), "NorthEast");
        hashtable.put(new Byte(106), "SouthEast");
        hashtable.put(new Byte(107), "SouthWest");
        hashtable.put(new Byte(108), "North");
        hashtable.put(new Byte(109), "South");
        hashtable.put(new Byte(110), "East");
        hashtable.put(new Byte(111), "West");
        hashtable.put(new Byte(113), "Undefined");
        hashtable.put(new Byte(112), "Dynamic");
        hashtable.put(new Byte(114), "Anywhere");
        return hashtable;
    }

    public static byte[] getModelPositions(byte by) {
        return x[by];
    }

    public static Vector availablePositions(Byte by) {
        Vector<Byte> vector = new Vector<Byte>(10);
        if (by != null) {
            byte[] byArray = NodeLabel.getModelPositions(by);
            int n = 0;
            while (n < byArray.length) {
                vector.add(new Byte(byArray[n]));
                ++n;
            }
        } else {
            vector.add(new Byte(113));
        }
        return vector;
    }

    public boolean isOffsetDirty() {
        if (this.model == 6) {
            return true;
        }
        return this.offsetDirty;
    }

    public void calculateOffset() {
        if (!this.hasFreePositioning()) {
            NodeRealizer nodeRealizer = this.z;
            YPoint yPoint = this.getLabelModel().getLabelPlacement(new YDimension(this.getWidth(), this.getHeight()), nodeRealizer, this.getModelParameter());
            this.setOffset(yPoint.getX() - nodeRealizer.getX(), yPoint.getY() - nodeRealizer.getY());
        }
    }

    public Node getNode() {
        if (this.z != null) {
            return this.z.getNode();
        }
        return null;
    }

    public NodeRealizer getRealizer() {
        return this.z;
    }

    public Graph2D getGraph2D() {
        Node node = this.getNode();
        if (node != null) {
            return (Graph2D)node.getGraph();
        }
        return null;
    }

    public void bindRealizer(NodeRealizer nodeRealizer) {
        this.z = nodeRealizer;
        this.setOffsetDirty();
    }

    public YRectangle getBox() {
        return new YRectangle(this.getOffsetX() + this.z.getX(), this.getOffsetY() + this.z.getY(), this.getWidth(), this.getHeight());
    }

    public void write(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeByte(0);
        super.write(objectOutputStream);
    }

    public void read(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        switch (objectInputStream.readByte()) {
            case 0: {
                super.read(objectInputStream);
                break;
            }
            default: {
                throw new BadVersionException();
            }
        }
    }
}

