/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.icon.paint;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;

public class GeoCellIcon
implements Icon {
    public static final int SHAPE_POINT = 0;
    public static final int SHAPE_LINE = 1;
    public static final int SHAPE_POLYGON = 2;
    private int shape;
    private Color color;

    public GeoCellIcon(int shape, Color color) {
        this.shape = shape;
        this.color = color;
    }

    private void paintPoint(Component c, Graphics g) {
        Dimension size = c.getSize();
        int x = (int)size.getWidth() / 2;
        int y = (int)size.getHeight() / 2;
        g.setColor(this.color);
        g.fillRect(x - 2, y - 2, 4, 4);
        g.setColor(Color.black);
        g.drawLine(x - 2, y - 2, x + 2, y - 2);
        g.drawLine(x - 2, y + 2, x + 2, y + 2);
        g.drawLine(x - 2, y - 2, x - 2, y + 2);
        g.drawLine(x + 2, y - 2, x + 2, y + 2);
    }

    private void paintLine(Component c, Graphics g) {
        Dimension size = c.getSize();
        int x = (int)size.getWidth() / 2;
        int y = (int)size.getHeight() / 2;
        g.setColor(this.color);
        g.drawLine(x - 2, y - 2, x + 1, y + 1);
        g.drawLine(x - 2, y - 2, x - 5, y + 5);
        g.drawLine(x + 1, y + 1, x + 4, y - 6);
    }

    private void paintPolygon(Component c, Graphics g) {
        Dimension size = c.getSize();
        int x = (int)size.getWidth() / 2;
        int y = (int)size.getHeight() / 2;
        g.setColor(this.color);
        g.fillRect(x - 5, y - 5, 10, 10);
        g.setColor(Color.black);
        g.drawLine(x - 5, y - 5, x + 5, y - 5);
        g.drawLine(x - 5, y + 5, x + 5, y + 5);
        g.drawLine(x - 5, y - 5, x - 5, y + 5);
        g.drawLine(x + 5, y - 5, x + 5, y + 5);
    }

    @Override
    public int getIconWidth() {
        switch (this.shape) {
            case 0: {
                return 4;
            }
            case 1: {
                return 10;
            }
            case 2: {
                return 10;
            }
        }
        return 0;
    }

    @Override
    public int getIconHeight() {
        switch (this.shape) {
            case 0: {
                return 4;
            }
            case 1: {
                return 10;
            }
            case 2: {
                return 10;
            }
        }
        return 0;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        switch (this.shape) {
            case 0: {
                this.paintPoint(c, g);
                break;
            }
            case 1: {
                this.paintLine(c, g);
                break;
            }
            case 2: {
                this.paintPolygon(c, g);
            }
        }
    }
}

