/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.searcher.ip.local;

import com.nepxion.swing.action.JSecurityAction;
import com.nepxion.swing.handle.HandleManager;
import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.optionpane.JBasicOptionPane;
import com.nepxion.swing.searcher.ip.local.IPTableModel;
import com.nepxion.swing.searcher.ip.local.JIPPanel;
import com.nepxion.swing.searcher.ip.local.JIPTable;
import com.nepxion.swing.thread.dialog.JThreadDialog;
import com.nepxion.util.searcher.ip.local.IPEntity;
import com.nepxion.util.searcher.ip.local.IPSearcher;
import java.awt.event.ActionEvent;

public class IPController {
    public static JSecurityAction getSearchAction(final JIPPanel panel) {
        JSecurityAction action = new JSecurityAction(SwingLocale.getString("query"), IconFactory.getSwingIcon("stereo_search.png"), SwingLocale.getString("ip_to_address")){

            @Override
            public void execute(ActionEvent e) {
                JThreadDialog dialog = new JThreadDialog(HandleManager.getFrame(panel), SwingLocale.getString("ip_to_address"), SwingLocale.getString("query_and_wait")){

                    @Override
                    protected void loadForeground(Object data) throws Exception {
                        IPEntity entity = (IPEntity)data;
                        if (entity == null) {
                            JBasicOptionPane.showMessageDialog(HandleManager.getFrame(panel), SwingLocale.getString("no_records"), SwingLocale.getString("warning"), 2);
                            return;
                        }
                        IPTableModel tableModel = (IPTableModel)panel.getIPTable().getModel();
                        tableModel.addRow(entity);
                    }

                    @Override
                    protected Object loadBackground() throws Exception {
                        String ip = panel.getIP();
                        if (ip.equals("")) {
                            throw new IllegalArgumentException(SwingLocale.getString("ip_not_null"));
                        }
                        IPSearcher searcher = IPSearcher.getInstance();
                        String country = searcher.getCountry(ip);
                        String region = searcher.getRegion(ip);
                        IPEntity entity = new IPEntity();
                        entity.setIP(ip);
                        entity.setCountry(country);
                        entity.setRegion(region);
                        return entity;
                    }
                };
                dialog.execute();
            }
        };
        return action;
    }

    public static JSecurityAction getClearAction(final JIPTable table) {
        JSecurityAction action = new JSecurityAction(SwingLocale.getString("clear"), IconFactory.getSwingIcon("stereo/delete_16.png"), SwingLocale.getString("clear_query_result")){

            @Override
            public void execute(ActionEvent e) {
                int selectedValue = JBasicOptionPane.showConfirmDialog(HandleManager.getFrame(table), SwingLocale.getString("confirm_to_clear_query_result"), SwingLocale.getString("confirm"), 0);
                if (selectedValue != 0) {
                    return;
                }
                IPTableModel tableModel = (IPTableModel)table.getModel();
                tableModel.clearRows();
            }
        };
        return action;
    }
}

