/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.pagination;

import com.nepxion.swing.element.ElementNode;

public class PaginationContext {
    private int rowIndex = 1;
    private int rowCount = 100;
    private int totalRowCount = -1;
    private int pageIndex = 1;
    private ElementNode sortName;
    private ElementNode sortType;
    private boolean isValidation = true;

    public PaginationContext() {
    }

    public PaginationContext(int totalRowCount) {
        this.totalRowCount = totalRowCount;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
        this.pageIndex = 1;
        if (this.rowCount > this.totalRowCount && this.totalRowCount != -1) {
            this.rowCount = this.totalRowCount;
        }
    }

    public int getTotalRowCount() {
        return this.totalRowCount;
    }

    public void setTotalRowCount(int totalRowCount) {
        this.totalRowCount = totalRowCount;
        if (this.rowCount > this.totalRowCount && this.totalRowCount != -1) {
            this.rowCount = this.totalRowCount;
        }
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
        this.rowIndex = (pageIndex - 1) * this.rowCount + 1;
    }

    public ElementNode getSortName() {
        return this.sortName;
    }

    public void setSortName(ElementNode sortName) {
        this.sortName = sortName;
        this.rowIndex = 1;
    }

    public ElementNode getSortType() {
        return this.sortType;
    }

    public void setSortType(ElementNode sortType) {
        this.sortType = sortType;
        this.rowIndex = 1;
    }

    public boolean isAscending() {
        return this.sortType.getName().equals("asc");
    }

    public boolean isValidation() {
        return this.isValidation;
    }

    public void setValidation(boolean isValidation) {
        this.isValidation = isValidation;
    }

    protected int getCurrentPageIndex() {
        int rowIndex = this.getRowIndex();
        int rowCount = this.getRowCount();
        int totalRowCount = this.getTotalRowCount();
        if (rowCount == 0) {
            return 1;
        }
        return rowIndex / rowCount + (rowIndex % rowCount == 0 ? 0 : 1);
    }

    protected int getCurrentPageRowCount() {
        int totalPageCount;
        int rowIndex = this.getRowIndex();
        int rowCount = this.getRowCount();
        int totalRowCount = this.getTotalRowCount();
        int currentPageIndex = this.getCurrentPageIndex();
        if (currentPageIndex == (totalPageCount = this.getTotalPageCount())) {
            return totalRowCount - (currentPageIndex - 1) * rowCount;
        }
        return rowCount;
    }

    protected int getTotalPageCount() {
        int rowIndex = this.getRowIndex();
        int rowCount = this.getRowCount();
        int totalRowCount = this.getTotalRowCount();
        if (rowCount == 0) {
            return 1;
        }
        int totalPageCount = totalRowCount / rowCount + (totalRowCount % rowCount == 0 ? 0 : 1);
        if (totalPageCount < 1) {
            totalPageCount = 1;
        }
        return totalPageCount;
    }

    public static void main(String[] args) {
        PaginationContext context = new PaginationContext(26);
        context.setRowIndex(16);
        context.setRowCount(5);
        System.out.println(context.getCurrentPageIndex());
        System.out.println(context.getCurrentPageRowCount());
        System.out.println(context.getTotalPageCount());
    }
}

