/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.context;

import com.nepxion.swing.activex.ActiveXContext;
import com.nepxion.swing.context.DataContextConstants;
import com.nepxion.swing.exception.ExceptionTracerContext;
import com.nepxion.util.context.ContextRegister;
import com.nepxion.util.io.FileContext;
import java.net.URL;
import java.util.Properties;

public class DataContextRegister
extends ContextRegister
implements DataContextConstants {
    public void initializeContext(URL codeBase, Properties properties) {
        super.initializeContext(codeBase, properties);
        this.initActiveX();
        this.initRibbon();
        this.initException();
    }

    private void initActiveX() {
        String activeXEnabled = this.properties.getProperty("activeX-3rd-enabled");
        boolean isActiveXEnabled = false;
        if (this.isValid(activeXEnabled)) {
            isActiveXEnabled = activeXEnabled.equals("true");
        }
        if (isActiveXEnabled) {
            if (this.codeBase == null) {
                ActiveXContext.registerStrategy(0);
            } else {
                ActiveXContext.registerStrategy(1);
            }
        }
    }

    private void initRibbon() {
        String ribbonEnabled = this.properties.getProperty("ribbon-3rd-enabled");
        boolean isRibbonEnabled = false;
        if (this.isValid(ribbonEnabled)) {
            isRibbonEnabled = ribbonEnabled.equals("true");
        }
        if (isRibbonEnabled) {
            try {
                if (this.codeBase == null) {
                    FileContext.register((String)"data/ribbon.xml");
                } else {
                    FileContext.register((URL)this.codeBase, (String)"data/ribbon.xml");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void initException() {
        String exceptionDebugEnabled = this.properties.getProperty("exception-debug-enabled");
        boolean isExceptionDebugEnabled = false;
        if (this.isValid(exceptionDebugEnabled)) {
            isExceptionDebugEnabled = exceptionDebugEnabled.equals("true");
        }
        ExceptionTracerContext.register(isExceptionDebugEnabled);
    }
}

