/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.ui.explorer;

import com.nepxion.swing.tree.JBasicTree;
import com.nepxion.swing.ui.explorer.UIExplorerConstants;
import com.nepxion.swing.ui.explorer.UIExplorerParser;
import com.nepxion.swing.ui.explorer.UIExplorerTreeCellRenderer;
import com.nepxion.swing.ui.explorer.UIExplorerTreeModel;
import com.nepxion.swing.ui.explorer.UIExplorerTreeNode;
import com.nepxion.swing.ui.explorer.UIExplorerTreeSelectionListener;
import java.util.Map;

public class UIExplorerTree
extends JBasicTree {
    private UIExplorerTreeModel treeModel;

    public UIExplorerTree() {
        UIExplorerTreeNode allTreeNode = new UIExplorerTreeNode((Object)UIExplorerConstants.ALL_NAME, UIExplorerParser.parseAllMap());
        UIExplorerTreeNode componentTreeNode = new UIExplorerTreeNode(UIExplorerConstants.COMPONENT_NAME);
        this.parseComponent(componentTreeNode, UIExplorerParser.parseComponentMap());
        UIExplorerTreeNode typeTreeNode = new UIExplorerTreeNode(UIExplorerConstants.TYPE_NAME);
        this.parseType(typeTreeNode, UIExplorerParser.parseTypeMap());
        UIExplorerTreeNode rootTreeNode = new UIExplorerTreeNode(UIExplorerConstants.ROOT_NAME);
        rootTreeNode.add(allTreeNode);
        rootTreeNode.add(componentTreeNode);
        rootTreeNode.add(typeTreeNode);
        this.treeModel = new UIExplorerTreeModel(rootTreeNode);
        this.setModel(this.treeModel);
        this.setCellRenderer(new UIExplorerTreeCellRenderer());
        this.addTreeSelectionListener(new UIExplorerTreeSelectionListener());
        this.getSelectionModel().setSelectionMode(1);
        this.putClientProperty("JTree.lineStyle", "Angled");
    }

    private void parseComponent(UIExplorerTreeNode parentTreeNode, Map map) {
        for (Object key : map.keySet()) {
            Map value = (Map)map.get(key);
            UIExplorerTreeNode treeNode = new UIExplorerTreeNode(key, value);
            parentTreeNode.add(treeNode);
        }
    }

    private void parseType(UIExplorerTreeNode parentTreeNode, Map map) {
        for (int i = 0; i < UIExplorerConstants.CLASS_TYPE_NAMES.length; ++i) {
            String key = UIExplorerConstants.CLASS_TYPE_NAMES[i];
            Object value = map.get(key);
            UIExplorerTreeNode treeNode = new UIExplorerTreeNode((Object)key, value);
            parentTreeNode.add(treeNode);
        }
    }
}

