/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.searcher.gis.google.geo;

import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.table.BasicTableModel;
import com.nepxion.util.searcher.gis.google.geo.GeoEntity;
import java.util.List;

public class GeoTableModel
extends BasicTableModel {
    public static final String[] COLUMN_NAMES = new String[]{SwingLocale.getString("address"), SwingLocale.getString("center_latitude"), SwingLocale.getString("center_longitude"), SwingLocale.getString("north_latitude"), SwingLocale.getString("south_latitude"), SwingLocale.getString("west_longitude"), SwingLocale.getString("east_longitude")};

    public GeoTableModel(List rowDatas) {
        super(rowDatas, COLUMN_NAMES);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return true;
    }

    @Override
    public Object getValueAt(int row, int column) {
        GeoEntity entity = (GeoEntity)this.rowDatas.get(row);
        switch (column) {
            case 0: {
                return entity.getAddress();
            }
            case 1: {
                return entity.getCenterLatitude() + "";
            }
            case 2: {
                return entity.getCenterLongitude() + "";
            }
            case 3: {
                return entity.getNorthLatitude() + "";
            }
            case 4: {
                return entity.getSouthLatitude() + "";
            }
            case 5: {
                return entity.getWestLongitude() + "";
            }
            case 6: {
                return entity.getEastLongitude() + "";
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        GeoEntity entity = (GeoEntity)this.rowDatas.get(row);
        switch (column) {
            case 0: {
                entity.setAddress(value.toString());
                break;
            }
            case 1: {
                entity.setCenterLatitude(Double.parseDouble(value.toString()));
                break;
            }
            case 2: {
                entity.setCenterLongitude(Double.parseDouble(value.toString()));
                break;
            }
            case 3: {
                entity.setNorthLatitude(Double.parseDouble(value.toString()));
                break;
            }
            case 4: {
                entity.setSouthLatitude(Double.parseDouble(value.toString()));
                break;
            }
            case 5: {
                entity.setWestLongitude(Double.parseDouble(value.toString()));
                break;
            }
            case 6: {
                entity.setEastLongitude(Double.parseDouble(value.toString()));
            }
        }
        this.fireTableDataChanged();
    }
}

