/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.button;

import com.nepxion.swing.button.BasicButtonModel;
import com.nepxion.swing.button.IButton;
import com.nepxion.swing.dimension.DimensionManager;
import com.nepxion.swing.listener.DisplayAbilityListener;
import java.awt.Dimension;
import java.awt.event.HierarchyEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.plaf.ButtonUI;

public class JBasicButton
extends JButton
implements IButton {
    protected int widthInset = 5;
    protected int heightInset = 5;
    protected boolean isDimensionAdaptive = true;

    public JBasicButton() {
        this.initComponents();
    }

    public JBasicButton(Action action) {
        super(action);
        this.initComponents();
    }

    public JBasicButton(String text) {
        super(text);
        this.initComponents();
    }

    public JBasicButton(Icon icon) {
        super(icon);
        this.initComponents();
    }

    public JBasicButton(String text, Icon icon) {
        super(text, icon);
        this.initComponents();
    }

    public JBasicButton(String text, String toolTipText) {
        super(text);
        this.initComponents();
        this.setToolTipText(toolTipText);
    }

    public JBasicButton(Icon icon, String toolTipText) {
        super(icon);
        this.initComponents();
        this.setToolTipText(toolTipText);
    }

    public JBasicButton(String text, Icon icon, String toolTipText) {
        super(text, icon);
        this.initComponents();
        this.setToolTipText(toolTipText);
    }

    private void initComponents() {
        this.setModel(new BasicButtonModel());
        this.addHierarchyListener(new DisplayAbilityListener(){

            @Override
            public void displayAbilityChanged(HierarchyEvent e) {
                JBasicButton.this.adaptDimension();
                JBasicButton.this.removeHierarchyListener(this);
            }
        });
    }

    private void adaptDimension() {
        if (this.isDimensionAdaptive) {
            Dimension dimension = this.getPreferredSize();
            int width = dimension.width;
            width = width % 2 != 0 ? (width += this.widthInset) : (width += this.widthInset + 1);
            dimension.width = width;
            int height = dimension.height;
            height = height % 2 != 0 ? (height += this.heightInset) : (height += this.heightInset + 1);
            dimension.height = height;
            this.setDimension(dimension);
        }
    }

    @Override
    public int getWidthInset() {
        return this.widthInset;
    }

    @Override
    public void setWidthInset(int widthInset) {
        this.widthInset = widthInset;
    }

    @Override
    public int getHeightInset() {
        return this.heightInset;
    }

    @Override
    public void setHeightInset(int heightInset) {
        this.heightInset = heightInset;
    }

    @Override
    public void setDimension(Dimension dimension) {
        DimensionManager.setDimension(this, dimension);
        this.isDimensionAdaptive = false;
    }

    @Override
    public void setUI(ButtonUI buttonUI) {
        super.setUI(buttonUI);
        this.setOpaque(false);
    }

    @Override
    public void updateUI() {
        this.setUI(this.getUI());
    }
}

