/*
 * Decompiled with CFR 0.152.
 */
package twaver.gis.utils;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.undo.CannotUndoException;
import twaver.A.A.C.A.A;
import twaver.A.A.C.A.B;
import twaver.A.A.C.E;
import twaver.BTSAntenna;
import twaver.Element;
import twaver.GeoCoordinate;
import twaver.Group;
import twaver.Link;
import twaver.Node;
import twaver.ShapeNode;
import twaver.TWaverUtil;
import twaver.gis.GeographyFeature;
import twaver.gis.GeographyMap;
import twaver.gis.GisManager;
import twaver.gis.event.OnReadyListener;
import twaver.gis.gadget.GridBbox;
import twaver.gis.ogc.WFSUtils;
import twaver.gis.ogc.WMSUtils;
import twaver.network.TNetwork;

public class GisToolkits {
    private static Random B = new Random();
    private static Random C = new Random();
    private static Random A = new Random();
    private static Random D = new Random();
    private static final DecimalFormat[] E = new DecimalFormat[]{new DecimalFormat("####"), new DecimalFormat("####.0"), new DecimalFormat("####.00"), new DecimalFormat("####.000"), new DecimalFormat("####.0000")};
    static /* synthetic */ Class class$0;

    public static Color getRandomColor() {
        int red = Math.abs(B.nextInt(200) % 255);
        int green = Math.abs(C.nextInt(200) % 255);
        int blue = Math.abs(A.nextInt(200) % 255);
        return new Color(red, green, blue);
    }

    public static GeographyMap createDefaultMap() {
        return new B();
    }

    private static GeographyMap A(int type) {
        return GisToolkits.createDefaultMap();
    }

    public static final Image getImage(String path) {
        ImageIcon icon;
        URL url;
        Image result = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("twaver.gis.utils.GisToolkits");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((url = clazz.getResource(path)) != null && (icon = new ImageIcon(url)) != null) {
            result = icon.getImage();
        }
        return result;
    }

    public static String getFormatNumber(double value, int decimal) {
        if (decimal <= E.length) {
            return E[decimal].format(value);
        }
        return "" + value;
    }

    public static final ImageIcon getImageIcon(String path) {
        return TWaverUtil.getImageIcon((String)path);
    }

    public static Container getTopContainer(JComponent component) {
        Container son = component;
        for (Container parent = component.getParent(); parent != null; parent = parent.getParent()) {
            son = parent;
            if (!(son instanceof Applet)) continue;
            return son;
        }
        return son;
    }

    public static void goBack(TNetwork network, GeographyMap map) {
        try {
            map.goBack();
        }
        catch (CannotUndoException ex) {
            JOptionPane.showMessageDialog((Component)network, twaver.A.A.A.A.E("error_zoomback"));
        }
    }

    public static void locateElement(Element element, GeographyMap map) {
        Point2D result = GisToolkits.getScreenLocation(element, map);
        if (result != null) {
            double w = element.getWidth();
            double h = element.getHeight();
            element.setLocation(result.getX() - w / 2.0, result.getY() - h / 2.0);
        }
    }

    public static Point2D getScreenLocation(Element element, GeographyMap map) {
        if (!(element instanceof BTSAntenna || element instanceof Link || element instanceof ShapeNode || element instanceof Group)) {
            Object o = element.getClientProperty((Object)"geocoordinates");
            if (!(o instanceof GeoCoordinate)) {
                return null;
            }
            GeoCoordinate coordinate = (GeoCoordinate)o;
            if (coordinate != null && map != null && map.getViewport() != null) {
                return twaver.A.A.C.E.A(coordinate, map.getViewportBounds(), map.getZoom(), map.getProjectionType(), 256, 256);
            }
        }
        return null;
    }

    public static Rectangle2D getVisibleElementsBounds(TNetwork network, GeographyMap map) {
        Object[] elements = network.getDataBox().getAllElements().toArray();
        double maxX = Double.MIN_VALUE;
        double maxY = Double.MIN_VALUE;
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        int i = 0;
        while (i < elements.length) {
            Rectangle bounds;
            Element element = (Element)elements[i];
            if (network.isVisible(element) && (bounds = element.getBounds()) != null) {
                double x = bounds.getX();
                double y = bounds.getY();
                maxX = Math.max(maxX, x + (double)bounds.width);
                maxY = Math.max(maxY, y + (double)bounds.height);
                minX = Math.min(minX, x - (double)bounds.width);
                minY = Math.min(minY, y - (double)bounds.height);
            }
            ++i;
        }
        GeoCoordinate ul = GisToolkits.convertScreenToLatLong(map, new Point2D.Double(minX, maxY));
        GeoCoordinate br = GisToolkits.convertScreenToLatLong(map, new Point2D.Double(maxX, minY));
        return new Rectangle2D.Double(ul.getLongitude(), br.getLatitude(), br.getLongitude() - ul.getLongitude(), ul.getLatitude() - br.getLatitude());
    }

    public static double getDegree(double[] degreeDescription) {
        return degreeDescription[0] + (degreeDescription[1] + degreeDescription[2] / 60.0) / 60.0;
    }

    public static GeoCoordinate convertScreenToLatLong(GeographyMap map, Point2D screenPoint) {
        return GisToolkits.convertScreenToLatLong(map, screenPoint.getX(), screenPoint.getY());
    }

    public static GeoCoordinate convertScreenToLatLong(GeographyMap map, double screenX, double screenY) {
        double[] ll;
        GeoCoordinate co = null;
        if (map != null && (ll = map.getLL(screenX, screenY)) != null) {
            co = new GeoCoordinate(ll[0], ll[1]);
        }
        return co;
    }

    public static Point2D convertLatLongToScreen(GeographyMap map, double longitude, double latitude) {
        Point2D.Double point = null;
        double[] xy = new double[2];
        xy = map.getXY(longitude, latitude);
        point = new Point2D.Double(xy[0], xy[1]);
        return point;
    }

    public static Point2D convertLatLongToScreen(GeographyMap map, GeoCoordinate co) {
        return GisToolkits.convertLatLongToScreen(map, co.getLongitude(), co.getLatitude());
    }

    public static void setGeographicalCoordinate(GeographyMap map, Element element) {
        if (element instanceof BTSAntenna) {
            return;
        }
        if (element instanceof Link) {
            return;
        }
        if (element instanceof Group) {
            Group group = (Group)element;
            List children = group.getChildren();
            Iterator iterator = children.iterator();
            while (iterator.hasNext()) {
                Element son = (Element)iterator.next();
                GisToolkits.setGeographicalCoordinate(map, son);
            }
            return;
        }
        if (element instanceof Node) {
            double x = element.getX();
            double y = element.getY();
            double w = element.getWidth();
            double h = element.getHeight();
            GeoCoordinate coordinate = null;
            B tm = (B)map;
            double[] ll = tm.getLL(x += w / 2.0, y += h / 2.0);
            if (ll != null) {
                coordinate = new GeoCoordinate(ll[0], ll[1]);
            }
            element.putClientProperty((Object)"geocoordinates", coordinate);
        }
    }

    private static GeneralPath A(List points, List segments) {
        int pCount = points.size();
        int sCount = segments.size();
        GeneralPath path = new GeneralPath();
        int pIndex = 0;
        int sIndex = 0;
        while (sIndex < sCount) {
            int segment = (Integer)segments.get(sIndex);
            switch (segment) {
                case 0: {
                    if (pIndex >= pCount) {
                        return path;
                    }
                    Point2D p = (Point2D)points.get(pIndex++);
                    path.moveTo((int)p.getX(), (int)p.getY());
                    break;
                }
                case 1: {
                    if (pIndex >= pCount) {
                        return path;
                    }
                    Point2D p = (Point2D)points.get(pIndex++);
                    path.lineTo((int)p.getX(), (int)p.getY());
                    break;
                }
                case 2: {
                    if (pIndex >= pCount - 1) {
                        return path;
                    }
                    Point2D p1 = (Point2D)points.get(pIndex++);
                    Point2D p2 = (Point2D)points.get(pIndex++);
                    path.quadTo((int)p1.getX(), (int)p1.getY(), (int)p2.getX(), (int)p2.getY());
                    break;
                }
                case 3: {
                    if (pIndex >= pCount - 2) {
                        return path;
                    }
                    Point2D p1 = (Point2D)points.get(pIndex++);
                    Point2D p2 = (Point2D)points.get(pIndex++);
                    Point2D p3 = (Point2D)points.get(pIndex++);
                    path.curveTo((int)p1.getX(), (int)p1.getY(), (int)p2.getX(), (int)p2.getY(), (int)p3.getX(), (int)p3.getY());
                    break;
                }
                case 4: {
                    path.closePath();
                }
            }
            ++sIndex;
        }
        return path;
    }

    private static GeneralPath A(List points, int count) {
        GeneralPath path = new GeneralPath();
        Point2D point = (Point2D)points.get(0);
        path.moveTo((int)point.getX(), (int)point.getY());
        int i = 1;
        while (i < count) {
            point = (Point2D)points.get(i);
            path.lineTo((int)point.getX(), (int)point.getY());
            ++i;
        }
        return path;
    }

    public static List getRegionPath(GeographyMap map, ShapeNode region, boolean optimize) {
        Object points = region.getClientProperty((Object)"shape_bounds");
        if (map != null && points instanceof List && ((List)points).size() > 0) {
            List list = (List)points;
            return GisToolkits.getFeaturePoints(map, list, true, optimize);
        }
        return null;
    }

    public static List getFeaturePoints(GeographyMap map, List list, boolean toScreenPoint, boolean optimize) {
        if (map != null && list != null && list.size() > 0) {
            if (list.get(0) instanceof List) {
                List shapePoints = (List)list.get(0);
                List segments = (List)list.get(1);
                Vector result = new Vector();
                return GisToolkits.A(shapePoints, segments, map, toScreenPoint, optimize);
            }
            return GisToolkits.A(list, null, map, toScreenPoint, optimize);
        }
        return null;
    }

    public static Shape getGeographyFeatureShape(GeographyMap map, GeographyFeature feature) {
        if (feature instanceof twaver.A.A.C.I.A) {
            List ps = GisToolkits.getFeaturePoints(map, ((twaver.A.A.C.I.A)feature).getPoints(), true, true);
            Object shapePoints = ps.get(0);
            if (shapePoints instanceof List) {
                return GisToolkits.A((List)shapePoints, (List)ps.get(1));
            }
            return GisToolkits.A(ps, ps.size());
        }
        return null;
    }

    private static List A(List points, List segments, GeographyMap map, boolean toScreenPoint, boolean optimize) {
        Iterator iterator = points.iterator();
        Vector<Point2D> vp = new Vector<Point2D>();
        Vector seg = new Vector();
        Point2D cache = new Point2D.Double();
        int i = 0;
        while (iterator.hasNext()) {
            GeoCoordinate p = (GeoCoordinate)iterator.next();
            Point2D sp = GisToolkits.convertLatLongToScreen(map, p);
            boolean doOptimize = true;
            if (optimize) {
                doOptimize = GisToolkits.A(sp, cache, GisToolkits.A(map));
            }
            if (doOptimize) {
                if (toScreenPoint) {
                    vp.add(sp);
                } else {
                    vp.add((Point2D)p);
                }
                cache = sp;
                if (segments != null) {
                    seg.add(segments.get(i));
                }
            }
            ++i;
        }
        Vector result = new Vector(2);
        result.add(vp);
        result.add(seg);
        return result;
    }

    static boolean A(Point2D source, Point2D reference, double distanceTolerance) {
        return reference.distance(source) > distanceTolerance;
    }

    private static double A(A map) {
        int zoom = map.getZoom();
        int[] result = (int[])GisManager.getDefaultSetting("optimize.gepmetry.distance");
        if (result == null) {
            result = GisManager.getDefaultOptimizeDistance();
            GisManager.registerDefaultSetting("optimize.gepmetry.distance", result);
        }
        return result[zoom];
    }

    static double A(GeographyMap map) {
        return GisToolkits.A((A)map);
    }

    public static List getWMSCapabilities(int executorType, String WMSURL) {
        return WMSUtils.getWMSAbilities(executorType, WMSURL);
    }

    public static List getWFSLayers(int executorType, String WFSURL) {
        return WFSUtils.getWFSLayers(executorType, WFSURL);
    }

    public static String getWFSCapabilities(int executorType, String WFSURL) {
        return WFSUtils.getWFSAbilities(executorType, WFSURL);
    }

    public static String getServerByExecutorType(int executorType) {
        return twaver.A.A.C.G.A.A(executorType);
    }

    public static int getAppropriateZoomLevel(GridBbox bbox, GeographyMap map) {
        GeoCoordinate upLeft = new GeoCoordinate(bbox.getMinx(), bbox.getMaxy());
        GeoCoordinate bottomRight = new GeoCoordinate(bbox.getMaxx(), bbox.getMiny());
        Rectangle viewport = map.getViewport();
        int i = map.getZoomLowLimit();
        while (i <= map.getZoomUpLimit()) {
            Point2D upLeftPixel = twaver.A.A.C.E.A(upLeft, i, map.getProjectionType());
            Point2D bottomRightPixel = twaver.A.A.C.E.A(bottomRight, i, map.getProjectionType());
            double w = Math.abs(bottomRightPixel.getX() - upLeftPixel.getX());
            double h = Math.abs(bottomRightPixel.getY() - upLeftPixel.getY());
            if (w > ((RectangularShape)viewport).getWidth() || h > ((RectangularShape)viewport).getHeight()) {
                return i - 1;
            }
            ++i;
        }
        return map.getZoomUpLimit();
    }

    public static Point2D getScreenPointFromGeoPoint(GeoCoordinate geoPoint, GeoCoordinate mapCenter, int viewWidth, int viewHeight, int zoomLevel, int projectionType) {
        return twaver.A.A.C.E.A(geoPoint, mapCenter, viewWidth, viewHeight, zoomLevel, projectionType, 256, 256);
    }

    public static GeoCoordinate getGeoPointFromScreenPoint(double x, double y, GeoCoordinate mapCenter, int viewWidth, int viewHeight, int zoomLevel, int projectionType) {
        return twaver.A.A.C.E.A(x, y, mapCenter, viewWidth, viewHeight, zoomLevel, projectionType, 256, 256);
    }

    public static Point2D getPixelXY(GeoCoordinate geoPoint, int zoomLevel, int projectionType) {
        return twaver.A.A.C.E.A(geoPoint, zoomLevel, projectionType);
    }

    public static GeoCoordinate getGeoPointFromPixelXY(double pixelx, double pixely, int zoomLevel, int projectionType) {
        return twaver.A.A.C.E.A(pixelx, pixely, zoomLevel, projectionType);
    }

    public static void addOnReadyListener(OnReadyListener listener) {
        twaver.A.A.C.G.A.A(listener);
    }
}

