/*
 * Decompiled with CFR 0.152.
 */
package y.view;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import y.base.EdgeCursor;
import y.base.Graph;
import y.io.BadVersionException;
import y.view.EdgeRealizer;
import y.view.Graph2D;
import y.view.NodeLabel;
import y.view.NodeRealizer;
import y.view.ShapeNodeRealizer;
import y.view.YRenderingHints;
import y.view.hierarchy.HierarchyManager;

public class Graph2DNodeRealizer
extends ShapeNodeRealizer {
    private Graph2D ae;
    private boolean ad;
    private boolean af;
    private boolean ag;

    public Graph2DNodeRealizer() {
        this.d();
    }

    public Graph2DNodeRealizer(NodeRealizer nodeRealizer) {
        super(nodeRealizer);
        if (nodeRealizer instanceof Graph2DNodeRealizer) {
            Graph2DNodeRealizer graph2DNodeRealizer = (Graph2DNodeRealizer)nodeRealizer;
            this.ae = graph2DNodeRealizer.ae;
            this.ad = graph2DNodeRealizer.ad;
            this.af = graph2DNodeRealizer.af;
            this.ag = graph2DNodeRealizer.ag;
        } else {
            this.d();
        }
    }

    private void d() {
        this.ad = true;
        this.af = false;
        this.ag = true;
    }

    public void setApplyClipping(boolean bl) {
        this.af = bl;
    }

    public void setApplyTransformation(boolean bl) {
        this.ag = bl;
    }

    public boolean getApplyTransformation() {
        return this.ag;
    }

    public boolean getApplyClipping() {
        return this.af;
    }

    public void setExpanded(boolean bl) {
        if (bl != this.ad) {
            this.ad = bl;
        }
    }

    public boolean isExpanded() {
        return this.ad;
    }

    public void setInnerGraph(Graph2D graph2D) {
        this.ae = graph2D;
    }

    public Graph2D getInnerGraph() {
        if (this.ae != null) {
            return this.ae;
        }
        try {
            Graph graph = this.getNode().getGraph();
            HierarchyManager hierarchyManager = HierarchyManager.getInstance(graph);
            return (Graph2D)hierarchyManager.getInnerGraph(this.getNode());
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void paintNode(Graphics2D graphics2D) {
        if (!this.isExpanded()) {
            super.paintNode(graphics2D);
        } else {
            super.paintNode(graphics2D);
            if (this.ae != null) {
                this.paintInnerGraph(graphics2D);
            }
        }
    }

    public void paintSloppy(Graphics2D graphics2D) {
        Double d2;
        super.paintSloppy(graphics2D);
        if (this.isExpanded() && (d2 = (Double)graphics2D.getRenderingHint(YRenderingHints.PAINT_DETAIL_THRESHOLD_KEY)) != null && d2 < Double.MAX_VALUE) {
            this.paintInnerGraph(graphics2D);
        }
    }

    protected void paintInnerGraph(Graphics2D graphics2D) {
        double d2 = 10.0;
        double d3 = this.getHeight() - d2 * 2.0;
        double d4 = this.getWidth() - d2 * 2.0;
        double d5 = this.getCenterX();
        double d6 = this.getCenterY();
        NodeLabel nodeLabel = this.getLabel();
        block0 : switch (nodeLabel.getModel()) {
            case 1: {
                switch (nodeLabel.getPosition()) {
                    case 102: {
                        d3 -= nodeLabel.getHeight();
                        d6 += nodeLabel.getHeight() / 2.0;
                        break block0;
                    }
                    case 101: {
                        d3 -= nodeLabel.getHeight();
                        d6 -= nodeLabel.getHeight() / 2.0;
                        break block0;
                    }
                    case 115: {
                        d4 -= nodeLabel.getWidth();
                        d5 += nodeLabel.getWidth() / 2.0;
                        break block0;
                    }
                    case 116: {
                        d4 -= nodeLabel.getWidth();
                        d5 -= nodeLabel.getWidth() / 2.0;
                    }
                }
            }
        }
        if (d4 <= 5.0 || d3 <= 5.0) {
            return;
        }
        Shape shape = null;
        double d7 = 1.0;
        double d8 = 1.0;
        double d9 = 1.0;
        AffineTransform affineTransform = graphics2D.getTransform();
        if (this.getApplyClipping()) {
            shape = graphics2D.getClip();
            graphics2D.clip(new Rectangle2D.Double(this.getX(), this.getY(), d4, d3));
        }
        graphics2D.translate(d5, d6);
        if (this.getApplyTransformation()) {
            Rectangle rectangle = this.ae.getBoundingBox();
            d7 = d4 / rectangle.getWidth();
            d8 = d3 / rectangle.getHeight();
            d9 = Math.min(d7, d8);
            graphics2D.scale(d9, d9);
            graphics2D.translate(-rectangle.getCenterX(), -rectangle.getCenterY());
        }
        double d10 = d9 * affineTransform.getScaleX();
        Double d11 = (Double)graphics2D.getRenderingHint(YRenderingHints.PAINT_DETAIL_THRESHOLD_KEY);
        if (d11 == null || d10 > d11) {
            Object object;
            EdgeCursor edgeCursor = this.ae.edges();
            while (edgeCursor.ok()) {
                object = this.ae.getRealizer(edgeCursor.edge());
                ((EdgeRealizer)object).paint(graphics2D);
                edgeCursor.next();
            }
            object = this.ae.nodes();
            while (object.ok()) {
                NodeRealizer nodeRealizer = this.ae.getRealizer(object.node());
                nodeRealizer.paint(graphics2D);
                object.next();
            }
        } else if (d11 == null || 4.0 * d10 > d11) {
            Object object;
            EdgeCursor edgeCursor = this.ae.edges();
            while (edgeCursor.ok()) {
                object = this.ae.getRealizer(edgeCursor.edge());
                ((EdgeRealizer)object).paintSloppy(graphics2D);
                edgeCursor.next();
            }
            object = this.ae.nodes();
            while (object.ok()) {
                NodeRealizer nodeRealizer = this.ae.getRealizer(object.node());
                nodeRealizer.paintSloppy(graphics2D);
                object.next();
            }
        }
        if (this.getApplyClipping()) {
            graphics2D.setClip(shape);
        }
        graphics2D.setTransform(affineTransform);
    }

    public NodeRealizer createCopy(NodeRealizer nodeRealizer) {
        return new Graph2DNodeRealizer(nodeRealizer);
    }

    public void write(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeByte(0);
        super.write(objectOutputStream);
        objectOutputStream.writeBoolean(this.ad);
        objectOutputStream.writeBoolean(this.af);
        objectOutputStream.writeBoolean(this.ag);
    }

    public void read(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        switch (objectInputStream.readByte()) {
            case 0: {
                super.read(objectInputStream);
                this.ad = objectInputStream.readBoolean();
                this.af = objectInputStream.readBoolean();
                this.ag = objectInputStream.readBoolean();
                break;
            }
            default: {
                throw new BadVersionException();
            }
        }
    }
}

