/*
 * Decompiled with CFR 0.152.
 */
package twaver.chart;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import twaver.Element;
import twaver.TDataBox;
import twaver.TUIManager;
import twaver.TWaverConst;
import twaver.base.A.A.J;
import twaver.base.A.D.O;
import twaver.base.A.E.a;
import twaver.base.A.E.d;
import twaver.chart.AbstractChart;
import twaver.chart.C;
import twaver.web.svg.chart.AbstractSVGChart;
import twaver.web.svg.chart.SVGPieChart;
import twaver.web.svg.network.SVGContext;

public class PieChart
extends AbstractChart {
    private boolean \u046c = TUIManager.getBoolean("tchart.hollow");
    private double \u0466 = TUIManager.getDouble("tchart.hollow.percent");
    private boolean \u046b = TUIManager.getBoolean("tchart.value.text.percent");
    private double \u046a = TUIManager.getDouble("tchart.start.angle");
    private Color \u0468 = TUIManager.getColor("tchart.shadow.color");
    private boolean \u046e = TUIManager.getBoolean("tchart.pie.3d");
    private double \u046f = TUIManager.getDouble("tchart.pie.value.text.position.scale");
    private Rectangle2D.Double \u0465;
    private double \u046d = 0.0;
    private double \u0469 = 0.0;
    private double \u0464 = 0.0;
    private double \u0467 = 0.0;

    public PieChart() {
        this(new TDataBox());
    }

    public PieChart(TDataBox box) {
        super(box, null, null);
    }

    public PieChart(TDataBox box, String title, Color backgroundColor) {
        super(box, title, backgroundColor, null);
    }

    public PieChart(TDataBox box, String title, Color backgroundColor, Color foregroundColor) {
        super(box, title, backgroundColor, foregroundColor);
    }

    public PieChart(List items) {
        super(items);
    }

    public PieChart(List items, String title) {
        super(items, title);
    }

    public PieChart(List items, String title, Color backgroundColor) {
        super(items, title, backgroundColor);
    }

    public PieChart(List items, String title, Color backgroundColor, Color foregroundColor) {
        super(items, title, backgroundColor, foregroundColor);
    }

    protected boolean isAppearable(Element element) {
        return true;
    }

    protected Rectangle2D.Double getDrawBound() {
        return this.\u0465;
    }

    protected List getLegendElements() {
        ArrayList list = new ArrayList(super.getLegendElements());
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            if (this.isAppearable(element)) continue;
            it.remove();
        }
        return list;
    }

    protected void calculate() {
        Element element;
        int i2;
        this.sum = 0.0;
        this.proportionsOfSum.clear();
        int count = this.publishedElements.size();
        for (i2 = 0; i2 < count; ++i2) {
            element = (Element)this.publishedElements.get(i2);
            double value = this.getValue(element);
            this.sum += value;
        }
        for (i2 = 0; i2 < count; ++i2) {
            element = (Element)this.publishedElements.get(i2);
            if (this.sum == 0.0) {
                this.proportionsOfSum.add(new Double(0.0));
                continue;
            }
            this.proportionsOfSum.add(new Double(this.getValue(element) / this.sum));
        }
    }

    private Shape B(double x, double y, double w, double h2, double start, double extent) {
        Arc2D.Double shape = new Arc2D.Double(x, y, w, h2, start, extent, 2);
        if (this.\u046c) {
            Area area = new Area(shape);
            double cx = shape.getCenterX();
            double cy = shape.getCenterY();
            double sw = shape.getWidth() * this.\u0466;
            double sh = shape.getHeight() * this.\u0466;
            Ellipse2D.Double ellipse = new Ellipse2D.Double(cx - sw / 2.0, cy - sh / 2.0, sw, sh);
            area.subtract(new Area(ellipse));
            return area;
        }
        return shape;
    }

    public void paintChart(Graphics2D g2d, int width, int height) {
        g2d.setStroke(TWaverConst.BASIC_STROKE);
        this.calculateLabelSize();
        this.backgroundBounds.x = (int)((double)this.xGap + this.\u046d);
        this.backgroundBounds.y = (int)((double)this.yGap + this.\u0469);
        this.backgroundBounds.width = (int)((double)(width - 2 * this.xGap) - 2.0 * this.\u046d);
        this.backgroundBounds.height = (int)((double)((height -= this.shadowOffset) - 2 * this.yGap + this.shadowOffset) - 2.0 * this.\u0469);
        this.\u0464 = 0.0;
        this.\u0467 = 0.0;
        if (this.\u046f >= 1.0) {
            this.\u0464 = ((double)(width - 2 * this.xGap) - 2.0 * this.\u046d) / 2.0 * (this.\u046f - 1.0);
            this.\u0467 = ((double)(height - 2 * this.yGap) - 2.0 * this.\u0469) / 2.0 * (this.\u046f - 1.0);
            this.\u0465 = new Rectangle2D.Double((double)this.xGap + this.\u046d + this.\u0464, (double)this.yGap + this.\u0469 + this.\u0467, (double)(width - 2 * this.xGap) - 2.0 * this.\u046d - 2.0 * this.\u0464, (double)(height - 2 * this.yGap) - 2.0 * this.\u0469 - 2.0 * this.\u0467);
        } else {
            this.\u0465 = new Rectangle2D.Double(this.xGap, this.yGap, width - 2 * this.xGap, height - 2 * this.yGap);
        }
        this.paintBackground(g2d);
        if (this.sum == 0.0) {
            return;
        }
        if (this.is3D()) {
            this.B(g2d, width, height);
        } else {
            this.A(g2d, width, height);
        }
    }

    protected void calculateLabelSize() {
        int count = this.publishedElements.size();
        this.\u046d = 0.0;
        this.\u0469 = 0.0;
        if (this.\u046f < 1.0) {
            return;
        }
        for (int i2 = 0; i2 < count; ++i2) {
            Dimension size;
            Element element = (Element)this.publishedElements.get(i2);
            String text = this.getFormatedText(element, this.getValue(element));
            Double proportion = (Double)this.proportionsOfSum.get(i2);
            if (this.\u046b) {
                text = text + "(" + (int)(proportion * 100.0) + "%)";
            }
            if (this.\u046d < (size = this.B(text, this.valueTextFont)).getWidth()) {
                this.\u046d = size.getWidth();
            }
            if (!(this.\u0469 < size.getHeight())) continue;
            this.\u0469 = size.getHeight();
        }
    }

    private void A(Graphics2D g2d, int width, int height) {
        int offset;
        double value;
        Double proportion;
        Element element;
        int i2;
        int count = this.publishedElements.size();
        double start = this.\u046a;
        for (i2 = 0; i2 < count; ++i2) {
            element = (Element)this.publishedElements.get(i2);
            proportion = (Double)this.proportionsOfSum.get(i2);
            value = 360.0 * proportion;
            if (value == 0.0) continue;
            if (this.isAppearable(element)) {
                offset = element.isSelected() ? -this.selectedOffset : 0;
                Shape pieShadow = this.B(this.\u0465.getX(), this.\u0465.getY() + (double)this.shadowOffset + (double)offset, this.\u0465.getWidth(), this.\u0465.getHeight(), start, value);
                g2d.setColor(this.\u0468);
                g2d.fill(pieShadow);
            }
            start += value;
        }
        start = this.\u046a;
        for (i2 = 0; i2 < count; ++i2) {
            element = (Element)this.publishedElements.get(i2);
            proportion = (Double)this.proportionsOfSum.get(i2);
            value = 360.0 * proportion;
            if (value == 0.0) continue;
            if (!element.isSelected()) {
                this.drawBody(g2d, width, height, start, element, value);
            }
            start += value;
        }
        start = this.\u046a;
        for (i2 = 0; i2 < count; ++i2) {
            element = (Element)this.publishedElements.get(i2);
            proportion = (Double)this.proportionsOfSum.get(i2);
            value = 360.0 * proportion;
            if (value == 0.0) continue;
            if (element.isSelected()) {
                this.drawBody(g2d, width, height, start, element, value);
            }
            start += value;
        }
        start = this.\u046a;
        for (i2 = 0; i2 < count; ++i2) {
            element = (Element)this.publishedElements.get(i2);
            proportion = (Double)this.proportionsOfSum.get(i2);
            value = 360.0 * proportion;
            if (value == 0.0) continue;
            if (this.isAppearable(element)) {
                int n2 = offset = element.isSelected() ? -this.selectedOffset : 0;
                if (this.valueTextVisible) {
                    String text = this.getFormatedText(element, this.getValue(element));
                    if (this.\u046b) {
                        text = text + "(" + (int)(proportion * 100.0) + "%)";
                    }
                    if (text != null) {
                        Arc2D.Double pie = new Arc2D.Double(this.\u0465.getX(), this.\u0465.getY() + (double)offset, this.\u0465.getWidth(), this.\u0465.getHeight(), start, value, 2);
                        double cx = pie.getCenterX();
                        double cy = pie.getCenterY();
                        if (this.\u046f >= 1.0) {
                            Arc2D.Double s2 = new Arc2D.Double(this.\u0465.getX() - this.\u0464, this.\u0465.getY() + (double)offset - this.\u0467, this.\u0465.getWidth() + 2.0 * this.\u0464, this.\u0465.getHeight() + 2.0 * this.\u0467, start, value / 2.0, 2);
                            int position = this.getLabelTextPosition(-(start + value / 2.0));
                            Point2D p2 = s2.getEndPoint();
                            this.A(g2d, text, this.valueTextColor, this.valueTextFont, (int)p2.getX(), (int)p2.getY(), position);
                        } else {
                            double sw = pie.getWidth() * this.\u046f;
                            double sh = pie.getHeight() * this.\u046f;
                            Arc2D.Double s2 = new Arc2D.Double(cx - sw / 2.0, cy - sh / 2.0, sw, sh, pie.getAngleStart() + pie.getAngleExtent() / 2.0, 1.0, 2);
                            Point2D p3 = s2.getStartPoint();
                            this.A(g2d, text, this.valueTextColor, this.valueTextFont, (int)p3.getX(), (int)p3.getY(), 1);
                        }
                    }
                }
                Shape shape = this.B(this.\u0465.getX(), this.\u0465.getY() + (double)offset, this.\u0465.getWidth(), this.\u0465.getHeight(), start, value);
                this.shapeStructs.add(0, new C(shape, element, this.getToolTipText(element)));
            }
            start += value;
        }
    }

    protected int getLabelTextPosition(double angle) {
        angle = (angle % 360.0 + 360.0) % 360.0;
        int position = 1;
        if (angle == 0.0) {
            position = 5;
        }
        if (angle == 180.0) {
            position = 4;
        }
        if (angle == 90.0) {
            position = 3;
        }
        if (angle == 270.0) {
            position = 2;
        }
        if (angle > 270.0 && angle < 360.0) {
            position = 7;
        }
        if (angle > 180.0 && angle < 270.0) {
            position = 6;
        }
        if (angle > 90.0 && angle < 180.0) {
            position = 8;
        }
        if (angle > 0.0 && angle < 90.0) {
            position = 9;
        }
        return position;
    }

    protected void drawBody(Graphics2D g2d, int width, int height, double start, Element element, double value) {
        if (!this.isAppearable(element)) {
            return;
        }
        int offset = element.isSelected() ? -this.selectedOffset : 0;
        Shape shape = this.B(this.\u0465.getX(), this.\u0465.getY() + (double)offset, this.\u0465.getWidth(), this.\u0465.getHeight(), start, value);
        g2d.setColor(this.getColor(element));
        g2d.fill(shape);
        if (element.isSelected()) {
            g2d.setStroke(this.getSelectedStroke(element));
            g2d.setColor(this.getSelectedColor(element));
            g2d.draw(shape);
        }
    }

    public double getStartAngle() {
        return this.\u046a;
    }

    public void setStartAngle(double startAngle) {
        this.\u046a = startAngle;
        this.chartPane.repaint();
    }

    public boolean isValueTextPercent() {
        return this.\u046b;
    }

    public void setValueTextPercent(boolean valueTextPercent) {
        this.\u046b = valueTextPercent;
        this.chartPane.repaint();
    }

    public Color getShadowColor() {
        return this.\u0468;
    }

    public void setShadowColor(Color shadowColor) {
        this.\u0468 = shadowColor;
        this.chartPane.repaint();
    }

    public boolean isHollow() {
        return this.\u046c;
    }

    public void setHollow(boolean hollow) {
        this.\u046c = hollow;
        this.chartPane.repaint();
    }

    public double getHollowPercent() {
        return this.\u0466;
    }

    public void setHollowPercent(double hollowPercent) {
        this.\u0466 = hollowPercent;
        this.chartPane.repaint();
    }

    private void B(Graphics2D g2d, int width, int height) {
        _B painter = new _B(this);
        painter.A(g2d, width, height);
    }

    private static boolean B(double betweenAngle, double start, double extend) {
        double distance = 360.0 - start;
        start = 0.0;
        return extend > (betweenAngle = PieChart.C(betweenAngle + distance)) - start;
    }

    public boolean is3D() {
        return this.\u046e;
    }

    public void set3D(boolean is3D) {
        this.\u046e = is3D;
        this.repaint();
    }

    public double getValueTextPositionScale() {
        return this.\u046f;
    }

    public void setValueTextPositionScale(double valueTextPositionScale) {
        this.\u046f = valueTextPositionScale;
        this.chartPane.repaint();
    }

    private static double C(double s1) {
        if ((s1 %= 360.0) < 0.0) {
            s1 += 360.0;
        }
        return s1;
    }

    protected void setChartSVGAttribute(AbstractSVGChart abschart) {
        super.setChartSVGAttribute(abschart);
        SVGPieChart chart = (SVGPieChart)abschart;
        chart.setStartAngle(this.getStartAngle());
        chart.setValueTextPercent(this.isValueTextPercent());
        chart.setShadowColor(this.getShadowColor());
        chart.setHollow(this.isHollow());
        chart.setHollowPercent(this.getHollowPercent());
    }

    public void exportSVG(String fileName, int width, int height) {
        if (fileName == null) {
            return;
        }
        if (!fileName.toLowerCase().endsWith(".svg")) {
            fileName = fileName + ".svg";
        }
        SVGPieChart chart = new SVGPieChart();
        this.setChartSVGAttribute(chart);
        SVGContext context = new SVGContext();
        a.A(fileName, chart.toSVG(context, width, height));
    }

    class _A {
        private double B = 0.0;
        private double E = 0.0;
        private int D = 0;
        private Element A = null;
        private _A C = null;

        public _A(_A parent, int index, Element element, double startAngle, double extendAngle) {
            this.A = element;
            this.B = startAngle;
            this.E = extendAngle;
            this.C = parent;
        }

        public _A(int index, Element element, double startAngle, double extendAngle) {
            this(null, index, element, startAngle, extendAngle);
        }

        public _A A() {
            return this.C;
        }

        public void A(_A parent) {
            this.C = parent;
        }

        public int B() {
            return this.D;
        }

        public void A(int elementIndex) {
            this.D = elementIndex;
        }

        public Element D() {
            return this.A;
        }

        public void A(Element element) {
            this.A = element;
        }

        public double C() {
            this.B %= 360.0;
            if (this.B < 0.0) {
                this.B += 360.0;
            }
            return this.B;
        }

        public void B(double startAngle) {
            this.B = startAngle;
        }

        public double E() {
            return this.E;
        }

        public void A(double extendAngle) {
            this.E = extendAngle;
        }
    }

    class _B {
        PieChart F;
        Area H = null;
        Area D = null;
        Area E = null;
        private Comparator A = new Comparator(this){
            private final /* synthetic */ _B this$1;
            {
                this.this$1 = this$1;
            }

            public int compare(Object o1, Object o2) {
                _A item1 = (_A)o1;
                _A item2 = (_A)o2;
                double s1 = PieChart.access$000(item1.C());
                double e1 = item1.E();
                double s2 = PieChart.access$000(item2.C());
                double e2 = item2.E();
                if (s1 >= 90.0 && s1 <= 270.0 && s2 >= 90.0 && s2 <= 270.0) {
                    if (s1 == s2) {
                        if (e1 == 0.0 && e2 == 0.0) {
                            if (item1.B() < item2.B()) {
                                return -1;
                            }
                            return 1;
                        }
                        if (e1 == 0.0) {
                            return -1;
                        }
                        return 1;
                    }
                    if (s1 < s2) {
                        return -1;
                    }
                    return 1;
                }
                if ((s1 >= 270.0 || s1 <= 90.0) && (s2 >= 270.0 || s2 <= 90.0)) {
                    if (s1 == s2) {
                        if (e1 == 0.0 && e2 == 0.0) {
                            if (item1.B() < item2.B()) {
                                return 1;
                            }
                            return -1;
                        }
                        if (e1 == 0.0) {
                            return 1;
                        }
                        return -1;
                    }
                    if (PieChart.access$000(s1 + 90.0) > PieChart.access$000(s2 + 90.0)) {
                        return -1;
                    }
                    return 1;
                }
                return 1;
            }

            public boolean equals(Object obj) {
                return false;
            }
        };
        double J;
        double B;
        double K;
        double I;
        double G;
        AffineTransform C = null;

        _B(PieChart chart) {
            this.F = chart;
            this.C = AffineTransform.getTranslateInstance(0.0, chart.getShadowOffset());
        }

        void A(int width, int height) {
            this.J = this.F.getHollowPercent();
            if (!this.F.isHollow()) {
                this.J = 0.0;
            }
            this.I = (double)this.F.getXGap() + PieChart.this.\u046d + PieChart.this.\u0464;
            this.G = (double)this.F.getYGap() + PieChart.this.\u0469 + PieChart.this.\u0467;
            width = (int)((double)width - this.I * 2.0);
            height = (int)((double)height - 2.0 * this.G);
            if (width <= 0) {
                width = 1;
            }
            if (height <= 0) {
                height = 1;
            }
            this.B = width;
            this.K = height;
        }

        void A(Graphics2D g2d, int width, int height) {
            _A _item;
            double d2;
            _A item;
            int i2;
            this.A(width, height);
            ArrayList<_A> items3D = new ArrayList<_A>();
            ArrayList<_A> items3DSplit = new ArrayList<_A>();
            double start = PieChart.C(this.F.getStartAngle());
            double extendTotal = 0.0;
            int index = 0;
            block0: for (i2 = 0; i2 < PieChart.this.publishedElements.size(); ++i2) {
                Element element = (Element)PieChart.this.publishedElements.get(i2);
                double extend = i2 == PieChart.this.publishedElements.size() - 1 ? 360.0 - extendTotal : 360.0 * PieChart.this.getValue(element) / this.F.sum;
                extendTotal += extend;
                _A parent = new _A(i2, element, start, extend);
                items3DSplit.add(parent);
                int startI = (int)start / 90;
                for (int ii = 0; ii < 5; ++ii) {
                    double betweenAngle = 90 * (startI = (startI + 1) % 4);
                    if (PieChart.B(betweenAngle, start, extend)) {
                        if (items3DSplit == null) {
                            items3DSplit = new ArrayList();
                        }
                        double _extend = PieChart.C(betweenAngle - start);
                        items3D.add(new _A(parent, index++, element, start, _extend));
                        start = betweenAngle;
                        extend -= _extend;
                        continue;
                    }
                    _A item2 = new _A(parent.E() > extend ? parent : null, index++, element, start, extend);
                    items3D.add(item2);
                    start = PieChart.C(start + extend);
                    continue block0;
                }
            }
            Collections.sort(items3D, this.A);
            for (i2 = 0; i2 < items3D.size(); ++i2) {
                item = (_A)items3D.get(i2);
                if (!PieChart.this.isAppearable(item.D())) continue;
                this.A(g2d, width, height, item, true, true, true, false, false);
            }
            for (i2 = 0; i2 < items3DSplit.size(); ++i2) {
                item = (_A)items3DSplit.get(i2);
                if (!this.F.isAppearable(item.D()) || !PieChart.B(90.0, item.C(), item.E())) continue;
                d2 = 1.0;
                double s = item.C() < 90.0 - d2 || item.C() > 90.0 ? 90.0 - d2 : item.C();
                double extend = item.C() + item.E() > 90.0 + d2 ? 90.0 - s + d2 : item.C() + item.E() - s;
                _item = new _A(item, 0, item.D(), s, extend);
                this.A(g2d, width, height, _item, true, false, false, false, false);
            }
            for (i2 = 0; i2 < items3DSplit.size(); ++i2) {
                item = (_A)items3DSplit.get(i2);
                if (!this.F.isAppearable(item.D()) || !PieChart.B(270.0, item.C(), item.E())) continue;
                d2 = 2.0;
                double s = item.C() <= 270.0 - d2 || item.C() > 270.0 ? 270.0 - d2 : item.C();
                double extend = PieChart.C(item.C() + item.E()) > 270.0 + d2 || PieChart.C(item.C() + item.E()) < item.C() ? 270.0 - s + d2 : PieChart.C(item.C() + item.E()) - s;
                _item = new _A(item, 0, item.D(), s, extend);
                this.A(g2d, width, height, _item, false, false, true, false, false);
            }
            Area allTopArea = new Area();
            for (int i3 = 0; i3 < items3DSplit.size(); ++i3) {
                _A item3 = (_A)items3DSplit.get(i3);
                if (!this.F.isAppearable(item3.D())) continue;
                Area topArea = this.A(g2d, width, height, item3, false, false, false, true, false);
                allTopArea.add(topArea);
                if (item3.D().isSelected()) {
                    g2d.setStroke(PieChart.this.getSelectedStroke(item3.D()));
                    g2d.setColor(PieChart.this.getSelectedColor(item3.D()));
                    g2d.draw(topArea);
                }
                this.F.shapeStructs.add(0, new C(topArea, item3.D(), this.F.getToolTipText(item3.D())));
            }
            Paint oldPaint = g2d.getPaint();
            O factory = d.E(2);
            Paint paint = factory.A(new Rectangle((int)this.I, (int)this.G, width, height), new Color(192, 192, 192, 100), new Color(255, 255, 255, 100));
            g2d.setPaint(paint);
            g2d.fill(allTopArea);
            g2d.setPaint(oldPaint);
            for (int i4 = 0; i4 < items3DSplit.size(); ++i4) {
                _A item4 = (_A)items3DSplit.get(i4);
                if (!this.F.isAppearable(item4.D())) continue;
                this.A(g2d, width, height, item4, false, false, false, false, true);
            }
        }

        private Area A(Graphics2D g2d, int width, int height, _A item, boolean inner, boolean cut, boolean outter, boolean top, boolean label) {
            Area result = new Area();
            if (item != null) {
                double xP = this.I;
                double yP = this.G;
                if (item.D().isSelected()) {
                    _A parent = item.A();
                    if (parent == null) {
                        parent = item;
                    }
                    double diagonalAngle = parent.C() + parent.E() / 2.0;
                    double scale = (double)(this.F.getSelectedOffset() * 2) / (double)(width > height ? width : height);
                    xP += scale * (double)width / 2.0 * Math.cos(diagonalAngle * Math.PI / 180.0);
                    yP -= scale * (double)height / 2.0 * Math.sin(diagonalAngle * Math.PI / 180.0);
                }
                double extendP = item.E();
                double s1P = PieChart.C(item.C());
                double endP = PieChart.C(s1P + item.E());
                Color colorP = this.F.getColor(item.D());
                if (cut) {
                    Area cutSide = this.A(g2d, item, s1P, endP, extendP, xP, yP, colorP);
                    result.add(cutSide);
                }
                if (outter) {
                    Area outterSide = this.B(g2d, item, s1P, endP, extendP, xP, yP, colorP);
                    result.add(outterSide);
                }
                if (inner) {
                    Area innerSide = this.D(g2d, item, s1P, endP, extendP, xP, yP, colorP);
                    result.add(innerSide);
                }
                if (top) {
                    Area topSide = this.C(g2d, item, s1P, endP, extendP, xP, yP, colorP);
                    result.add(topSide);
                }
                if (label) {
                    this.A(g2d, item, xP, yP);
                }
            }
            return result;
        }

        private Area A(Graphics2D g2d, _A item, double start, double end, double extend, double x, double y, Color color) {
            Area result = new Area();
            Arc2D.Double topArcReal = new Arc2D.Double(x, y, this.B, this.K, start, extend, 0);
            Arc2D.Double topHollowArcReal = new Arc2D.Double(x + this.B / 2.0 * (1.0 - this.J), y + this.K / 2.0 * (1.0 - this.J), this.B * this.J, this.K * this.J, start, extend, 0);
            if (extend != 360.0) {
                GeneralPath startCutSide;
                if ((item.C() + 90.0) % 360.0 < 180.0) {
                    startCutSide = new GeneralPath();
                    startCutSide.moveTo((float)topArcReal.getStartPoint().getX(), (float)topArcReal.getStartPoint().getY());
                    startCutSide.lineTo((float)topArcReal.getStartPoint().getX(), (float)(topArcReal.getStartPoint().getY() + (double)PieChart.this.getShadowOffset()));
                    startCutSide.lineTo((float)topHollowArcReal.getStartPoint().getX(), (float)(topHollowArcReal.getStartPoint().getY() + (double)PieChart.this.getShadowOffset()));
                    startCutSide.lineTo((float)topHollowArcReal.getStartPoint().getX(), (float)topHollowArcReal.getStartPoint().getY());
                    startCutSide.closePath();
                    g2d.setColor(color.darker().darker());
                    Area cut = new Area(startCutSide);
                    g2d.fill(cut);
                }
                if (end > 90.0 && end < 270.0) {
                    startCutSide = new GeneralPath();
                    startCutSide.moveTo((float)topArcReal.getEndPoint().getX(), (float)topArcReal.getEndPoint().getY());
                    startCutSide.lineTo((float)topArcReal.getEndPoint().getX(), (float)(topArcReal.getEndPoint().getY() + (double)PieChart.this.getShadowOffset()));
                    startCutSide.lineTo((float)topHollowArcReal.getEndPoint().getX(), (float)(topHollowArcReal.getEndPoint().getY() + (double)PieChart.this.getShadowOffset()));
                    startCutSide.lineTo((float)topHollowArcReal.getEndPoint().getX(), (float)topHollowArcReal.getEndPoint().getY());
                    startCutSide.closePath();
                    g2d.setColor(color.darker().darker());
                    g2d.fill(startCutSide);
                    result.add(new Area(startCutSide));
                }
            }
            return result;
        }

        private Area D(Graphics2D g2d, _A item, double s1, double end1, double extend, double x, double y, Color color) {
            Area innerSide = new Area();
            if (extend != 360.0) {
                if (s1 < 180.0) {
                    Arc2D.Double topHollowArcRealT = new Arc2D.Double(x + this.B / 2.0 * (1.0 - this.J), y + this.K / 2.0 * (1.0 - this.J), this.B * this.J, this.K * this.J, s1, end1 > 180.0 || end1 < s1 ? 180.0 - s1 : extend, 0);
                    GeneralPath startCutSide = new GeneralPath();
                    startCutSide.append(topHollowArcRealT, false);
                    startCutSide.append(twaver.base.A.A.J.A(this.C.createTransformedShape(topHollowArcRealT)), true);
                    startCutSide.closePath();
                    innerSide.add(new Area(startCutSide));
                }
                if (end1 < s1) {
                    Arc2D.Double topHollowArcRealT2 = new Arc2D.Double(x + this.B / 2.0 * (1.0 - this.J), y + this.K / 2.0 * (1.0 - this.J), this.B * this.J, this.K * this.J, 0.0, end1 > 180.0 ? 180.0 : end1, 0);
                    GeneralPath startCutSide2 = new GeneralPath();
                    startCutSide2.append(topHollowArcRealT2, false);
                    startCutSide2.append(twaver.base.A.A.J.A(this.C.createTransformedShape(topHollowArcRealT2)), true);
                    startCutSide2.closePath();
                    innerSide.add(new Area(startCutSide2));
                }
            } else {
                Arc2D.Double topHollowArcRealT = new Arc2D.Double(x + this.B / 2.0 * (1.0 - this.J), y + this.K / 2.0 * (1.0 - this.J), this.B * this.J, this.K * this.J, 0.0, 180.0, 0);
                GeneralPath startCutSide = new GeneralPath();
                startCutSide.append(topHollowArcRealT, false);
                startCutSide.append(twaver.base.A.A.J.A(this.C.createTransformedShape(topHollowArcRealT)), true);
                startCutSide.closePath();
                innerSide.add(new Area(startCutSide));
            }
            g2d.setColor(color.darker());
            g2d.fill(innerSide);
            return innerSide;
        }

        private Area B(Graphics2D g2d, _A item, double s1, double end1, double extend, double x, double y, Color color) {
            Area outterSide = new Area();
            if (extend != 360.0) {
                GeneralPath startCutSide;
                Arc2D.Double topArcRealT;
                if (end1 > 180.0) {
                    topArcRealT = new Arc2D.Double(x, y, this.B, this.K, s1 < 180.0 || s1 > end1 ? 180.0 : s1, end1 - (s1 < 180.0 || s1 > end1 ? 180.0 : s1), 0);
                    startCutSide = new GeneralPath();
                    startCutSide.append(topArcRealT, false);
                    startCutSide.append(twaver.base.A.A.J.A(this.C.createTransformedShape(topArcRealT)), true);
                    startCutSide.closePath();
                    outterSide.add(new Area(startCutSide));
                }
                if (end1 < s1) {
                    topArcRealT = new Arc2D.Double(x, y, this.B, this.K, s1 < 180.0 ? 180.0 : s1, 360.0 - (s1 < 180.0 ? 180.0 : s1), 0);
                    startCutSide = new GeneralPath();
                    startCutSide.append(topArcRealT, false);
                    startCutSide.append(twaver.base.A.A.J.A(this.C.createTransformedShape(topArcRealT)), true);
                    startCutSide.closePath();
                    outterSide.add(new Area(startCutSide));
                }
            } else {
                Arc2D.Double topArcRealT = new Arc2D.Double(x, y, this.B, this.K, 180.0, 180.0, 0);
                GeneralPath startCutSide = new GeneralPath();
                startCutSide.append(topArcRealT, false);
                startCutSide.append(twaver.base.A.A.J.A(this.C.createTransformedShape(topArcRealT)), true);
                startCutSide.closePath();
                outterSide.add(new Area(startCutSide));
            }
            g2d.setColor(color.darker());
            g2d.fill(outterSide);
            return outterSide;
        }

        private Area C(Graphics2D g2d, _A item, double s1, double end1, double extend, double x, double y, Color color) {
            Arc2D.Double topArcReal = new Arc2D.Double(x, y, this.B, this.K, item.C(), extend, 0);
            Arc2D.Double topHollowArcReal = new Arc2D.Double(x + this.B / 2.0 * (1.0 - this.J), y + this.K / 2.0 * (1.0 - this.J), this.B * this.J, this.K * this.J, item.C(), extend, 0);
            GeneralPath sideShape = new GeneralPath();
            sideShape.append(topArcReal, false);
            sideShape.append(twaver.base.A.A.J.A(topHollowArcReal), true);
            sideShape.closePath();
            g2d.setColor(color);
            g2d.fill(sideShape);
            this.A(g2d, item, x, y);
            return new Area(sideShape);
        }

        private void A(Graphics2D g2d, _A item, double x, double y) {
            if (this.F.valueTextVisible) {
                Element element = item.D();
                double proportion = PieChart.this.getValue(element) / this.F.sum;
                String text = this.F.getFormatedText(element, PieChart.this.getValue(element));
                if (this.F.isValueTextPercent()) {
                    text = text + "(" + (int)(proportion * 100.0) + "%)";
                }
                if (text != null) {
                    if (PieChart.this.\u046f >= 1.0) {
                        Arc2D.Double arcText = new Arc2D.Double(x - PieChart.this.\u0464, y - PieChart.this.\u0467, this.B + 2.0 * PieChart.this.\u0464, this.K + 2.0 * PieChart.this.\u0467, item.C(), item.E() / 2.0, 0);
                        Point2D p2 = arcText.getEndPoint();
                        int position = PieChart.this.getLabelTextPosition(-(item.C() + item.E() / 2.0));
                        this.F.A(g2d, text, PieChart.this.valueTextColor, PieChart.this.valueTextFont, (int)p2.getX(), (int)p2.getY(), position);
                    } else {
                        double h2 = PieChart.this.\u046f;
                        Arc2D.Double arcText = new Arc2D.Double(x + this.B / 2.0 * (1.0 - h2), y + this.K / 2.0 * (1.0 - h2), this.B * h2, this.K * h2, item.C(), item.E() / 2.0, 0);
                        Point2D p3 = arcText.getEndPoint();
                        this.F.A(g2d, text, PieChart.this.valueTextColor, PieChart.this.valueTextFont, (int)p3.getX(), (int)p3.getY(), 1);
                    }
                }
            }
        }
    }
}

