/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.renderer.list;

import com.nepxion.swing.renderer.list.CellRendererLabel;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;

public class CheckBoxCellRendererPanel
extends JPanel {
    private JCheckBox checkBox = new JCheckBox();
    private CellRendererLabel label = new CellRendererLabel();

    public CheckBoxCellRendererPanel() {
        this.checkBox.setBackground(UIManager.getColor("Tree.textBackground"));
        this.label.setForeground(UIManager.getColor("Tree.textForeground"));
        this.add(this.checkBox);
        this.add(this.label);
        this.setBackground(Color.white);
    }

    public JCheckBox getCheckBox() {
        return this.checkBox;
    }

    public CellRendererLabel getLabel() {
        return this.label;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension checkBoxDimension = this.checkBox.getPreferredSize();
        Dimension labelDimension = this.label.getPreferredSize();
        return new Dimension(checkBoxDimension.width + labelDimension.width, checkBoxDimension.height < labelDimension.height ? labelDimension.height : checkBoxDimension.height);
    }

    @Override
    public void setBackground(Color background) {
        if (background instanceof ColorUIResource) {
            background = null;
        }
        super.setBackground(background);
    }

    @Override
    public void doLayout() {
        Dimension checkBoxDimension = this.checkBox.getPreferredSize();
        Dimension labelDimension = this.label.getPreferredSize();
        int checkBoxHeight = 0;
        int labelHeight = 0;
        if (checkBoxDimension.height < labelDimension.height) {
            checkBoxHeight = (labelDimension.height - checkBoxDimension.height) / 2;
        } else {
            labelHeight = (checkBoxDimension.height - labelDimension.height) / 2;
        }
        this.checkBox.setBounds(2, checkBoxHeight, checkBoxDimension.width, checkBoxDimension.height);
        this.label.setBounds(checkBoxDimension.width + 4, labelHeight, labelDimension.width, labelDimension.height);
    }
}

