/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.icon;

import com.nepxion.swing.icon.IconConstants;
import com.nepxion.swing.icon.IconContext;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;

public class IconFactory
implements IconConstants {
    private static Map iconPool = new HashMap();

    public static ImageIcon getSwingIcon(String iconName) {
        return IconFactory.getIcon("com/nepxion/swing/icon/image/" + iconName);
    }

    public static ImageIcon getContextIcon(String iconName) {
        return IconFactory.getIcon(IconContext.getIconFolder() + iconName);
    }

    public static ImageIcon getBlankIcon() {
        return IconFactory.getIcon("com/nepxion/swing/icon/image/blank.png");
    }

    public static ImageIcon getIcon(String iconFullPath) {
        Object iconObject = iconPool.get(iconFullPath);
        if (iconObject != null) {
            return (ImageIcon)iconObject;
        }
        ImageIcon icon = IconFactory.createIcon(iconFullPath);
        if (icon == null) {
            Object blankIconObject = iconPool.get("com/nepxion/swing/icon/image/blank.png");
            if (blankIconObject != null) {
                return (ImageIcon)blankIconObject;
            }
            iconFullPath = "com/nepxion/swing/icon/image/blank.png";
            icon = IconFactory.createIcon(iconFullPath);
        }
        iconPool.put(iconFullPath, icon);
        return icon;
    }

    private static ImageIcon createIcon(String iconFullPath) {
        URL iconURL = IconFactory.class.getClassLoader().getResource(iconFullPath);
        if (iconURL != null) {
            return new ImageIcon(iconURL);
        }
        return null;
    }
}

