/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.ui.explorer;

import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.ui.explorer.UIExplorerConstants;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.UIManager;

public class UIExplorerParser {
    private static Map allMap;
    private static Map componentMap;
    private static Map typeMap;

    public static Map parseAllMap() {
        if (allMap == null) {
            allMap = new TreeMap();
            Enumeration enumeration = UIManager.getDefaults().keys();
            while (enumeration.hasMoreElements()) {
                Object key = enumeration.nextElement();
                Object value = UIManager.get(key);
                allMap.put(key.toString(), value);
            }
        }
        return allMap;
    }

    public static Map parseComponentMap() {
        if (componentMap == null) {
            componentMap = new TreeMap();
            Enumeration enumeration = UIManager.getDefaults().keys();
            while (enumeration.hasMoreElements()) {
                Object key = enumeration.nextElement();
                Object value = UIManager.get(key);
                String componentName = UIExplorerParser.getComponentName(key.toString());
                if (componentName == null) continue;
                Map<String, Object> parameterMap = null;
                if (componentMap.containsKey(componentName)) {
                    parameterMap = (Map)componentMap.get(componentName);
                } else {
                    parameterMap = new TreeMap();
                    componentMap.put(componentName, parameterMap);
                }
                parameterMap.put(key.toString(), value);
            }
        }
        return componentMap;
    }

    public static Map parseTypeMap() {
        if (typeMap == null) {
            typeMap = new TreeMap();
            Enumeration enumeration = UIManager.getDefaults().keys();
            while (enumeration.hasMoreElements()) {
                Object key = enumeration.nextElement();
                Object value = UIManager.get(key);
                String type = UIExplorerParser.getTypeName(value);
                if (type == null) continue;
                Map<String, Object> parameterMap = null;
                if (typeMap.containsKey(type)) {
                    parameterMap = (Map)typeMap.get(type);
                } else {
                    parameterMap = new TreeMap();
                    typeMap.put(type, parameterMap);
                }
                parameterMap.put(key.toString(), value);
            }
        }
        return typeMap;
    }

    public static String getComponentName(String key) {
        String componentName = null;
        int index = key.indexOf(".");
        componentName = index == -1 ? (key.endsWith("UI") ? key.substring(0, key.length() - 2) : key) : key.substring(0, index);
        return componentName;
    }

    public static String getTypeName(Object value) {
        for (int i = 0; i < UIExplorerConstants.CLASS_TYPES.length; ++i) {
            Class clazz = UIExplorerConstants.CLASS_TYPES[i];
            if (!clazz.isInstance(value)) continue;
            String className = clazz.getName();
            int index = className.lastIndexOf(".");
            if (index == -1) {
                return className;
            }
            return className.substring(index + 1);
        }
        return SwingLocale.getString("others");
    }
}

