/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.searcher.zone.local;

import com.nepxion.swing.button.ButtonManager;
import com.nepxion.swing.element.IElementNode;
import com.nepxion.swing.handle.HandleManager;
import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.optionpane.JBasicOptionPane;
import com.nepxion.swing.scrollpane.JBasicScrollPane;
import com.nepxion.swing.searcher.zone.local.JZoneTree;
import com.nepxion.swing.selector.button.ISelectorMenuButton;
import com.nepxion.swing.selector.button.JBasicSelectorMenuButton;
import com.nepxion.swing.selector.button.JClassicSelectorMenuButton;
import com.nepxion.swing.textfield.JBasicTextField;
import com.nepxion.swing.textfield.number.JNumberTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.tree.TreeNode;

public class JZoneSelectorPanel
extends JPanel {
    private JNumberTextField textField;
    private ISelectorMenuButton menuButton;
    private JZoneTree tree;
    private int maximumLength = 12;

    public JZoneSelectorPanel() {
        this(false);
    }

    public JZoneSelectorPanel(boolean isClassicStyle) {
        this("", isClassicStyle);
    }

    public JZoneSelectorPanel(String value) {
        this(value, false);
    }

    public JZoneSelectorPanel(String value, boolean isClassicStyle) {
        this(value, 12, isClassicStyle);
    }

    public JZoneSelectorPanel(int maximumLength) {
        this(maximumLength, false);
    }

    public JZoneSelectorPanel(int maximumLength, boolean isClassicStyle) {
        this("", maximumLength, isClassicStyle);
    }

    public JZoneSelectorPanel(String value, int maximumLength) {
        this(value, maximumLength, false);
    }

    public JZoneSelectorPanel(String value, int maximumLength, boolean isClassicStyle) {
        this.textField = new JNumberTextField(maximumLength, 0);
        this.tree = new JZoneTree();
        JBasicScrollPane scrollPane = new JBasicScrollPane(this.tree);
        scrollPane.setPreferredSize(new Dimension(300, 300));
        this.menuButton = isClassicStyle ? new JClassicSelectorMenuButton((Icon)IconFactory.getSwingIcon("property.png"), SwingLocale.getString("select_province_city_code")){

            @Override
            public boolean confirm() {
                return JZoneSelectorPanel.this.confirm();
            }

            @Override
            public boolean cancel() {
                return true;
            }
        } : new JBasicSelectorMenuButton((Icon)IconFactory.getSwingIcon("property.png"), SwingLocale.getString("select_province_city_code")){

            @Override
            public boolean confirm() {
                return JZoneSelectorPanel.this.confirm();
            }

            @Override
            public boolean cancel() {
                return true;
            }
        };
        this.menuButton.setContentPane(scrollPane);
        this.setLayout(new BorderLayout());
        this.add((Component)this.textField, "Center");
        this.add((Component)((Object)this.menuButton), "East");
        ButtonManager.updateUI((Container)this, new Dimension(26, 26));
        this.setValue(value);
    }

    public boolean confirm() {
        TreeNode treeNode = this.tree.getSelectionTreeNode();
        if (treeNode == null || !treeNode.isLeaf()) {
            JBasicOptionPane.showMessageDialog(HandleManager.getFrame(this), SwingLocale.getString("select_city_node"), SwingLocale.getString("warning"), 2);
            return false;
        }
        IElementNode cityTreeNode = (IElementNode)((Object)treeNode);
        IElementNode provinceTreeNode = (IElementNode)((Object)treeNode.getParent());
        String text = provinceTreeNode.getName() + cityTreeNode.getName();
        this.textField.setText(text);
        return true;
    }

    public JBasicTextField getTextField() {
        return this.textField;
    }

    public ISelectorMenuButton getMenuButton() {
        return this.menuButton;
    }

    public JZoneTree getTree() {
        return this.tree;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.textField.setEditable(enabled);
        ((Component)((Object)this.menuButton)).setEnabled(enabled);
    }

    public Object getValue() {
        return this.textField.getText();
    }

    public void setValue(Object value) {
        boolean flag;
        String text = null;
        if (value == null) {
            text = "";
        }
        if ((text = value.toString().trim()).length() > this.maximumLength) {
            throw new IllegalArgumentException("Invalid value");
        }
        if (!text.equals("") && !(flag = text.matches("[0-9]+"))) {
            throw new IllegalArgumentException("Invalid value");
        }
        this.textField.setText(text);
    }
}

