/*
 * Decompiled with CFR 0.152.
 */
package twaver.network.background;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import javax.swing.ImageIcon;
import twaver.TWaverUtil;
import twaver.base.A.D.O;
import twaver.base.A.E.d;
import twaver.base.A.H.I;
import twaver.network.background.AbstractBackground;
import twaver.web.WebUtil;
import twaver.web.svg.network.SVGContext;
import twaver.web.svg.network.SVGStruct;

public class ImageBackground
extends AbstractBackground {
    private String K = null;
    private transient Image J = null;
    private Dimension P = null;
    private boolean F = false;
    private String G = null;
    private transient TexturePaint M = null;
    private Color L = null;
    private boolean N = false;
    private Color O = Color.WHITE;
    private int H = 5;
    private Dimension I = null;

    public ImageBackground() {
    }

    public ImageBackground(String imageURL) {
        this(TWaverUtil.getImage(imageURL));
        this.K = imageURL;
    }

    public ImageBackground(String imageURL, boolean resizable) {
        this(TWaverUtil.getImage(imageURL), resizable);
        this.K = imageURL;
    }

    public ImageBackground(Image image, boolean resizable) {
        this.F = resizable;
        this.J = image;
        this.P = image != null ? new Dimension(image.getWidth(null), image.getHeight(null)) : null;
    }

    public ImageBackground(Image image) {
        this(image, false);
    }

    public Image getImage() {
        return this.J;
    }

    public void paintContent(Graphics2D g2, double zoom, Rectangle viewportRect) {
        if (this.L != null) {
            if (this.N) {
                O factory = d.E(this.H);
                Paint paint = factory.A(viewportRect, this.O, this.L);
                g2.setPaint(paint);
            } else {
                g2.setColor(this.L);
            }
            g2.fillRect(0, 0, (int)viewportRect.getWidth(), (int)viewportRect.getHeight());
        }
        if (this.M == null && this.G != null) {
            this.setTextureURL(this.G);
        }
        if (this.M != null) {
            g2.setPaint(this.M);
            g2.fillRect(0, 0, (int)viewportRect.getWidth(), (int)viewportRect.getHeight());
        }
        if (this.J == null && this.K != null) {
            this.setImageURL(this.K);
        }
        if (this.J != null) {
            if (this.I != null) {
                g2.drawImage(this.J, 0, 0, this.I.width, this.I.height, null);
            } else if (this.F) {
                g2.drawImage(this.J, 0, 0, (int)((double)viewportRect.width * zoom), (int)((double)viewportRect.height * zoom), null);
            } else {
                g2.drawImage(this.J, 0, 0, null);
            }
        }
    }

    public Dimension getBackgroundSize() {
        if (this.I != null) {
            return this.I;
        }
        return this.P;
    }

    public String getImageURL() {
        return this.K;
    }

    public void setImageURL(String imageURL) {
        this.K = imageURL;
        this.J = TWaverUtil.getImage(imageURL);
        this.P = this.J != null ? new Dimension(this.J.getWidth(null), this.J.getHeight(null)) : null;
    }

    public Dimension getSpecificSize() {
        return this.I;
    }

    public void setSpecificSize(Dimension specificSize) {
        this.I = specificSize;
    }

    public Color getColor() {
        return this.L;
    }

    public void setColor(Color color) {
        this.L = color;
    }

    public String getTextureURL() {
        return this.G;
    }

    public void setTextureURL(String textureURL) {
        this.G = textureURL;
        this.M = d.A(TWaverUtil.getImage(textureURL));
    }

    public void setTexture(TexturePaint texture) {
        this.M = texture;
    }

    public SVGStruct toSVG(SVGContext context) {
        String id;
        ImageIcon image;
        StringBuffer sb = new StringBuffer();
        Rectangle bounds = null;
        if (this.L != null) {
            Object fillColor = null;
            if (this.N) {
                String gradientID = WebUtil.getGradientID(context, this.H, this.O, this.L);
                fillColor = gradientID;
            } else {
                fillColor = this.L;
            }
            sb = twaver.base.A.H.I.A(context, "svg_background_id", null, fillColor, null, null, this.getAlpha(), 0.0, null);
            twaver.base.A.H.I.C(context, sb);
            context.appendBackgroundHeadCustomAttribute(sb, this);
            sb.append("/>\n");
        }
        if (this.G != null) {
            image = TWaverUtil.getImageIcon(this.G);
            StringBuffer texturesb = new StringBuffer();
            Rectangle rect = new Rectangle(0, 0, image.getIconWidth(), image.getIconHeight());
            id = WebUtil.getNextCustomDefinitionID();
            twaver.base.A.H.I.A(texturesb, id, rect).append(">");
            twaver.base.A.H.I.A(context, texturesb, this.G, null, 0, 0, this.getAlpha());
            texturesb.append("</pattern>");
            context.registerCustomDefinition(texturesb.toString());
            StringBuffer result = twaver.base.A.H.I.A(context, "svg_background_id", null, (Object)id, null, null, -1.0f, 0.0, null);
            twaver.base.A.H.I.C(context, result);
            result.append("/>\n");
            sb.append(result);
        }
        if (this.K != null) {
            image = TWaverUtil.getImageIcon(this.K);
            int iconWidth = image.getIconWidth();
            int iconHeight = image.getIconHeight();
            id = context.getImageID(this.K, null);
            twaver.base.A.H.I.A(sb, id.toString(), 0, 0);
            twaver.base.A.H.I.A(sb, this.getAlpha());
            context.appendBackgroundHeadCustomAttribute(sb, this);
            twaver.base.A.H.I.C(context, sb);
            if (this.I != null) {
                twaver.base.A.H.I.A(context, sb, this.I.getWidth() / (double)iconWidth, this.I.getHeight() / (double)iconHeight);
            }
            sb.append("/>\n");
            bounds = new Rectangle(0, 0, iconWidth, iconHeight);
        } else {
            sb.append(twaver.base.A.H.I.A(context, "svg_background_id", null, null, null, null, this.getAlpha(), 0.0, null));
            context.appendBackgroundHeadCustomAttribute(sb, this);
            twaver.base.A.H.I.C(context, sb);
            sb.append("/>\n");
        }
        return new SVGStruct(sb.toString(), bounds);
    }

    public boolean isGradient() {
        return this.N;
    }

    public void setGradient(boolean gradient) {
        this.N = gradient;
    }

    public Color getGradientColor() {
        return this.O;
    }

    public void setGradientColor(Color gradientColor) {
        this.O = gradientColor;
    }

    public int getGradientFactory() {
        return this.H;
    }

    public void setGradientFactory(int gradientFactory) {
        this.H = gradientFactory;
    }
}

