/*
 * Decompiled with CFR 0.152.
 */
package twaver.table;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import twaver.Alarm;
import twaver.AlarmModelEvent;
import twaver.AlarmModelListener;
import twaver.AlarmVisibleFilter;
import twaver.BatchAdapter;
import twaver.BatchEvent;
import twaver.BatchListener;
import twaver.Element;
import twaver.MouseActionEvent;
import twaver.TDataBox;
import twaver.TUIManager;
import twaver.TView;
import twaver.TWaverUtil;
import twaver.base.A.C.M;
import twaver.base.A.E.H;
import twaver.table.TTable;
import twaver.table.TTableAdapter;
import twaver.table.TTableColumn;
import twaver.table.TTableModelEvent;
import twaver.table.TTableRowFilter;
import twaver.table.renderer.AcknowledgedRenderer;
import twaver.table.renderer.ElementIDRenderer;

public class TAlarmTable
extends TTable
implements TView {
    private TDataBox \u025e = null;
    private Map \u0259 = new HashMap();
    private Map \u0257 = new HashMap();
    private boolean \u025a = false;
    private Alarm \u025b = null;
    private BatchListener \u0260 = new BatchAdapter(){

        public void batchEnded(BatchEvent e2) {
            TAlarmTable.this.getTableModel().publishData();
        }
    };
    private AlarmModelListener \u0258 = new AlarmModelListener(){

        public void alarmAdded(AlarmModelEvent e2) {
            TAlarmTable.this.B(e2.getAlarm());
        }

        public void alarmRemoved(AlarmModelEvent e2) {
            TAlarmTable.this.A(e2.getAlarm());
        }

        public void alarmCleared(AlarmModelEvent e2) {
            TAlarmTable.this.V();
        }
    };
    private TTableAdapter \u025f = new TTableAdapter(){

        public void rowClicked(int clickCount, Vector rowData, int columnIndex) {
            Alarm alarm = TAlarmTable.this.getAlarmByRowData(rowData);
            if (alarm != null) {
                MouseActionEvent event = new MouseActionEvent(alarm, columnIndex, null, TAlarmTable.this.getCurrentMouseEvent(), TAlarmTable.this, -1);
                if (clickCount == 1) {
                    TAlarmTable.this.D(event);
                } else if (clickCount == 2) {
                    TAlarmTable.this.C(event);
                }
            }
        }

        public void tableDataChanged(TTableModelEvent e2) {
            if (e2.getType() == 3) {
                if (TAlarmTable.this.\u025a) {
                    return;
                }
                TAlarmTable.this.B(e2);
            } else if (e2.getType() != 0) {
                if (e2.getType() == 1) {
                    if (TAlarmTable.this.\u025a) {
                        return;
                    }
                    Vector rowData = e2.getRowData();
                    _A alarmInfo = (_A)TAlarmTable.this.\u0257.get(rowData.get(0));
                    if (alarmInfo != null) {
                        TAlarmTable.this.\u0257.remove(rowData.get(0));
                        TAlarmTable.this.\u0259.remove(alarmInfo.D());
                        TAlarmTable.this.\u025e.getAlarmModel().removeAlarm(alarmInfo.B());
                    }
                } else if (e2.getType() == 2) {
                    if (TAlarmTable.this.\u025a) {
                        return;
                    }
                    if (TAlarmTable.this.\u025e.getAlarmModel().size() > 0) {
                        TAlarmTable.this.\u025e.getAlarmModel().removeAllAlarms();
                    }
                } else if (e2.getType() == 4) {
                    if (TAlarmTable.this.\u025a) {
                        return;
                    }
                    TAlarmTable.this.\u025a = true;
                    TAlarmTable.this.A(TAlarmTable.this.\u025e.getAlarmModel().iterator());
                    TAlarmTable.this.\u025a = false;
                } else if (e2.getType() == 5) {
                    if (TAlarmTable.this.\u025a) {
                        return;
                    }
                    TAlarmTable.this.\u025a = true;
                    TAlarmTable.this.A(TAlarmTable.this.\u025e.getAlarmModel().iterator());
                    TAlarmTable.this.\u025a = false;
                }
            }
        }
    };
    private PropertyChangeListener \u0261 = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            Alarm alarm = (Alarm)evt.getSource();
            _A alarmInfo = (_A)TAlarmTable.this.\u0259.get(alarm.getAlarmID());
            if (alarmInfo != null) {
                String name = evt.getPropertyName();
                TTableColumn column = TAlarmTable.this.getTableModel().getColumnByName(name);
                if (column == null) {
                    return;
                }
                Object propertyValue = alarmInfo.A(column);
                int columnIndx = TAlarmTable.this.getTableModel().getRawColumnIndexByName(name);
                alarmInfo.C().set(columnIndx, propertyValue);
                TAlarmTable.this.getTableModel().publishData();
            }
        }
    };
    private List \u0256 = new ArrayList();
    private List \u025d = new ArrayList();
    private List \u025c = new ArrayList();
    private boolean \u0262 = false;

    public void setEditingRow(int aRow) {
        super.setEditingRow(aRow);
        if (aRow < 0) {
            this.\u025b = null;
            return;
        }
        this.\u025b = this.getAlarmByRowIndex(aRow);
    }

    public Alarm getCurrentEditingAlarm() {
        return this.\u025b;
    }

    public boolean isPublishable() {
        if (this.\u025e != null && this.\u025e.getAlarmModel().isBatching()) {
            return false;
        }
        return super.isPublishable();
    }

    public TAlarmTable(TDataBox box) {
        this(box, TAlarmTable.U());
    }

    public TAlarmTable(TDataBox box, String tableName) {
        List columnList = M.J().B(tableName);
        TTableColumn[] columns = (TTableColumn[])Array.newInstance(TTableColumn.class, columnList.size());
        columnList.toArray(columns);
        this.A(box, columns);
    }

    public TAlarmTable(TDataBox box, TTableColumn[] columns) {
        if (columns == null) {
            columns = new TTableColumn[]{};
        }
        this.A(box, columns);
    }

    private void A(TDataBox box, TTableColumn[] columns) {
        this.setLazyPublishMode(TUIManager.getBoolean("alarm.table.lazy.publish.mode"));
        this.addRowFilter(new TTableRowFilter(){

            public boolean isVisible(TTable table, Vector rowData) {
                Alarm alarm = TAlarmTable.this.getAlarmByRowData(rowData);
                for (int i2 = 0; i2 < TAlarmTable.this.\u0256.size(); ++i2) {
                    AlarmVisibleFilter filter = (AlarmVisibleFilter)TAlarmTable.this.\u0256.get(i2);
                    if (filter.isVisible(alarm)) continue;
                    return false;
                }
                return true;
            }
        });
        this.setDataBox(box, columns);
        this.addTableListener(this.\u025f);
    }

    public void setDataBox(TDataBox box) {
        this.setDataBox(box, null);
    }

    public void setDataBox(TDataBox box, TTableColumn[] columns) {
        if (box == null) {
            throw new NullPointerException("Cannot set a null TDataBox.");
        }
        TDataBox oldValue = this.\u025e;
        if (oldValue != null) {
            oldValue.getAlarmModel().removeBatchListener(this.\u0260);
            oldValue.getAlarmModel().removeAlarmModelListener(this.\u0258);
            oldValue.getAlarmModel().removeAlarmPropertyChangeListener(this.\u0261);
        }
        this.\u025e = box;
        this.\u025a = true;
        this.V();
        if (columns != null) {
            this.getTableModel().clearAllColumns();
            this.getTableModel().addColumns(Arrays.asList(columns));
        }
        this.A(box.getAlarmModel().iterator());
        this.\u025a = false;
        this.\u025e.getAlarmModel().addBatchListener(this.\u0260);
        this.\u025e.getAlarmModel().addAlarmModelListener(this.\u0258);
        this.\u025e.getAlarmModel().addAlarmPropertyChangeListener(this.\u0261);
        this.firePropertyChange("databox", oldValue, box);
    }

    public TDataBox getDataBox() {
        return this.\u025e;
    }

    public void addVisibleFilter(AlarmVisibleFilter alarmFilter) {
        if (alarmFilter != null && !this.\u0256.contains(alarmFilter)) {
            this.\u0256.add(alarmFilter);
            this.getTableModel().publishData();
        }
    }

    public void removeVisibleFilter(AlarmVisibleFilter alarmFilter) {
        if (alarmFilter != null) {
            this.\u0256.remove(alarmFilter);
            this.getTableModel().publishData();
        }
    }

    public List getAlarmDoubleClickedActionListeners() {
        return this.\u025d;
    }

    public List getAlarmClickedActionListeners() {
        return this.\u025c;
    }

    public void addAlarmDoubleClickedActionListener(ActionListener l2) {
        if (!this.\u025d.contains(l2)) {
            this.\u025d.add(l2);
        }
    }

    public void removeAlarmDoubleClickedActionListener(ActionListener l2) {
        this.\u025d.remove(l2);
    }

    public void addAlarmClickedActionListener(ActionListener l2) {
        if (!this.\u025c.contains(l2)) {
            this.\u025c.add(l2);
        }
    }

    public void removeAlarmClickedActionListener(ActionListener l2) {
        this.\u025c.remove(l2);
    }

    private void C(ActionEvent event) {
        for (int i2 = 0; i2 < this.\u025d.size(); ++i2) {
            ActionListener l2 = (ActionListener)this.\u025d.get(i2);
            l2.actionPerformed(event);
        }
    }

    private void D(ActionEvent event) {
        for (int i2 = 0; i2 < this.\u025c.size(); ++i2) {
            ActionListener l2 = (ActionListener)this.\u025c.get(i2);
            l2.actionPerformed(event);
        }
    }

    public boolean isConverseIncreaseOrder() {
        return this.\u0262;
    }

    public void setConverseIncreaseOrder(boolean converseIncreaseOrder) {
        this.\u0262 = converseIncreaseOrder;
    }

    private void B(TTableModelEvent event) {
        int columnIndex = event.getColumnIndex();
        if (columnIndex == 0 || columnIndex == 1) {
            return;
        }
        Vector rowData = event.getRowData();
        _A alarmInfo = (_A)this.\u0257.get(rowData.get(0));
        if (alarmInfo != null) {
            Object newValue = event.getNewValue();
            TTableColumn column = (TTableColumn)this.getTableModel().getRawColumn().get(columnIndex);
            alarmInfo.A(column, newValue);
            Object value = alarmInfo.A(column);
            if (value != null && newValue != null && !value.equals(newValue) || value == null && newValue != null || value != null && newValue == null) {
                rowData.set(columnIndex, value);
                this.getTableModel().publishData();
            }
        }
    }

    private void B(Alarm alarm) {
        if (!this.\u0259.containsKey(alarm.getAlarmID())) {
            _A alarmInfo = new _A(alarm);
            Vector rowData = alarmInfo.C();
            this.\u0259.put(alarm.getAlarmID(), alarmInfo);
            this.\u0257.put(TWaverUtil.valueOf(this.getTableModel().getCurrentOID() + 1), alarmInfo);
            if (this.isConverseIncreaseOrder()) {
                this.tableModel.insertRow(0, rowData);
            } else {
                this.tableModel.addRow(rowData);
            }
        }
    }

    private void A(Iterator alarms) {
        this.\u0259.clear();
        this.\u0257.clear();
        this.tableModel.clearRawData();
        int currentOID = this.tableModel.getCurrentOID();
        while (alarms.hasNext()) {
            Alarm alarm = (Alarm)alarms.next();
            _A alarmInfo = new _A(alarm);
            this.\u0259.put(alarm.getAlarmID(), alarmInfo);
            this.\u0257.put(TWaverUtil.valueOf(++currentOID), alarmInfo);
            if (this.isConverseIncreaseOrder()) {
                this.tableModel.insertRow(0, alarmInfo.C());
                continue;
            }
            this.tableModel.addRow(alarmInfo.C());
        }
    }

    private void A(Alarm alarm) {
        _A alarmInfo = (_A)this.\u0259.remove(alarm.getAlarmID());
        if (alarmInfo != null) {
            this.\u0259.remove(alarmInfo.D());
            this.\u0257.remove(alarmInfo.C().get(0));
            this.getTableModel().removeRow(alarmInfo.C());
        }
    }

    private void V() {
        if (this.\u0259.size() > 0 || this.\u0257.size() > 0) {
            this.\u0259.clear();
            this.\u0257.clear();
            this.getTableModel().clearRawData();
        }
    }

    public Vector getRowDataByAlarmID(Object alarmID) {
        _A alarmInfo = (_A)this.\u0259.get(alarmID);
        if (alarmInfo != null) {
            return alarmInfo.C();
        }
        return null;
    }

    public Collection getRowDatasByAlarms(Collection alarms) {
        ArrayList<Vector> list = new ArrayList<Vector>();
        Iterator it = alarms.iterator();
        while (it.hasNext()) {
            Alarm alarm = (Alarm)it.next();
            list.add(this.getRowDataByAlarmID(alarm.getAlarmID()));
        }
        return list;
    }

    public Alarm getAlarmByOID(Object oid) {
        _A alarmInfo = (_A)this.\u0257.get(oid);
        if (alarmInfo != null) {
            return alarmInfo.B();
        }
        return null;
    }

    public Alarm getAlarmByRowData(Vector rowData) {
        if (rowData == null || rowData.size() == 0) {
            return null;
        }
        return this.getAlarmByOID(rowData.get(0));
    }

    public List getAllCheckedAlarms() {
        Vector data = this.tableModel.getAllCheckedRowData();
        ArrayList<Alarm> list = new ArrayList<Alarm>(data.size());
        for (int i2 = 0; i2 < data.size(); ++i2) {
            Vector rowData = (Vector)data.get(i2);
            Alarm alarm = this.getAlarmByRowData(rowData);
            if (alarm == null) continue;
            list.add(alarm);
        }
        return list;
    }

    public List getAllSelectedAlarms() {
        List data = this.tableModel.getSelectedRows();
        ArrayList<Alarm> list = new ArrayList<Alarm>(data.size());
        for (int i2 = 0; i2 < data.size(); ++i2) {
            Vector rowData = (Vector)data.get(i2);
            Alarm alarm = this.getAlarmByRowData(rowData);
            if (alarm == null) continue;
            list.add(alarm);
        }
        return list;
    }

    public List getCurrentPageAlarms() {
        Vector data = this.tableModel.getCurrentPageData();
        ArrayList<Alarm> list = new ArrayList<Alarm>(data.size());
        for (int i2 = 0; i2 < data.size(); ++i2) {
            Vector rowData = (Vector)data.get(i2);
            Alarm alarm = this.getAlarmByRowData(rowData);
            if (alarm == null) continue;
            list.add(alarm);
        }
        return list;
    }

    public List getPublishedAlarms() {
        Vector data = this.tableModel.getPublishedData();
        ArrayList<Alarm> list = new ArrayList<Alarm>(data.size());
        for (int i2 = 0; i2 < data.size(); ++i2) {
            Vector rowData = (Vector)data.get(i2);
            Alarm alarm = this.getAlarmByRowData(rowData);
            if (alarm == null) continue;
            list.add(alarm);
        }
        return list;
    }

    public Alarm getAlarmByRowIndex(int rowIndex) {
        Vector rowData = this.getRowDataByRowIndex(rowIndex);
        if (rowData == null) {
            return null;
        }
        return this.getAlarmByOID(rowData.get(0));
    }

    private static TTableColumn[] U() {
        return new TTableColumn[]{TAlarmTable.A("alarmID", 60, true), TAlarmTable.A("alarmSeverity", 100, true), TAlarmTable.A("acked", 50, true).setRenderer(new AcknowledgedRenderer()), TAlarmTable.A("elementID", 100, true).setRenderer(new ElementIDRenderer()), TAlarmTable.A("probableCause", 300, true), TAlarmTable.A("ackUserID", 80, false), TAlarmTable.A("clearUserID", 60, false), TAlarmTable.A("cleared", 40, false), TAlarmTable.A("alarmType", 60, false), TAlarmTable.A("trendIndication", 40, false), TAlarmTable.A("raisedTime", 120, false), TAlarmTable.A("ackTime", 120, false), TAlarmTable.A("clearedTime", 120, false), TAlarmTable.A("lastChangedTime", 120, false), TAlarmTable.A("correlatedAlarms", 60, false), TAlarmTable.A("specificProblem", 200, false), TAlarmTable.A("additionalText", 200, false), TAlarmTable.A("comments", 200, false), TAlarmTable.A("proposedRepairAction", 200, false)};
    }

    private static TTableColumn A(String name, int width, boolean visible) {
        return new TTableColumn(name, TWaverUtil.getString("alarm.property." + name), width).setVisible(visible);
    }

    public void selectAlarmsByElement(Element element) {
        Collection alarms = this.\u025e.getAlarmModel().getAlarmsByElement(element);
        Collection rowDatas = this.getRowDatasByAlarms(alarms);
        this.selectRowDatas(rowDatas);
    }

    public void updateTViewUI() {
        this.\u025a = true;
        this.A(this.\u025e.getAlarmModel().iterator());
        this.\u025a = false;
    }

    class _A {
        private Alarm B;
        private Vector A = new Vector();

        _A(Alarm alarm) {
            this.B = alarm;
            this.A();
        }

        private Alarm B() {
            return this.B;
        }

        private Vector C() {
            return this.A;
        }

        private Object D() {
            return this.B.getAlarmID();
        }

        private void A() {
            Class<?> clazz = this.B.getClass();
            List list = TAlarmTable.this.getTableModel().getRawColumn();
            for (int i2 = 2; i2 < list.size(); ++i2) {
                TTableColumn column = (TTableColumn)list.get(i2);
                String name = column.getName();
                if (column.getReadMethod() == null) {
                    Method readMethod = H.B(clazz, name);
                    column.setReadMethod(readMethod);
                }
                if (column.getWriteMethod() == null && column.getReadMethod() != null) {
                    Method writeMethod = H.B(clazz, name, column.getReadMethod().getReturnType());
                    column.setWriteMethod(writeMethod);
                }
                Object value = this.A(column);
                this.A.add(value);
            }
        }

        private Object A(TTableColumn column) {
            return H.A(this.B, column.getReadMethod(), column.getName());
        }

        private void A(TTableColumn column, Object value) {
            H.A(this.B, column.getWriteMethod(), column.getName(), value);
        }
    }
}

