/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.chart;

import com.lowagie.text.DocumentException;
import com.nepxion.swing.chart.ChartPDFUtil;
import com.nepxion.swing.chart.JChartPanel;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.selector.file.JFileFilter;
import com.nepxion.swing.selector.file.JFileSelector;
import com.nepxion.util.data.CollectionUtil;
import java.awt.Component;
import java.io.IOException;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.ui.RectangleInsets;

public class ChartPDFWriter {
    private JChartPanel chartPanel;
    private JFileSelector fileSelector;

    public ChartPDFWriter(JChartPanel chartPanel) {
        this.chartPanel = chartPanel;
        List filterWords = CollectionUtil.parseList((Object[])new String[]{"pdf"});
        String filterDescription = "PDF " + SwingLocale.getString("document") + " (*.pdf)";
        JFileFilter filterFilter = new JFileFilter(filterWords, filterDescription);
        this.fileSelector = new JFileSelector((Component)((Object)chartPanel), SwingLocale.getString("export") + " PDF " + SwingLocale.getString("file"));
        this.fileSelector.addChoosableFileFilter(filterFilter);
        this.fileSelector.setFileFilter(filterFilter);
    }

    public void write() {
        this.write(null, null);
    }

    public void write(final String author, final String subject) {
        JFreeChart chart = this.chartPanel.getChart();
        final String filePath = this.fileSelector.saveFile(chart.getTitle().getText() + ".pdf");
        if (filePath == null) {
            return;
        }
        try {
            final JFreeChart chartClone = (JFreeChart)chart.clone();
            chartClone.setBorderVisible(true);
            chartClone.setPadding(new RectangleInsets(2.0, 2.0, 2.0, 2.0));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        ChartPDFUtil.writeChartAsPDF(filePath, chartClone, ChartPDFWriter.this.chartPanel.getWidth(), ChartPDFWriter.this.chartPanel.getHeight(), author, subject);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (DocumentException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
    }
}

