/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.cots.twaver.graph;

import com.nepxion.cots.twaver.graph.TGraph;
import com.nepxion.cots.twaver.graph.TLiteLayoutEngine;
import com.nepxion.cots.twaver.locale.TLocale;
import com.nepxion.swing.exception.ExceptionTracer;
import com.nepxion.swing.handle.HandleManager;
import java.awt.Component;
import java.awt.Point;
import java.awt.geom.GeneralPath;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import twaver.BaseElement;
import twaver.Element;
import twaver.Link;
import twaver.TDataBox;
import twaver.network.ui.LinkUI;
import y.base.Edge;
import y.base.Node;
import y.layout.LayoutGraph;
import y.layout.Layouter;
import y.layout.circular.CircularLayouter;
import y.layout.circular.SingleCycleLayouter;
import y.layout.hierarchic.HierarchicLayouter;
import y.layout.organic.OrganicLayouter;
import y.layout.organic.SmartOrganicLayouter;
import y.layout.orthogonal.OrthogonalLayouter;
import y.layout.random.RandomLayouter;
import y.layout.tree.ARTreeLayouter;
import y.layout.tree.BalloonLayouter;
import y.layout.tree.HVTreeLayouter;
import y.layout.tree.TreeLayouter;
import y.view.EdgeRealizer;

public class TLiteLayouter {
    public static final int MINIMUM_GAP = 1;
    public static final int MAXIMUM_GAP = 500;
    public static final int DEFAULT_GAP = 100;
    private TGraph graph;
    private TLiteLayoutEngine layoutEngine;

    public TLiteLayouter(TGraph graph) {
        this.graph = graph;
        this.layoutEngine = new TLiteLayoutEngine();
    }

    public void doOrganicLayout(int gap, boolean isAnimated) {
        OrganicLayouter layouter = new OrganicLayouter();
        layouter.setGravityFactor(2.0);
        layouter.setPreferredEdgeLength(gap);
        try {
            this.doLayout((Layouter)layouter, isAnimated);
        }
        catch (Exception e) {
            ExceptionTracer.traceException((Component)HandleManager.getFrame((Component)((Object)this.graph)), (String)TLocale.getString("layout_execption"), (Exception)e);
        }
    }

    public void doSmartOrganicLayout(int gap, boolean isAnimated) {
        SmartOrganicLayouter layouter = new SmartOrganicLayouter();
        layouter.setMinimalNodeDistance(1.0);
        layouter.setCompactness(0.01);
        layouter.setPreferredEdgeLength((double)gap);
        try {
            this.doLayout((Layouter)layouter, isAnimated);
        }
        catch (Exception e) {
            ExceptionTracer.traceException((Component)HandleManager.getFrame((Component)((Object)this.graph)), (String)TLocale.getString("layout_execption"), (Exception)e);
        }
    }

    public void doHierarchicLayout(int gap, boolean isAnimated) {
        HierarchicLayouter layouter = new HierarchicLayouter();
        layouter.setMinimalNodeDistance((double)gap);
        try {
            this.doLayout((Layouter)layouter, isAnimated);
        }
        catch (Exception e) {
            ExceptionTracer.traceException((Component)HandleManager.getFrame((Component)((Object)this.graph)), (String)TLocale.getString("layout_execption"), (Exception)e);
        }
    }

    public void doOrthogonalLayout(int gap, boolean isAnimated) {
        OrthogonalLayouter layouter = new OrthogonalLayouter();
        layouter.setGrid(gap);
        try {
            this.doLayout((Layouter)layouter, isAnimated);
        }
        catch (Exception e) {
            ExceptionTracer.traceException((Component)HandleManager.getFrame((Component)((Object)this.graph)), (String)TLocale.getString("layout_execption"), (Exception)e);
        }
    }

    public void doCircularLayout(boolean isAnimated) {
        CircularLayouter layouter = new CircularLayouter();
        try {
            this.doLayout((Layouter)layouter, isAnimated);
        }
        catch (Exception e) {
            ExceptionTracer.traceException((Component)HandleManager.getFrame((Component)((Object)this.graph)), (String)TLocale.getString("layout_execption"), (Exception)e);
        }
    }

    public void doSingleCycleLayout(int gap, boolean isAnimated) {
        SingleCycleLayouter layouter = new SingleCycleLayouter();
        layouter.setMinimalNodeDistance(gap);
        try {
            this.doLayout((Layouter)layouter, isAnimated);
        }
        catch (Exception e) {
            ExceptionTracer.traceException((Component)HandleManager.getFrame((Component)((Object)this.graph)), (String)TLocale.getString("layout_execption"), (Exception)e);
        }
    }

    public void doTreeLayout(int gap, boolean isAnimated) {
        TreeLayouter layouter = new TreeLayouter();
        layouter.setMinimalNodeDistance((double)gap);
        try {
            this.doLayout((Layouter)layouter, isAnimated);
        }
        catch (Exception e) {
            ExceptionTracer.traceException((Component)HandleManager.getFrame((Component)((Object)this.graph)), (String)TLocale.getString("layout_execption"), (Exception)e);
        }
    }

    public void doARTreeLayout(boolean isAnimated) {
        ARTreeLayouter layouter = new ARTreeLayouter();
        try {
            this.doLayout((Layouter)layouter, isAnimated);
        }
        catch (Exception e) {
            ExceptionTracer.traceException((Component)HandleManager.getFrame((Component)((Object)this.graph)), (String)TLocale.getString("layout_execption"), (Exception)e);
        }
    }

    public void doHVTreeLayout(boolean isAnimated) {
        HVTreeLayouter layouter = new HVTreeLayouter();
        try {
            this.doLayout((Layouter)layouter, isAnimated);
        }
        catch (Exception e) {
            ExceptionTracer.traceException((Component)HandleManager.getFrame((Component)((Object)this.graph)), (String)TLocale.getString("layout_execption"), (Exception)e);
        }
    }

    public void doBalloonTreeLayout(int gap, boolean isAnimated) {
        BalloonLayouter layouter = new BalloonLayouter();
        layouter.setMinimalEdgeLength(gap);
        try {
            this.doLayout((Layouter)layouter, isAnimated);
        }
        catch (Exception e) {
            ExceptionTracer.traceException((Component)HandleManager.getFrame((Component)((Object)this.graph)), (String)TLocale.getString("layout_execption"), (Exception)e);
        }
    }

    public void doRandomLayout(boolean isAnimated) {
        RandomLayouter layouter = new RandomLayouter();
        try {
            this.doLayout((Layouter)layouter, isAnimated);
        }
        catch (Exception e) {
            ExceptionTracer.traceException((Component)HandleManager.getFrame((Component)((Object)this.graph)), (String)TLocale.getString("layout_execption"), (Exception)e);
        }
    }

    public void doLayout(Layouter layouter, final boolean isAnimated) {
        this.syncEngineData();
        layouter.doLayout((LayoutGraph)this.layoutEngine);
        final HashMap<Element, Point> newLocations = new HashMap<Element, Point>();
        final HashMap<Element, Point> oldLocations = new HashMap<Element, Point>();
        for (Element element : this.layoutEngine.getNodes().keySet()) {
            Node yNode = (Node)this.layoutEngine.getNodes().get(element);
            Point newPoint = new Point((int)this.layoutEngine.getLocation((Node)yNode).x, (int)this.layoutEngine.getLocation((Node)yNode).y);
            newLocations.put(element, newPoint);
            oldLocations.put(element, element.getLocation());
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                final int size = isAnimated ? 20 : 1;
                for (int i = 0; i <= size; ++i) {
                    final int step = i;
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                for (BaseElement element : newLocations.keySet()) {
                                    Point oldLocation = (Point)oldLocations.get(element);
                                    Point newLocation = (Point)newLocations.get(element);
                                    if (step < size) {
                                        int x = oldLocation.x + step * (newLocation.x - oldLocation.x) / size;
                                        int y = oldLocation.y + step * (newLocation.y - oldLocation.y) / size;
                                        element.setLocation(x, y);
                                        continue;
                                    }
                                    element.setLocation(newLocation);
                                }
                                if (step == size) {
                                    for (Link link : TLiteLayouter.this.layoutEngine.getLinks().keySet()) {
                                        LinkUI linkUI = (LinkUI)TLiteLayouter.this.graph.getRenderer().getElementUI((Element)link);
                                        Edge edge = (Edge)TLiteLayouter.this.layoutEngine.getLinks().get(link);
                                        EdgeRealizer realizer = TLiteLayouter.this.layoutEngine.getRealizer(edge);
                                        GeneralPath path = realizer.getPath();
                                        GeneralPath newPath = new GeneralPath();
                                        Point fromPoint = linkUI.getFromPoint();
                                        Point toPoint = linkUI.getToPoint();
                                        newPath.moveTo(fromPoint.x, fromPoint.y);
                                        newPath.append(path.getPathIterator(null), true);
                                        newPath.lineTo(toPoint.x, toPoint.y);
                                        linkUI.setPath(newPath);
                                    }
                                    TLiteLayouter.this.graph.adjustCanvasSize();
                                    TLiteLayouter.this.graph.getCanvas().repaint();
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (!isAnimated) continue;
                    try {
                        Thread.sleep(10L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
        };
        thread.start();
    }

    private void syncEngineData() {
        this.layoutEngine.clear();
        TDataBox dataBox = this.graph.getDataBox();
        for (Object object : dataBox) {
            BaseElement elementNode;
            if (!(object instanceof BaseElement) || !this.graph.isVisible((Element)(elementNode = (BaseElement)object)) || !this.graph.isMovable((Element)elementNode)) continue;
            Node yNode = this.layoutEngine.createNode();
            this.layoutEngine.setSize(yNode, elementNode.getWidth(), elementNode.getHeight());
            this.layoutEngine.getNodes().put(elementNode, yNode);
        }
        for (Object object : dataBox) {
            Link link;
            if (!(object instanceof Link) || !this.graph.isVisible((Element)(link = (Link)object))) continue;
            twaver.Node fromNode = link.getFrom();
            twaver.Node toNode = link.getTo();
            if (fromNode == null || toNode == null) continue;
            Node fromYNode = (Node)this.layoutEngine.getNodes().get(fromNode);
            Node toYNode = (Node)this.layoutEngine.getNodes().get(toNode);
            if (fromYNode == null || toYNode == null) continue;
            Edge edge = this.layoutEngine.createEdge(fromYNode, toYNode);
            this.layoutEngine.getLinks().put(link, edge);
        }
    }
}

