/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.util.net.http.apache;

import com.nepxion.util.encoder.EncoderContext;
import com.nepxion.util.io.IOUtil;
import com.nepxion.util.net.http.HttpConfig;
import com.nepxion.util.net.http.IClientInvoker;
import com.nepxion.util.net.http.IClientRequest;
import com.nepxion.util.net.http.apache.ClientLogger;
import java.io.IOException;
import java.net.URI;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

public class ClientInvoker
extends DefaultHttpClient
implements IClientInvoker {
    @Override
    public Object invoke(IClientRequest clientRequest) throws Exception {
        if (clientRequest.getURI() == null) {
            throw new IllegalArgumentException("Invalid URL for invoking");
        }
        clientRequest.setURI(URI.create(clientRequest.getURI() + clientRequest.getURLParameter()));
        HttpConfig httpConfig = clientRequest.getHttpConfig();
        if (httpConfig != null) {
            this.getParams().setIntParameter("http.connection.timeout", httpConfig.getConnectionTimeOut());
            this.getParams().setIntParameter("http.socket.timeout", httpConfig.getResponseTimeOut());
            this.getParams().setIntParameter("http.socket.buffer-size", httpConfig.getBufferSize());
        }
        HttpUriRequest request = (HttpUriRequest)clientRequest;
        HttpResponse response = null;
        try {
            response = this.execute(request);
        }
        catch (ClientProtocolException e) {
            request.abort();
            e.printStackTrace();
            throw e;
        }
        catch (IOException e) {
            request.abort();
            e.printStackTrace();
            throw e;
        }
        return response;
    }

    public HttpEntity getResponseEntity(IClientRequest clientRequest) throws Exception {
        HttpResponse response = (HttpResponse)this.invoke(clientRequest);
        HttpEntity entity = response.getEntity();
        return entity;
    }

    public Object getResponseObject(IClientRequest clientRequest) throws Exception {
        HttpEntity entity = this.getResponseEntity(clientRequest);
        Object object = IOUtil.read(entity.getContent());
        entity.consumeContent();
        clientRequest.abort();
        ClientLogger.responseInfo("Serializable Entity", object);
        if (object instanceof Exception) {
            Exception e = (Exception)object;
            Exception exception = null;
            exception = e.getCause() != null && e.getCause() instanceof Exception ? (Exception)e.getCause() : e;
            ClientLogger.fatal(exception);
            throw exception;
        }
        return object;
    }

    public String getResponseText(IClientRequest clientRequest) throws Exception {
        return this.getResponseText(clientRequest, EncoderContext.getHttpCharset());
    }

    public String getResponseText(IClientRequest clientRequest, String charset) throws Exception {
        HttpEntity entity = this.getResponseEntity(clientRequest);
        String text = IOUtil.getString(entity.getContent(), charset);
        entity.consumeContent();
        clientRequest.abort();
        ClientLogger.responseInfo(charset, "String - [Text, XML, JSON, Properties ...]", text);
        return text;
    }

    public void shutdown() {
        this.getConnectionManager().shutdown();
    }
}

