/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.util.Comparator;
import java.util.Iterator;
import twaver.AlarmPropagator;
import twaver.AlarmSeverity;
import twaver.Element;

public class SummingAlarmPropagator
implements AlarmPropagator {
    protected ThreadLocal threadLocal = new ThreadLocal();

    public void propagate(Element element) {
        if (element == null || this.threadLocal.get() != null) {
            return;
        }
        this.threadLocal.set(element);
        this.propagateToTop(element);
        this.threadLocal.set(null);
    }

    protected void propagateToTop(Element element) {
        while (element != null && element.getParent() != null) {
            Element parent = element.getParent();
            if (!parent.getAlarmState().isEnablePropagationFromChildren()) {
                return;
            }
            this.propagateToParent(element, parent);
            element = parent;
        }
    }

    protected void propagateToParent(Element element, Element parent) {
        AlarmSeverity result = null;
        Iterator it = parent.children();
        Comparator comparator = AlarmSeverity.getSeverityComparator();
        while (it.hasNext()) {
            Element child = (Element)it.next();
            AlarmSeverity childHighest = child.getAlarmState().getHighestOverallAlarmSeverity();
            if (childHighest == null || comparator.compare(childHighest, result) <= 0) continue;
            result = childHighest;
        }
        parent.getAlarmState().setPropagateSeverity(result);
    }
}

