/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import twaver.Element;
import twaver.PersistenceManager;
import twaver.TDataBox;
import twaver.TWaverUtil;

public class DataBoxJarReader {
    private JarURLConnection A = null;

    public DataBoxJarReader(JarURLConnection connection) {
        this.A = connection;
        this.A.setDefaultUseCaches(false);
    }

    public void read(TDataBox box) throws IOException {
        this.read(box, null);
    }

    public void read(TDataBox box, Element parentOfRootElement) throws IOException {
        JarFile jarfile = this.A.getJarFile();
        Vector<String> imageEntryNames = new Vector<String>();
        Enumeration<JarEntry> e2 = jarfile.entries();
        while (e2.hasMoreElements()) {
            JarEntry entry = e2.nextElement();
            String name = entry.getName();
            if (name.equals("data.xml")) continue;
            imageEntryNames.addElement(name);
        }
        JarEntry xmlEntry = (JarEntry)jarfile.getEntry("data.xml");
        if (xmlEntry == null) {
            throw new ZipException("Illegal format template jar: \"" + this.A.getJarFileURL().toString() + "\"");
        }
        InputStream xmlInputStream = jarfile.getInputStream(xmlEntry);
        byte[] xmlChars = TWaverUtil.getByteArrayFromInputStream(xmlInputStream);
        String xmlString = new String(xmlChars, "UTF-8");
        Iterator it = imageEntryNames.iterator();
        while (it.hasNext()) {
            String imageEntryName = (String)it.next();
            String imageURL = "<string>jar:" + this.A.getJarFileURL().toString() + "!/" + imageEntryName + "</string>";
            imageURL = DataBoxJarReader.A(imageURL);
            String regex = "<string>" + imageEntryName + "</string>";
            String replacement = imageURL;
            xmlString = xmlString.replaceAll(regex, replacement);
        }
        PersistenceManager.readByXML(box, xmlString, parentOfRootElement);
        xmlInputStream.close();
        jarfile.getInputStream(xmlEntry).close();
        jarfile.close();
    }

    private static String A(String text) {
        while (text.indexOf("\\") != -1) {
            int index = text.indexOf("\\");
            String str1 = text.substring(0, index);
            String str2 = text.substring(index + 1);
            text = str1 + "/" + str2;
        }
        return text;
    }
}

