/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.framework.dockable;

import com.nepxion.swing.framework.dockable.JDockableSplitPane;
import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.menuitem.JBasicMenuItem;
import com.nepxion.swing.tabbedpane.JEclipseTabbedPane;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JPopupMenu;

public class JDockableTabbedPane
extends JEclipseTabbedPane {
    private int verticalTabPlacement = 1;
    private int horizontalTabPlacement = 1;
    private JBasicMenuItem toggleSizeMenuItem;
    private JBasicMenuItem toggleLayoutMenuItem;
    private JDockableSplitPane splitPane;

    public JDockableTabbedPane() {
    }

    public JDockableTabbedPane(int tabPlacement) {
        super(tabPlacement);
    }

    public JDockableTabbedPane(int tabPlacement, int tabLayoutPolicy) {
        super(tabPlacement, tabLayoutPolicy);
    }

    @Override
    public void setPopupMenu(JPopupMenu popupMenu, boolean isClosable) {
        super.setPopupMenu(popupMenu, isClosable);
        if (popupMenu.getComponentCount() != 0) {
            popupMenu.add(new JPopupMenu.Separator());
        }
        this.toggleSizeMenuItem = new JBasicMenuItem(SwingLocale.getString("toggle_tabbedpane_size"), (Icon)IconFactory.getSwingIcon("toggle_size.png"), SwingLocale.getString("toggle_tabbedpane_size"));
        this.toggleSizeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JDockableTabbedPane.this.initialize();
                JDockableTabbedPane.this.splitPane.toggleView((Component)((Object)JDockableTabbedPane.this));
            }
        });
        popupMenu.add(this.toggleSizeMenuItem);
        this.toggleLayoutMenuItem = new JBasicMenuItem(SwingLocale.getString("toggle_tabbedpane_layou"), (Icon)IconFactory.getSwingIcon("toggle_layout.png"), SwingLocale.getString("toggle_tabbedpane_layou"));
        this.toggleLayoutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JDockableTabbedPane.this.initialize();
                JDockableTabbedPane.this.splitPane.toggleLayout();
            }
        });
        popupMenu.add(this.toggleLayoutMenuItem);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        super.mouseClicked(e);
        if (this.getPopupMenu() != null && e.getClickCount() > 1) {
            this.initialize();
            this.splitPane.toggleView((Component)((Object)this));
        }
    }

    private void initialize() {
        if (this.splitPane == null) {
            this.splitPane = (JDockableSplitPane)((Object)this.getParent());
        }
    }

    public int getVerticalTabPlacement() {
        return this.verticalTabPlacement;
    }

    public void setVerticalTabPlacement(int verticalTabPlacement) {
        this.verticalTabPlacement = verticalTabPlacement;
    }

    public int getHorizontalTabPlacement() {
        return this.horizontalTabPlacement;
    }

    public void setHorizontalTabPlacement(int horizontalTabPlacement) {
        this.horizontalTabPlacement = horizontalTabPlacement;
    }
}

