/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import twaver.DataBoxEvent;
import twaver.DataBoxListener;
import twaver.Element;
import twaver.Generator;
import twaver.SerializablePropertyChangeListener;
import twaver.TDataBox;

public class DataBoxQuickFinder {
    protected TDataBox box = null;
    protected String propertyName = null;
    protected Class elementClass = null;
    protected Generator keyGenerator = null;
    private Map B = new HashMap();
    private DataBoxListener C = new DataBoxListener(){

        public void elementAdded(DataBoxEvent e2) {
            DataBoxQuickFinder.this.addElement(e2.getElement());
        }

        public void elementRemoved(DataBoxEvent e2) {
            DataBoxQuickFinder.this.removeElement(e2.getElement());
        }

        public void elementsCleared(DataBoxEvent e2) {
            DataBoxQuickFinder.this.clear();
        }
    };
    private PropertyChangeListener A = new SerializablePropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent e2) {
            DataBoxQuickFinder.this.elementPropertyChange(e2);
        }
    };

    public DataBoxQuickFinder(TDataBox box, String propertyName) {
        this(box, propertyName, null);
    }

    public DataBoxQuickFinder(TDataBox box, String propertyName, Class elementClass) {
        this(box, propertyName, elementClass, null);
    }

    public DataBoxQuickFinder(TDataBox box, String propertyName, Class elementClass, Generator keyGenerator) {
        this.box = box;
        this.propertyName = propertyName;
        this.keyGenerator = keyGenerator;
        this.elementClass = elementClass == null ? Element.class : elementClass;
        Iterator it = box.iterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            this.addElement(element);
        }
        this.box.B(this.C);
        this.box.B(this.A);
    }

    public List find(Object value) {
        return (List)this.B.get(value);
    }

    public Element findFirst(Object value) {
        List list = (List)this.B.get(value);
        if (list != null && list.size() > 0) {
            return (Element)list.get(0);
        }
        return null;
    }

    protected void addElement(Element element) {
        if (!this.interested(element)) {
            return;
        }
        Object key = this.getKey(element);
        ArrayList<Element> list = this.find(key);
        if (list == null) {
            list = new ArrayList<Element>(1);
            this.B.put(key, list);
        }
        list.add(element);
    }

    protected void removeElement(Element element) {
        if (!this.interested(element)) {
            return;
        }
        Object key = this.getKey(element);
        List list = this.find(key);
        if (list != null) {
            list.remove(element);
            if (list.isEmpty()) {
                this.B.remove(key);
            }
        }
    }

    protected void clear() {
        this.B.clear();
    }

    protected void elementPropertyChange(PropertyChangeEvent e2) {
        if (this.propertyName == null) {
            return;
        }
        String name = e2.getPropertyName();
        if (name.equals(this.propertyName)) {
            Element element = (Element)e2.getSource();
            Object oldKey = e2.getOldValue();
            List list = this.find(oldKey);
            if (list != null) {
                list.remove(element);
            }
            this.addElement(element);
            return;
        }
    }

    public void dispose() {
        this.box.A(this.C);
        this.box.A(this.A);
        this.propertyName = null;
        this.keyGenerator = null;
        this.B = null;
        this.box = null;
        this.elementClass = null;
        this.C = null;
        this.A = null;
    }

    public boolean interested(Element element) {
        return this.elementClass.isInstance(element);
    }

    protected Object getKey(Element element) {
        if (this.keyGenerator == null) {
            return null;
        }
        return this.keyGenerator.generate(element);
    }
}

