/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.tray;

import com.jeans.trayicon.SwingTrayPopup;
import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.menuitem.JBasicMenuItem;
import com.nepxion.swing.popupmenu.PopupMenuPainter;
import com.nepxion.swing.tray.ITrayIconPopupMenu;
import com.nepxion.swing.tray.JTray;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JPopupMenu;

public class SwingTrayIconPopupMenu
extends SwingTrayPopup
implements ITrayIconPopupMenu {
    private JTray tray;
    private JBasicMenuItem restoreMenuItem;
    public PopupMenuPainter painter;
    private String title;

    public SwingTrayIconPopupMenu(JTray tray, String title) {
        this.tray = tray;
        this.title = title;
        this.initPopupMenu();
    }

    private void initPopupMenu() {
        this.restoreMenuItem = new JBasicMenuItem(SwingLocale.getString("hide_window"), (Icon)IconFactory.getSwingIcon("tray_hidden.png"), SwingLocale.getString("hide_window"));
        this.restoreMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingTrayIconPopupMenu.this.tray.restore();
            }
        });
        this.add(this.restoreMenuItem);
        this.addSeparator();
        JBasicMenuItem aboutMenuItem = new JBasicMenuItem(SwingLocale.getString("about_system"), (Icon)IconFactory.getSwingIcon("about.png"), SwingLocale.getString("about_system"));
        aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingTrayIconPopupMenu.this.tray.about();
            }
        });
        this.add(aboutMenuItem);
        this.addSeparator();
        JBasicMenuItem exitMenuItem = new JBasicMenuItem(SwingLocale.getString("exit"), (Icon)IconFactory.getBlankIcon(), SwingLocale.getString("exit"));
        exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingTrayIconPopupMenu.this.tray.exit();
            }
        });
        this.add(exitMenuItem);
        PopupMenuPainter painter = new PopupMenuPainter(this.title);
        this.setPainter(painter);
    }

    public PopupMenuPainter getPainter() {
        return this.painter;
    }

    public void setPainter(PopupMenuPainter painter) {
        this.painter = painter;
        this.painter.setPopupMenu((JPopupMenu)((Object)this));
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        if (this.painter != null) {
            return this.painter.getInsets((Insets)insets.clone());
        }
        return insets;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.painter != null) {
            this.painter.paintComponent(g);
        }
    }

    @Override
    public void restore(boolean flag) {
        String text = SwingLocale.getString("hide_window");
        String icon = "tray_hidden.png";
        if (!flag) {
            text = SwingLocale.getString("show_window");
            icon = "tray_show.png";
        }
        this.restoreMenuItem.setText(text);
        this.restoreMenuItem.setIcon(IconFactory.getSwingIcon(icon));
    }
}

