/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.CheckBoxTree;
import com.jidesoft.swing.CheckBoxTreeSelectionModel;
import com.jidesoft.swing.TristateCheckBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class CheckBoxTreeCellRenderer
extends JPanel
implements TreeCellRenderer,
Serializable {
    private static final long serialVersionUID = 30207434500313004L;
    protected TristateCheckBox _checkBox = null;
    protected JComponent _emptyBox = null;
    protected JCheckBox _protoType = new TristateCheckBox();
    protected TreeCellRenderer _actualTreeRenderer;

    public CheckBoxTreeCellRenderer() {
        this((TreeCellRenderer)null);
    }

    public CheckBoxTreeCellRenderer(TreeCellRenderer treeCellRenderer) {
        this(treeCellRenderer, null);
    }

    public CheckBoxTreeCellRenderer(TreeCellRenderer treeCellRenderer, TristateCheckBox tristateCheckBox) {
        this._checkBox = tristateCheckBox == null ? this.createCheckBox() : tristateCheckBox;
        this._emptyBox = (JComponent)Box.createHorizontalStrut(this._protoType.getPreferredSize().width);
        this.setLayout(new BorderLayout(0, 0));
        this.setOpaque(false);
        this._actualTreeRenderer = treeCellRenderer;
    }

    protected TristateCheckBox createCheckBox() {
        TristateCheckBox tristateCheckBox = new TristateCheckBox();
        tristateCheckBox.setOpaque(false);
        return tristateCheckBox;
    }

    public TreeCellRenderer getActualTreeRenderer() {
        return this._actualTreeRenderer;
    }

    public void setActualTreeRenderer(TreeCellRenderer treeCellRenderer) {
        this._actualTreeRenderer = treeCellRenderer;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        Serializable serializable;
        this._checkBox.setPreferredSize(new Dimension(this._protoType.getPreferredSize().width, 0));
        this._emptyBox.setPreferredSize(new Dimension(this._protoType.getPreferredSize().width, 0));
        this.applyComponentOrientation(jTree.getComponentOrientation());
        TreePath treePath = jTree.getPathForRow(n);
        if (treePath != null && jTree instanceof CheckBoxTree && (serializable = ((CheckBoxTree)jTree).getCheckBoxTreeSelectionModel()) != null) {
            boolean bl5;
            boolean bl6 = bl5 = jTree.isEnabled() && ((CheckBoxTree)jTree).isCheckBoxEnabled() && ((CheckBoxTree)jTree).isCheckBoxEnabled(treePath);
            if (!bl5 && !bl && this.getBackground() != null) {
                this.setForeground(this.getBackground().darker());
            }
            this._checkBox.setEnabled(bl5);
            this.updateCheckBoxState(this._checkBox, treePath, (CheckBoxTreeSelectionModel)serializable);
        }
        if (this._actualTreeRenderer != null) {
            serializable = (JComponent)this._actualTreeRenderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            Border border = ((JComponent)serializable).getBorder();
            this.setBorder(border);
            ((JComponent)serializable).setBorder(BorderFactory.createEmptyBorder());
            if (treePath == null || !(jTree instanceof CheckBoxTree) || ((CheckBoxTree)jTree).isCheckBoxVisible(treePath)) {
                this.remove(this._emptyBox);
                this.add((Component)this._checkBox, "Before");
            } else {
                this.remove(this._checkBox);
                this.add((Component)this._emptyBox, "After");
            }
            this.add((Component)serializable);
        }
        return this;
    }

    protected void updateCheckBoxState(TristateCheckBox tristateCheckBox, TreePath treePath, CheckBoxTreeSelectionModel checkBoxTreeSelectionModel) {
        if (checkBoxTreeSelectionModel.isPathSelected(treePath, checkBoxTreeSelectionModel.isDigIn())) {
            tristateCheckBox.setState(TristateCheckBox.SELECTED);
        } else {
            tristateCheckBox.setState((TristateCheckBox.State)(checkBoxTreeSelectionModel.isDigIn() && checkBoxTreeSelectionModel.isPartiallySelected(treePath) ? null : TristateCheckBox.NOT_SELECTED));
        }
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (this._actualTreeRenderer instanceof JComponent) {
            Point point = mouseEvent.getPoint();
            point.translate(-this._checkBox.getWidth(), 0);
            MouseEvent mouseEvent2 = new MouseEvent((JComponent)((Object)this._actualTreeRenderer), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            String string = ((JComponent)((Object)this._actualTreeRenderer)).getToolTipText(mouseEvent2);
            if (string != null) {
                return string;
            }
        }
        return super.getToolTipText(mouseEvent);
    }
}

