/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.cots.twaver.gis;

import com.nepxion.cots.twaver.gis.TGisGraph;
import com.nepxion.cots.twaver.gis.TGisGraphScaleBar;
import com.nepxion.cots.twaver.gis.TGisNavigator;
import com.nepxion.cots.twaver.gis.TGisOverview;
import com.nepxion.cots.twaver.gis.TMapType;
import com.nepxion.cots.twaver.graph.TGraph;
import com.nepxion.cots.twaver.graph.TInternalFrame;
import com.nepxion.cots.twaver.icon.TIconFactory;
import com.nepxion.cots.twaver.locale.TLocale;
import java.awt.Component;
import java.awt.Dimension;
import twaver.gis.GeographyMap;
import twaver.gis.utils.GisInputHandlerFactory;
import twaver.gis.utils.GisToolkits;
import twaver.network.TNetwork;

public class TGisGraphManager {
    public static void select(TGisGraph gisGraph) {
        GeographyMap map = gisGraph.getMap();
        if (map != null) {
            gisGraph.setInteractionMode(GisInputHandlerFactory.createDefaultMode((TNetwork)gisGraph, (GeographyMap)map));
        }
    }

    public static void pan(TGisGraph gisGraph) {
        GeographyMap map = gisGraph.getMap();
        if (map != null) {
            gisGraph.setInteractionMode(GisInputHandlerFactory.createPanMode((TNetwork)gisGraph, (GeographyMap)map));
            gisGraph.getCanvas().setCursor(TGisGraph.PAN_CURSOR);
        }
    }

    public static void zoomIn(TGisGraph gisGraph) {
        GeographyMap map = gisGraph.getMap();
        if (map != null) {
            gisGraph.setInteractionMode(GisInputHandlerFactory.createZoomMode((TNetwork)gisGraph, (GeographyMap)map, (int)0));
            gisGraph.getCanvas().setCursor(TGisGraph.ZOOM_IN_CURSOR);
        }
    }

    public static void zoomOut(TGisGraph gisGraph) {
        GeographyMap map = gisGraph.getMap();
        if (map != null) {
            gisGraph.setInteractionMode(GisInputHandlerFactory.createZoomMode((TNetwork)gisGraph, (GeographyMap)map, (int)1));
            gisGraph.getCanvas().setCursor(TGisGraph.ZOOM_OUT_CURSOR);
        }
    }

    public static void zoomReset(TGisGraph gisGraph) {
        GeographyMap map = gisGraph.getMap();
        if (map != null) {
            gisGraph.setInteractionMode(GisInputHandlerFactory.createResetMode((TNetwork)gisGraph, (GeographyMap)map));
        }
    }

    public static void zoomBack(TGisGraph gisGraph) {
        GeographyMap map = gisGraph.getMap();
        if (map != null) {
            GisToolkits.goBack((TNetwork)gisGraph, (GeographyMap)map);
        }
    }

    public static void navigator(TGisGraph gisGraph) {
        TGisNavigator gisNavigator;
        gisNavigator.showout(!(gisNavigator = gisGraph.getGisNavigator()).isShowing());
    }

    public static void distance(TGisGraph gisGraph) {
        GeographyMap map = gisGraph.getMap();
        if (map != null) {
            gisGraph.setInteractionMode(GisInputHandlerFactory.createDistanceMode((TNetwork)gisGraph, (GeographyMap)map));
        }
    }

    public static void scale(TGisGraph gisGraph) {
        TInternalFrame scaleInternalFrame = gisGraph.getScaleInternalFrame();
        if (scaleInternalFrame == null) {
            TGisGraphScaleBar scaleBar = new TGisGraphScaleBar(gisGraph);
            scaleBar.setPreferredSize(new Dimension(540, 20));
            scaleInternalFrame = new TInternalFrame((TGraph)gisGraph, TLocale.getString("graph_scale"), TIconFactory.getContextIcon("scale.png"), (Component)((Object)scaleBar));
            scaleInternalFrame.setResizable(false);
            scaleInternalFrame.setLocation(0, gisGraph.getViewport().getHeight() - scaleInternalFrame.getHeight() + 2);
            scaleInternalFrame.setHorizontalTweening(true);
            scaleInternalFrame.setVerticalTweening(false);
            scaleInternalFrame.setTweeningDimension(scaleInternalFrame.getSize());
            gisGraph.getLayeredPane().add(scaleInternalFrame);
            gisGraph.setScaleInternalFrame(scaleInternalFrame);
        }
        if (!scaleInternalFrame.isVisible()) {
            scaleInternalFrame.tween(true);
        } else {
            scaleInternalFrame.tween(false);
        }
    }

    public static void overview(TGisGraph gisGraph) {
        TGisOverview overview = gisGraph.getGisOverview();
        if (overview == null) {
            overview = new TGisOverview(gisGraph, TLocale.getString("graph_overview"), new Dimension(150, 150), TIconFactory.getContextIcon("overview.png"));
            overview.setLocation(gisGraph.getViewport().getWidth() - overview.getWidth() + 2, gisGraph.getViewport().getHeight() - overview.getHeight() + 2);
            overview.setHorizontalTweening(true);
            overview.setVerticalTweening(true);
            overview.setTweeningDimension(overview.getSize());
            gisGraph.getLayeredPane().add((Component)((Object)overview));
            gisGraph.setOverview(overview);
        }
        if (!overview.isVisible()) {
            overview.tween(true);
        } else {
            overview.tween(false);
        }
    }

    public static void setMapType(TGisGraph gisGraph, TMapType mapType) {
        GeographyMap map = gisGraph.getMap();
        map.removeAllLayers();
        map.addLayer(mapType.getName(), mapType.getType());
    }
}

