/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.thread.container;

import com.nepxion.swing.layout.table.TableLayout;
import com.nepxion.swing.scrollpane.JBasicScrollPane;
import com.nepxion.swing.timer.JTimerProgressBar;
import com.nepxion.swing.timer.JTimerProgressPanel;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class AbstractThreadPanel
extends JBasicScrollPane {
    private JPanel panel;
    private JTimerProgressPanel progressPanel;

    public AbstractThreadPanel(JLabel animationLabel, String information) {
        this.progressPanel = new JTimerProgressPanel(animationLabel, information){

            @Override
            public void fireHidden() {
                AbstractThreadPanel.this.fireHidden();
            }

            @Override
            public void fireCancelled() {
                AbstractThreadPanel.this.fireCancelled();
            }
        };
        double[][] size = new double[][]{{-1.0, -2.0, -1.0}, {-1.0, -2.0, -1.0}};
        this.panel = new JPanel();
        this.panel.setLayout(new TableLayout(size));
        this.panel.add((Component)this.progressPanel, "1, 1");
        this.setBackgound(this.panel, Color.white);
        this.getViewport().add(this.panel);
    }

    public void reset() {
        this.progressPanel.reset();
    }

    public void start() {
        this.progressPanel.start();
    }

    public void start(int delayTime) {
        this.progressPanel.start(delayTime);
    }

    public void restart() {
        this.progressPanel.restart();
    }

    public void restart(int delayTime) {
        this.progressPanel.restart(delayTime);
    }

    public void stop() {
        this.progressPanel.stop();
    }

    public void finish() {
        this.progressPanel.finish();
    }

    public JTimerProgressPanel getProgressPanel() {
        return this.progressPanel;
    }

    public JTimerProgressBar getProgressBar() {
        return this.progressPanel.getTimerProgressBar();
    }

    public void setWidth(int width) {
        if (this.panel.getLayout() instanceof TableLayout) {
            TableLayout tableLayout = (TableLayout)this.panel.getLayout();
            tableLayout.setColumn(1, width);
        }
    }

    public void setHeight(int height) {
        if (this.panel.getLayout() instanceof TableLayout) {
            TableLayout tableLayout = (TableLayout)this.panel.getLayout();
            tableLayout.setRow(1, height);
        }
    }

    private void setBackgound(JComponent component, Color background) {
        for (int i = 0; i < component.getComponentCount(); ++i) {
            JComponent childComponent = (JComponent)component.getComponent(i);
            if (!(childComponent instanceof JPanel)) continue;
            this.setBackgound(childComponent, background);
        }
        component.setBackground(background);
    }

    protected abstract void fireHidden();

    protected abstract void fireCancelled();
}

