/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.spinner;

import com.nepxion.swing.textfield.JBasicTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingConstants;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JNumberSpinnerField
extends JPanel
implements ChangeListener,
CaretListener,
ActionListener,
SwingConstants {
    protected JSpinner spinner;
    protected JBasicTextField textField;
    protected int min;
    protected int max;
    protected int value;
    protected Color darkGreen;

    public JNumberSpinnerField() {
        this(0, Integer.MAX_VALUE);
    }

    public JNumberSpinnerField(int min, int max) {
        this.min = min;
        if (max < min) {
            max = min;
        }
        this.max = max;
        this.value = 0;
        if (this.value < min) {
            this.value = min;
        }
        if (this.value > max) {
            this.value = max;
        }
        this.darkGreen = new Color(0, 150, 0);
        this.setLayout(new BorderLayout());
        this.textField = new JBasicTextField();
        this.textField.addCaretListener(this);
        this.textField.addActionListener(this);
        this.textField.setHorizontalAlignment(4);
        this.textField.setBorder(BorderFactory.createEmptyBorder());
        this.textField.setText(Integer.toString(this.value));
        this.spinner = new JSpinner();
        this.spinner.setEditor(this.textField);
        this.spinner.addChangeListener(this);
        this.add((Component)this.spinner, "Center");
    }

    public void adjustWidthToMaximumValue() {
        JTextField testTextField = new JTextField(Integer.toString(this.max));
        int width = testTextField.getPreferredSize().width;
        int height = testTextField.getPreferredSize().height;
        this.textField.setPreferredSize(new Dimension(width, height));
        this.textField.revalidate();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        SpinnerNumberModel model = (SpinnerNumberModel)this.spinner.getModel();
        int value = model.getNumber().intValue();
        this.setValue(value);
    }

    protected void setValue(int newValue, boolean updateTextField, boolean firePropertyChange) {
        int oldValue = this.value;
        this.value = newValue < this.min ? this.min : (newValue > this.max ? this.max : newValue);
        if (updateTextField) {
            this.textField.setText(Integer.toString(this.value));
            this.textField.setForeground(Color.black);
        }
        if (firePropertyChange) {
            this.firePropertyChange("value", oldValue, this.value);
        }
    }

    public void setValue(int newValue) {
        this.setValue(newValue, true, true);
        this.spinner.setValue(new Integer(this.value));
    }

    public int getValue() {
        return this.value;
    }

    public void setMinimum(int newMinimum) {
        this.min = newMinimum;
    }

    public int getMinimum() {
        return this.min;
    }

    public void setMaximum(int newMaximum) {
        this.max = newMaximum;
    }

    public void setHorizontalAlignment(int alignment) {
        this.textField.setHorizontalAlignment(alignment);
    }

    public int getMaximum() {
        return this.max;
    }

    @Override
    public void setFont(Font font) {
        if (this.textField != null) {
            this.textField.setFont(font);
        }
    }

    @Override
    public void setForeground(Color fg) {
        if (this.textField != null) {
            this.textField.setForeground(fg);
        }
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        block4: {
            try {
                int testValue = Integer.valueOf(this.textField.getText());
                if (testValue >= this.min && testValue <= this.max) {
                    this.textField.setForeground(this.darkGreen);
                    this.setValue(testValue, false, true);
                } else {
                    this.textField.setForeground(Color.red);
                }
            }
            catch (Exception ex) {
                if (!(ex instanceof NumberFormatException)) break block4;
                this.textField.setForeground(Color.red);
            }
        }
        this.textField.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.textField.getForeground().equals(this.darkGreen)) {
            this.setValue(Integer.valueOf(this.textField.getText()));
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.textField.setEnabled(enabled);
        this.spinner.setEnabled(enabled);
    }

    public Component getSpinner() {
        return this.spinner;
    }

    @Override
    public String getName() {
        return "JSpinnerField";
    }
}

