/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.framework.ribbon.action;

import com.nepxion.swing.action.JSecurityAction;
import com.nepxion.swing.exception.ExceptionTracer;
import com.nepxion.swing.framework.ribbon.IRibbonComponent;
import com.nepxion.swing.framework.ribbon.JRibbonContainer;
import com.nepxion.swing.handle.HandleManager;
import com.nepxion.swing.locale.SwingLocale;
import java.awt.event.ActionEvent;
import javax.swing.Icon;

public class JRibbonAction
extends JSecurityAction {
    private JRibbonContainer ribbonContainer;
    private String ribbonName;
    private String ribbonTitle;
    private Icon ribbonIcon;
    private String ribbonToolTipText;
    private String ribbonComponentClass;
    private IRibbonComponent ribbonComponent;

    public JRibbonAction() {
    }

    public JRibbonAction(String text) {
        super(text);
    }

    public JRibbonAction(Icon icon) {
        super(icon);
    }

    public JRibbonAction(String text, Icon icon) {
        super(text, icon);
    }

    public JRibbonAction(String text, String toolTipText) {
        super(text, toolTipText);
    }

    public JRibbonAction(Icon icon, String toolTipText) {
        super(icon, toolTipText);
    }

    public JRibbonAction(String text, Icon icon, String toolTipText) {
        super(text, icon, toolTipText);
    }

    public JRibbonAction(String name, String text, String toolTipText) {
        super(name, text, toolTipText);
    }

    public JRibbonAction(String name, String text, Icon icon, String toolTipText) {
        super(name, text, icon, toolTipText);
    }

    public JRibbonContainer getRibbonContainer() {
        return this.ribbonContainer;
    }

    public void setRibbonContainer(JRibbonContainer ribbonContainer) {
        this.ribbonContainer = ribbonContainer;
    }

    public String getRibbonName() {
        return this.ribbonName;
    }

    public void setRibbonName(String ribbonName) {
        this.ribbonName = ribbonName;
    }

    public String getRibbonTitle() {
        return this.ribbonTitle;
    }

    public void setRibbonTitle(String ribbonTitle) {
        this.ribbonTitle = ribbonTitle;
    }

    public Icon getRibbonIcon() {
        return this.ribbonIcon;
    }

    public void setRibbonIcon(Icon ribbonIcon) {
        this.ribbonIcon = ribbonIcon;
    }

    public String getRibbonToolTipText() {
        return this.ribbonToolTipText;
    }

    public void setRibbonToolTipText(String ribbonToolTipText) {
        this.ribbonToolTipText = ribbonToolTipText;
    }

    public String getRibbonComponentClass() {
        return this.ribbonComponentClass;
    }

    public void setRibbonComponentClass(String ribbonComponentClass) {
        this.ribbonComponentClass = ribbonComponentClass;
    }

    public IRibbonComponent getRibbonComponent() {
        return this.ribbonComponent;
    }

    public void setRibbonComponent(IRibbonComponent ribbonComponent) {
        this.ribbonComponent = ribbonComponent;
    }

    @Override
    public void execute(ActionEvent e) {
        if (this.ribbonComponent == null) {
            try {
                this.ribbonComponent = (IRibbonComponent)Class.forName(this.ribbonComponentClass).newInstance();
            }
            catch (NullPointerException ex) {
                ExceptionTracer.traceException(HandleManager.getFrame(this.ribbonContainer), SwingLocale.getString("component_initialization_failed") + " [" + this.ribbonComponentClass + "]", ex);
                ex.printStackTrace();
                return;
            }
            catch (ClassCastException ex) {
                ExceptionTracer.traceException(HandleManager.getFrame(this.ribbonContainer), SwingLocale.getString("component_implementation_failed") + " " + IRibbonComponent.class.getSimpleName() + " [" + this.ribbonComponentClass + "]", ex);
                ex.printStackTrace();
                return;
            }
            catch (Exception ex) {
                ExceptionTracer.traceException(HandleManager.getFrame(this.ribbonContainer), SwingLocale.getString("component_instantiation_failed") + " [" + this.ribbonComponentClass + "]", ex);
                ex.printStackTrace();
                return;
            }
        }
        this.ribbonContainer.addRibbonComponent(this.ribbonName, this.ribbonTitle, this.ribbonIcon, this.ribbonToolTipText, this.ribbonComponent);
    }
}

