/*
 * Decompiled with CFR 0.152.
 */
package twaver.web.svg.network.ui;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import twaver.Link;
import twaver.Node;
import twaver.base.A.D.B;
import twaver.base.A.E.T;
import twaver.base.OrthogonalLinkDirectionType;
import twaver.web.svg.network.MapNetwork;
import twaver.web.svg.network.SVGContext;
import twaver.web.svg.network.SVGStruct;
import twaver.web.svg.network.TSVGNetwork;
import twaver.web.svg.network.ui.LinkSVGUI;

public class InterceptedLinkSVGUI
extends LinkSVGUI {
    private Rectangle F;
    private double H;
    private double J;
    private double G;
    private double I;

    public InterceptedLinkSVGUI(MapNetwork network, Link link) {
        super((TSVGNetwork)network, link);
    }

    public SVGStruct toSVG(SVGContext context) {
        this.F = ((MapNetwork)this.network).getViewport();
        Node from = this.link.getFromAgent();
        Node to = this.link.getToAgent();
        Point centerLocationFrom = from.getCenterLocation();
        Point centerLocationTo = to.getCenterLocation();
        this.H = centerLocationFrom.x;
        this.J = centerLocationFrom.y;
        this.G = centerLocationTo.x;
        this.I = centerLocationTo.y;
        boolean containFrom = this.F.contains(this.H, this.J);
        boolean containTo = this.F.contains(this.G, this.I);
        boolean intersects = this.F.intersectsLine(this.G, this.I, this.H, this.J);
        if (containFrom && containTo) {
            return super.toSVG(context);
        }
        if (containFrom || containTo || intersects) {
            return super.toSVG(context);
        }
        return SVGStruct.EMPTY;
    }

    public Point getHotspot(SVGContext context) {
        return super.getHotspot(context);
    }

    protected GeneralPath createLinkPath(SVGContext context) {
        Point2D[] segmentLinePoints = InterceptedLinkSVGUI.B(this.H, this.J, this.G, this.I, this.F);
        if (segmentLinePoints == null) {
            return null;
        }
        int type = this.link.getLinkType();
        int bundleIndex = this.link.getLinkBundleIndex();
        int bundleSize = this.link.getLinkBundleSize();
        boolean bundleAgent = this.link.isBundleAgent();
        double proportion = this.link.getLinkProportion();
        int extend = this.link.getLinkExtend();
        Point fromPoint = new Point();
        fromPoint.setLocation(segmentLinePoints[0].getX(), segmentLinePoints[0].getY());
        Point toPoint = new Point();
        toPoint.setLocation(segmentLinePoints[1].getX(), segmentLinePoints[1].getY());
        Node from = this.link.getFromAgent();
        Node to = this.link.getToAgent();
        B struct = null;
        this.fromBounds = this.getFromBounds(context, from);
        this.toBounds = this.getToBounds(context, to);
        if (type == 2 || type == 4) {
            struct = new B(this.link, context, this.network, this.fromBounds, this.toBounds);
        }
        Point orthogonalPoint = null;
        if (type == 3) {
            orthogonalPoint = OrthogonalLinkDirectionType.X_TO_Y.equals(this.link.getLinkOrthogonalDirection()) ? new Point(fromPoint.x, toPoint.y) : new Point(toPoint.x, fromPoint.y);
        }
        return T.A(type, bundleIndex, bundleSize, bundleAgent, proportion, extend, fromPoint, toPoint, context.getBounds(from), context.getBounds(to), struct, orthogonalPoint, this.network, this.link);
    }

    private static Point2D[] B(double x0, double y0, double x1, double y1, Rectangle2D window) {
        Point2D[] result = new Point2D[2];
        double y = y1;
        double x = x1;
        boolean contain0 = window.contains(x0, y0);
        boolean contain1 = window.contains(x1, y1);
        if (contain0 || contain1) {
            if (!contain0) {
                x1 = x0;
                y1 = y0;
                x0 = x;
                y0 = y;
            }
            if (x1 <= window.getMinX()) {
                x = window.getMinX();
                y = y0 + (y1 - y0) * (x - x0) / (x1 - x0);
                if (y < window.getY()) {
                    y = window.getMinY();
                    x = x0 + (y - y0) * (x1 - x0) / (y1 - y0);
                } else if (y > window.getMaxY()) {
                    y = window.getMaxY();
                    x = x0 + (y - y0) * (x1 - x0) / (y1 - y0);
                }
            } else if (x1 >= window.getMaxX()) {
                x = window.getMaxX();
                y = y0 + (y1 - y0) * (x - x0) / (x1 - x0);
                if (y < window.getMinY()) {
                    y = window.getMinY();
                    x = x0 + (y - y0) * (x1 - x0) / (y1 - y0);
                } else if (y > window.getMaxY()) {
                    y = window.getMaxY();
                    x = x0 + (y - y0) * (x1 - x0) / (y1 - y0);
                }
            } else {
                if (y1 <= window.getMinY()) {
                    y = window.getMinY();
                } else if (y1 >= window.getMaxY()) {
                    y = window.getMaxY();
                }
                if (y1 != y0) {
                    x = x0 + (y - y0) * (x1 - x0) / (y1 - y0);
                }
            }
            result[1] = new Point2D.Double(x, y);
            result[0] = new Point2D.Double(x0, y0);
        } else {
            double rx = window.getMaxX();
            double by = window.getMaxY();
            if (x0 >= rx && x1 >= rx || y0 >= by && y1 >= by) {
                result = null;
            } else {
                Point2D left = InterceptedLinkSVGUI.A(x0, y0, x1, y1, window);
                Point2D top = InterceptedLinkSVGUI.E(x0, y0, x1, y1, window);
                Point2D bottom = InterceptedLinkSVGUI.C(x0, y0, x1, y1, window);
                Point2D right = InterceptedLinkSVGUI.D(x0, y0, x1, y1, window);
                Point2D[] points = new Point2D[]{left, top, bottom, right};
                Vector<Point2D> validatePoints = new Vector<Point2D>();
                for (int i2 = 0; i2 < points.length; ++i2) {
                    if (!InterceptedLinkSVGUI.A(points[i2], window)) continue;
                    validatePoints.add(points[i2]);
                }
                if (validatePoints.size() == 2) {
                    Point2D p1 = (Point2D)validatePoints.get(0);
                    Point2D p2 = (Point2D)validatePoints.get(1);
                    if (p1.getX() <= p2.getX()) {
                        result[0] = p1;
                        result[1] = p2;
                    } else {
                        result[0] = p2;
                        result[1] = p1;
                    }
                }
            }
        }
        return result;
    }

    private static boolean A(Point2D point, Rectangle2D window) {
        double x = point.getX();
        double y = point.getY();
        return window.getMinX() <= x && window.getMaxX() >= x && window.getMinY() <= y && window.getMaxY() >= y;
    }

    private static Point2D A(double x0, double y0, double x1, double y1, Rectangle2D window) {
        double x = window.getMinX();
        double y = y0 + (y1 - y0) * (x - x0) / (x1 - x0);
        return new Point2D.Double(x, y);
    }

    private static Point2D D(double x0, double y0, double x1, double y1, Rectangle2D window) {
        double x = window.getMaxX();
        double y = y0 + (y1 - y0) * (x - x0) / (x1 - x0);
        return new Point2D.Double(x, y);
    }

    private static Point2D E(double x0, double y0, double x1, double y1, Rectangle2D window) {
        double y = window.getMinY();
        double x = x0 + (y - y0) * (x1 - x0) / (y1 - y0);
        return new Point2D.Double(x, y);
    }

    private static Point2D C(double x0, double y0, double x1, double y1, Rectangle2D window) {
        double y = window.getMaxY();
        double x = x0 + (y - y0) * (x1 - x0) / (y1 - y0);
        return new Point2D.Double(x, y);
    }
}

