/*
 * Decompiled with CFR 0.152.
 */
package twaver.network.inputhandler;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.SwingUtilities;
import twaver.Element;
import twaver.TWaverUtil;
import twaver.base.A.E.P;
import twaver.base.A.E.m;
import twaver.network.CanvasMarker;
import twaver.network.DraggingSpeed;
import twaver.network.TNetwork;
import twaver.network.inputhandler.InputAdapter;

public class SelectionInputHandler
extends InputAdapter
implements CanvasMarker {
    private static final Color N = new Color(255, 255, 255, 100);
    private TNetwork P = null;
    private Point Q = null;
    private Point O = null;

    public SelectionInputHandler(TNetwork network) {
        this.P = network;
    }

    public void init() {
        this.P.getCanvas().setCursor(this.P.getDefaultCursor());
    }

    private boolean A(MouseEvent e2) {
        return this.P.isSelectableOnRightClick() || !SwingUtilities.isRightMouseButton(e2);
    }

    public void mousePressed(MouseEvent e2) {
        this.P.getCanvas().requestFocus();
        if (!this.A(e2)) {
            return;
        }
        if (m.G(this.P) || m.E(this.P)) {
            return;
        }
        if (SwingUtilities.isMiddleMouseButton(e2)) {
            return;
        }
        this.Q = e2.getPoint();
        if (twaver.base.A.E.P.C(e2)) {
            return;
        }
        Element element = this.P.getElementPhysicalAt(e2.getPoint());
        if (element == null) {
            if (twaver.base.A.E.P.A(e2) && this.P.isClearSelectionOnMarginClicked()) {
                this.P.clearSelection();
            }
            return;
        }
        if (twaver.base.A.E.P.A(e2)) {
            if (!element.isSelected()) {
                this.P.setSelection(element);
            }
        } else {
            Element lastElement = this.P.getLastSelectedElement();
            if (element.isSelected()) {
                this.P.removeSelection(element);
            } else {
                this.P.appendSelection(element);
                if (e2.isShiftDown() && !e2.isControlDown() && lastElement != null) {
                    Rectangle rect1 = this.P.getElementBounds(lastElement);
                    Rectangle rect2 = this.P.getElementBounds(element);
                    if (rect1 != null && rect2 != null) {
                        rect1.add(rect2);
                        rect1.grow(2, 2);
                        List list = m.A(this.P, rect1, false);
                        this.P.getDataBox().getSelectionModel().appendSelection(list);
                    }
                }
            }
        }
        this.Q = null;
    }

    public void mouseReleased(MouseEvent e2) {
        if (!this.A(e2)) {
            return;
        }
        if (m.G(this.P) || m.E(this.P)) {
            return;
        }
        if (this.Q != null && this.O != null) {
            m.A(this.P, this.Q, this.O, this.B());
            Rectangle rect = TWaverUtil.getRectangle(this.Q, this.O);
            this.P.getRenderer().repaintPhysicalBounds(rect);
        }
        m.B(this.P, false, this);
        this.O = null;
        this.Q = null;
    }

    public void mouseDragged(MouseEvent e2) {
        if (m.G(this.P) || m.E(this.P)) {
            return;
        }
        if (this.Q == null) {
            return;
        }
        m.B(this.P, true, this);
        for (int i2 = 0; i2 < 2; ++i2) {
            if (this.O != null) {
                Rectangle rect = TWaverUtil.getRectangle(this.Q, this.O);
                this.P.getRenderer().repaintPhysicalBounds(rect);
            }
            this.O = e2.getPoint();
        }
        DraggingSpeed.adjustCanvas(e2.getPoint(), this.P);
    }

    public TNetwork getNetwork() {
        return this.P;
    }

    private boolean B() {
        if (this.P.getSelectionMode() == 1) {
            return true;
        }
        if (this.P.getSelectionMode() == 2) {
            return false;
        }
        return this.Q.x > this.O.x && this.Q.y > this.O.y;
    }

    public void mark(Graphics2D g2) {
        if (this.Q != null && this.O != null) {
            TWaverUtil.drawDashRectangle(g2, this.Q, this.O, this.P.getZoomer().getZoom());
            if (this.B()) {
                Rectangle rect = TWaverUtil.getRectangle(this.Q, this.O);
                double zoom = this.P.getZoomer().getZoom();
                rect.x = (int)((double)rect.x / zoom);
                rect.y = (int)((double)rect.y / zoom);
                rect.width = (int)((double)rect.width / zoom);
                rect.height = (int)((double)rect.height / zoom);
                if (rect.width <= 1 || rect.height <= 1) {
                    return;
                }
                g2.setColor(N);
                g2.fillRect(rect.x + 1, rect.y + 1, rect.width - 1, rect.height - 1);
            }
        }
    }
}

