/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class ComponentTitledBorder
extends TitledBorder {
    private Component component;

    public ComponentTitledBorder(Component component) {
        this(null, component, 1, 2);
    }

    public ComponentTitledBorder(Border border) {
        this(border, (Component)null, 1, 2);
    }

    public ComponentTitledBorder(Border border, Component component) {
        this(border, component, 1, 2);
    }

    public ComponentTitledBorder(Border border, Component component, int titleJustification, int titlePosition) {
        super(border, null, titleJustification, titlePosition, null, null);
        this.component = component;
        if (border == null) {
            this.border = super.getBorder();
        }
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    public Rectangle getComponentRectangle(Rectangle rect, Insets insets) {
        Dimension dimension = this.component.getPreferredSize();
        Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
        switch (this.titlePosition) {
            case 1: {
                rectangle.y = 2;
                break;
            }
            case 0: 
            case 2: {
                rectangle.y = 2 + (insets.top - 2 - 2 - dimension.height) / 2;
                break;
            }
            case 3: {
                rectangle.y = insets.top - dimension.height - 2;
                break;
            }
            case 4: {
                rectangle.y = rect.height - insets.bottom + 2;
                break;
            }
            case 5: {
                rectangle.y = rect.height - insets.bottom + 2 + (insets.bottom - 2 - 2 - dimension.height) / 2;
                break;
            }
            case 6: {
                rectangle.y = rect.height - dimension.height - 2;
            }
        }
        switch (this.titleJustification) {
            case 0: 
            case 1: {
                rectangle.x = 5 + insets.left;
                break;
            }
            case 3: {
                rectangle.x = rect.width - insets.right - 5 - rectangle.width;
                break;
            }
            case 2: {
                rectangle.x = (rect.width - rectangle.width) / 2;
            }
        }
        return rectangle;
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        Insets borderInsets = this.border != null ? this.border.getBorderInsets(c) : new Insets(0, 0, 0, 0);
        insets.top = 4 + borderInsets.top;
        insets.right = 4 + borderInsets.right;
        insets.bottom = 4 + borderInsets.bottom;
        insets.left = 4 + borderInsets.left;
        if (c == null || this.component == null) {
            return insets;
        }
        int height = 0;
        if (this.component != null) {
            height = this.component.getPreferredSize().height;
        }
        switch (this.titlePosition) {
            case 1: {
                insets.top += height + 2;
                break;
            }
            case 0: 
            case 2: {
                insets.top += Math.max(height, borderInsets.top) - borderInsets.top;
                break;
            }
            case 3: {
                insets.top += height + 2;
                break;
            }
            case 4: {
                insets.bottom += height + 2;
                break;
            }
            case 5: {
                insets.bottom += Math.max(height, borderInsets.bottom) - borderInsets.bottom;
                break;
            }
            case 6: {
                insets.bottom += height + 2;
            }
        }
        return insets;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Rectangle borderRectangle = new Rectangle(x + 2, y + 2, width - 4, height - 4);
        Insets borderInsets = this.border != null ? this.border.getBorderInsets(c) : new Insets(0, 0, 0, 0);
        Rectangle rectangle = new Rectangle(x, y, width, height);
        Insets insets = this.getBorderInsets(c);
        Rectangle componentRectangle = this.getComponentRectangle(rectangle, insets);
        switch (this.titlePosition) {
            case 1: {
                int diff = componentRectangle.height + 2;
                borderRectangle.y += diff;
                borderRectangle.height -= diff;
                break;
            }
            case 0: 
            case 2: {
                int diff = insets.top / 2 - borderInsets.top - 2;
                borderRectangle.y += diff;
                borderRectangle.height -= diff;
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                int diff = insets.bottom / 2 - borderInsets.bottom - 2;
                borderRectangle.height -= diff;
                break;
            }
            case 6: {
                int diff = componentRectangle.height + 2;
                borderRectangle.height -= diff;
            }
        }
        this.border.paintBorder(c, g, borderRectangle.x, borderRectangle.y, borderRectangle.width, borderRectangle.height);
        Color color = g.getColor();
        g.setColor(c.getBackground());
        g.fillRect(componentRectangle.x, componentRectangle.y, componentRectangle.width, componentRectangle.height);
        g.setColor(color);
        this.component.repaint();
    }
}

