/*
 * Decompiled with CFR 0.152.
 */
package y.view;

import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeMap;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeMap;
import y.util.EdgeMapAdapter;
import y.util.NodeMapAdapter;
import y.view.BendCursor;
import y.view.Graph2D;

public abstract class Selections {
    private Selections() {
    }

    public static void selectNodesAndSelfLoopBends(Graph2D graph2D) {
        NodeCursor nodeCursor = graph2D.nodes();
        while (nodeCursor.ok()) {
            Selections.selectNodeAndSelfLoopBends(graph2D, nodeCursor.node());
            nodeCursor.next();
        }
    }

    public static void selectNodeAndSelfLoopBends(Graph2D graph2D, Node node) {
        graph2D.setSelected(node, true);
        EdgeCursor edgeCursor = node.outEdges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            if (edge.isSelfLoop()) {
                BendCursor bendCursor = graph2D.getRealizer(edge).bends();
                while (bendCursor.ok()) {
                    bendCursor.bend().setSelected(true);
                    bendCursor.next();
                }
            }
            edgeCursor.next();
        }
    }

    public static void deselectNodeAndSelfLoopBends(Graph2D graph2D, Node node) {
        graph2D.setSelected(node, false);
        EdgeCursor edgeCursor = node.outEdges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            if (edge.isSelfLoop()) {
                BendCursor bendCursor = graph2D.getRealizer(edge).bends();
                while (bendCursor.ok()) {
                    bendCursor.bend().setSelected(false);
                    bendCursor.next();
                }
            }
            edgeCursor.next();
        }
    }

    public static DataProvider createSelectionDataProvider(Graph2D graph2D) {
        return new _do(Selections.createSelectionNodeMap(graph2D), Selections.createSelectionEdgeMap(graph2D));
    }

    public static NodeMap createSelectionNodeMap(Graph2D graph2D) {
        return new _if(graph2D);
    }

    public static EdgeMap createSelectionEdgeMap(Graph2D graph2D) {
        return new _a(graph2D);
    }

    private static final class _do
    implements DataProvider {
        private NodeMap an;
        private EdgeMap am;

        _do(NodeMap nodeMap, EdgeMap edgeMap) {
            this.an = nodeMap;
            this.am = edgeMap;
        }

        public Object get(Object object) {
            if (object instanceof Node) {
                return this.an.get(object);
            }
            if (object instanceof Edge) {
                return this.am.get(object);
            }
            return null;
        }

        public boolean getBool(Object object) {
            if (object instanceof Node) {
                return this.an.getBool(object);
            }
            if (object instanceof Edge) {
                return this.am.getBool(object);
            }
            return false;
        }

        public double getDouble(Object object) {
            if (object instanceof Node) {
                return this.an.getDouble(object);
            }
            if (object instanceof Edge) {
                return this.am.getDouble(object);
            }
            return 0.0;
        }

        public int getInt(Object object) {
            if (object instanceof Node) {
                return this.an.getInt(object);
            }
            if (object instanceof Edge) {
                return this.am.getInt(object);
            }
            return 0;
        }
    }

    private static final class _a
    extends EdgeMapAdapter {
        private Graph2D e;

        _a(Graph2D graph2D) {
            this.e = graph2D;
        }

        public void setBool(Object object, boolean bl) {
            this.e.setSelected((Edge)object, bl);
        }

        public boolean getBool(Object object) {
            return this.e.isSelected((Edge)object);
        }
    }

    private static final class _if
    extends NodeMapAdapter {
        private Graph2D j;

        _if(Graph2D graph2D) {
            this.j = graph2D;
        }

        public void setBool(Object object, boolean bl) {
            this.j.setSelected((Node)object, bl);
        }

        public boolean getBool(Object object) {
            return this.j.isSelected((Node)object);
        }
    }
}

