/*
 * Decompiled with CFR 0.152.
 */
package twaver.network.ui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.util.Iterator;
import twaver.Link;
import twaver.LinkStyleFactory;
import twaver.Node;
import twaver.ShapeNode;
import twaver.TDataBox;
import twaver.TSubNetwork;
import twaver.TWaverConst;
import twaver.VisibleFilter;
import twaver.base.A.D.A.B;
import twaver.base.A.E.D;
import twaver.base.A.E.K;
import twaver.base.A.E.L;
import twaver.base.A.E.N;
import twaver.base.A.E.S;
import twaver.base.A.E.W;
import twaver.base.A.E.Y;
import twaver.base.A.E.d;
import twaver.base.A.E.n;
import twaver.base.OrthogonalLinkDirectionType;
import twaver.network.TNetwork;
import twaver.network.ui.AbstractElementUI;
import twaver.network.ui.Attachment;
import twaver.network.ui.BorderUI;
import twaver.network.ui.GroupUI;
import twaver.network.ui.LinkBorderUI;
import twaver.network.ui.LinkBundleHandlerAttachment;

public class LinkUI
extends AbstractElementUI {
    private static final int B = 1000;
    private int C = 0;
    protected LinkStyleFactory styleFactory;
    protected boolean hollow;
    protected int extend;
    protected double proportion;
    protected int linkWidth;
    protected Color color;
    protected Color outlineColor;
    protected int outlineWidth;
    protected boolean fromArrow;
    protected boolean toArrow;
    protected boolean flowing;
    protected boolean is3d;
    protected boolean isFlowingConverse;
    protected boolean linkBlinking;
    protected Color blinkColor;
    protected Color flowingColor;
    protected int flowingWidth;
    protected boolean labelRotatable;
    protected boolean antialias;
    protected boolean bundleExpand;
    protected int bundleIndex;
    protected int bundleSize;
    protected int toPosition;
    protected int toXOffset;
    protected int toYOffset;
    protected int fromPosition;
    protected int fromXOffset;
    protected int fromYOffset;
    protected BorderUI defaultBorder = null;
    protected GeneralPath path = null;
    protected Point centerPoint = null;
    protected Shape shape = null;
    protected Shape containShape = null;
    protected Double linkAngle = null;
    private Link D = null;
    private twaver.base.A.D.B E = null;
    private static boolean F = false;

    public LinkUI(TNetwork network, Link link) {
        super(network, link);
        this.D = link;
        this.styleFactory = K.A(link.getLinkStyle());
        this.hollow = link.isLinkHollow();
        this.color = link.getLinkColor();
        this.outlineColor = link.getLinkOutlineColor();
        this.outlineWidth = link.getLinkOutlineWidth();
        this.linkWidth = link.getLinkWidth();
        this.flowingWidth = link.getLinkFlowingWidth();
        this.fromArrow = link.isLinkFromArrow();
        this.toArrow = link.isLinkToArrow();
        this.labelRotatable = link.isLinkLabelRotatable();
        this.antialias = link.isLinkAntialias();
        this.flowingColor = link.getLinkFlowingColor();
        this.bundleExpand = link.isLinkBundleExpand();
        this.bundleIndex = link.getLinkBundleIndex();
        this.bundleSize = link.getLinkBundleSize();
        this.is3d = link.isLink3D();
        this.linkBlinking = link.isLinkBlinking();
        this.blinkColor = link.getLinkBlinkingColor();
        this.flowing = link.isLinkFlowing();
        this.isFlowingConverse = link.isLinkFlowingConverse();
        this.toPosition = link.getLinkToPosition();
        this.toXOffset = link.getLinkToXOffset();
        this.toYOffset = link.getLinkToYOffset();
        this.fromPosition = link.getLinkFromPosition();
        this.fromXOffset = link.getLinkFromXOffset();
        this.fromYOffset = link.getLinkFromYOffset();
        this.extend = link.getLinkExtend();
        this.proportion = link.getLinkProportion();
    }

    public twaver.base.A.D.B getFlexionStruct() {
        if (this.E == null) {
            this.E = new twaver.base.A.D.B(this);
        }
        return this.E;
    }

    public void installAttachments() {
        super.installAttachments();
        this.attachments.add(new LinkBundleHandlerAttachment(this));
    }

    public Link getLink() {
        return (Link)this.element;
    }

    public Color getLinkColor() {
        if (this.linkBlinking) {
            if (twaver.base.A.D.A.B.B()) {
                return this.color;
            }
            return this.blinkColor;
        }
        return this.color;
    }

    public int getOutlineWidth() {
        return this.outlineWidth;
    }

    public Color getFlowingColor() {
        return this.flowingColor;
    }

    public void paintBody(Graphics2D g2d) {
        n.A(this.getShape(), g2d, this);
    }

    public void paint(Graphics2D g2d) {
        BorderUI border = this.getBorder();
        if (border != null && border.isUnderneath()) {
            this.paintBorder(g2d);
        }
        Object oldHinds = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        if (this.antialias) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        Composite oldComposite = null;
        if (this.renderAlpha != 1.0f) {
            oldComposite = g2d.getComposite();
            AlphaComposite composite = AlphaComposite.getInstance(3, this.renderAlpha);
            g2d.setComposite(composite);
        }
        this.paintBody(g2d);
        if (oldComposite != null) {
            g2d.setComposite(oldComposite);
        }
        if (border != null && !border.isUnderneath()) {
            this.paintBorder(g2d);
        }
        this.paintArrows(g2d);
        this.paintAttachments(g2d);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHinds);
    }

    protected void paintArrows(Graphics2D g2d) {
        Color color;
        Shape shape = this.getFromArrow();
        if (shape != null) {
            color = this.D.getLinkFromArrowColor();
            g2d.setColor(color);
            g2d.fill(shape);
            if (this.D.isLinkFromArrowOutline()) {
                g2d.setStroke(TWaverConst.BASIC_STROKE);
                g2d.setColor(this.D.getLinkFromArrowOutlineColor());
                g2d.draw(shape);
            }
        }
        if ((shape = this.getToArrow()) != null) {
            color = this.D.getLinkToArrowColor();
            g2d.setColor(color);
            g2d.fill(shape);
            if (this.D.isLinkToArrowOutline()) {
                g2d.setStroke(TWaverConst.BASIC_STROKE);
                g2d.setColor(this.D.getLinkToArrowOutlineColor());
                g2d.draw(shape);
            }
        }
    }

    public Shape getFromArrow() {
        if (!this.fromArrow) {
            return null;
        }
        return S.B(this.D, this.getPath(), this.getFromAgentBounds());
    }

    public Shape getToArrow() {
        if (!this.toArrow) {
            return null;
        }
        return S.A(this.D, this.getPath(), this.getToAgentBounds());
    }

    public Point getFromAnchorPoint(int xOffset, int yOffset) {
        Shape shape = S.A(false, this.getPath(), this.getFromAgentBounds(), this.D.getFromAgent(), 8, xOffset, yOffset);
        if (shape == null) {
            Point point = this.getFromPoint();
            point.x += xOffset;
            point.y += yOffset;
            return point;
        }
        return new Point((int)shape.getBounds().getCenterX(), (int)shape.getBounds().getCenterY());
    }

    public Point getToAnchorPoint(int xOffset, int yOffset) {
        Shape shape = S.B(false, this.getPath(), this.getToAgentBounds(), this.D.getToAgent(), 8, xOffset, yOffset);
        if (shape == null) {
            Point point = this.getToPoint();
            point.x += xOffset;
            point.y += yOffset;
            return point;
        }
        return new Point((int)shape.getBounds().getCenterX(), (int)shape.getBounds().getCenterY());
    }

    public int getLinkWidth() {
        return this.linkWidth;
    }

    public Stroke getStroke() {
        return this.styleFactory.createStroke(this.linkWidth);
    }

    public Shape getShape() {
        if (this.shape == null) {
            GeneralPath path = this.getPath();
            int linkWidth = this.getLinkWidth();
            if (linkWidth <= 1) {
                this.shape = path;
            } else {
                Stroke stroke = this.getStroke();
                this.shape = new Area(stroke.createStrokedShape(path));
            }
        }
        return this.shape;
    }

    public GeneralPath getPath() {
        if (this.path == null) {
            this.path = this.network.getLinkLayouter().getLinkPath(this);
        }
        return this.path;
    }

    public void invalidateShape() {
        if (this.network.isFrozeLinkShape() || this.D.isShapeFrozen()) {
            return;
        }
        this.setPath(null);
    }

    public void setPath(GeneralPath path) {
        this.path = path;
        this.shape = null;
        this.linkAngle = null;
        this.centerPoint = null;
        this.containShape = null;
        this.E = null;
        this.D.firePropertyChange("linkUIPath", false, true);
    }

    public Point getHotspot() {
        return this.getCenterPoint();
    }

    public Point getCenterPoint() {
        if (this.centerPoint == null) {
            GeneralPath path = this.getPath();
            this.centerPoint = L.A(path);
        }
        return (Point)this.centerPoint.clone();
    }

    public boolean contains(int x, int y) {
        if (this.getContainShape().contains(x, y)) {
            return true;
        }
        Shape shape = this.getFromArrow();
        if (shape != null && shape.contains(x, y)) {
            return true;
        }
        shape = this.getToArrow();
        if (shape != null && shape.contains(x, y)) {
            return true;
        }
        return this.containInAttachments(x, y);
    }

    public Shape getContainShape() {
        if (this.containShape == null) {
            int width = this.linkWidth + this.outlineWidth;
            if (width < 3) {
                width = 3;
            }
            Stroke stroke = d.A(width + 1, this.getStroke());
            this.containShape = new Area(stroke.createStrokedShape(this.getPath()));
        }
        return this.containShape;
    }

    public Rectangle getUIBounds() {
        Rectangle rect = this.getContainShape().getBounds();
        rect.grow(5, 5);
        Iterator it = this.attachments();
        while (it.hasNext()) {
            Attachment attachment = (Attachment)it.next();
            Rectangle attchmentBounds = attachment.getBounds();
            if (attchmentBounds == null) continue;
            rect.add(attchmentBounds);
        }
        Shape shape = this.getFromArrow();
        if (shape != null) {
            rect.add(shape.getBounds());
        }
        if ((shape = this.getToArrow()) != null) {
            rect.add(shape.getBounds());
        }
        return rect;
    }

    public Rectangle getFromAgentBounds() {
        Node agent = this.getLink().getFromAgent();
        if (agent == null) {
            return null;
        }
        if (W.C(agent)) {
            GroupUI groupUI = (GroupUI)this.network.getElementUI(agent);
            return groupUI.getShape().getBounds();
        }
        return agent.getBounds();
    }

    public Rectangle getToAgentBounds() {
        Node agent = this.getLink().getToAgent();
        if (agent == null) {
            return null;
        }
        if (W.C(agent)) {
            GroupUI groupUI = (GroupUI)this.network.getElementUI(agent);
            return groupUI.getShape().getBounds();
        }
        return agent.getBounds();
    }

    public Point getFromPoint() {
        Node fromAgent = this.D.getFromAgent();
        if (fromAgent instanceof ShapeNode && !F) {
            Shape shape;
            ShapeNode node = (ShapeNode)fromAgent;
            int type = node.getShapeNodeType();
            Point result = null;
            if (type == 7) {
                F = true;
                Point to = this.getToPoint();
                F = false;
                result = Y.A(node, to, node.getShapeNodeJointPoint());
            } else if ((type == 9 || type == 8) && (shape = node.getShape()) instanceof Ellipse2D) {
                F = true;
                Point toPoint = this.getToPoint();
                F = false;
                result = twaver.base.A.E.D.A((Ellipse2D)shape, toPoint);
            }
            if (result != null) {
                result.x += this.fromXOffset;
                result.y += this.fromYOffset;
                return result;
            }
        }
        if (this.D.getLinkType() == 2) {
            return (Point)this.getFlexionStruct().F.clone();
        }
        return N.A(this.network.getElementUI(fromAgent), TWaverConst.EMPTY_DIMENSION, this.fromPosition, this.fromXOffset, this.fromYOffset);
    }

    public Point getToPoint() {
        Node toAgent = this.D.getToAgent();
        if (toAgent instanceof ShapeNode && !F) {
            Shape shape;
            ShapeNode node = (ShapeNode)toAgent;
            int type = node.getShapeNodeType();
            Point result = null;
            if (type == 7) {
                F = true;
                Point from = this.getFromPoint();
                F = false;
                result = Y.A(node, from, node.getShapeNodeJointPoint());
            } else if ((type == 9 || type == 8) && (shape = node.getShape()) instanceof Ellipse2D) {
                F = true;
                Point fromPoint = this.getFromPoint();
                F = false;
                result = twaver.base.A.E.D.A((Ellipse2D)shape, fromPoint);
            }
            if (result != null) {
                result.x += this.toXOffset;
                result.y += this.toYOffset;
                return result;
            }
        }
        if (this.D.getLinkType() == 2) {
            return (Point)this.getFlexionStruct().E.clone();
        }
        return N.A(this.network.getElementUI(toAgent), TWaverConst.EMPTY_DIMENSION, this.toPosition, this.toXOffset, this.toYOffset);
    }

    public Point getFromInflexion() {
        return (Point)this.getFlexionStruct().B.clone();
    }

    public Point getToInflexion() {
        return (Point)this.getFlexionStruct().D.clone();
    }

    public Point getOrthogonalPoint() {
        Point fromPoint = this.getFromPoint();
        Point toPoint = this.getToPoint();
        if (OrthogonalLinkDirectionType.X_TO_Y.equals(this.D.getLinkOrthogonalDirection())) {
            return new Point(fromPoint.x, toPoint.y);
        }
        return new Point(toPoint.x, fromPoint.y);
    }

    public BorderUI getBorder() {
        if (this.defaultBorder == null) {
            this.defaultBorder = new LinkBorderUI(this);
        }
        return this.defaultBorder;
    }

    public void performAction(int gesture, MouseEvent e2) {
        if (gesture != 2) {
            return;
        }
        if (this.element instanceof TSubNetwork) {
            if (e2.isControlDown()) {
                this.reverseExpand();
            } else {
                this.network.loadAndEnterSubNetwork((TSubNetwork)this.element);
            }
        } else {
            this.reverseExpand();
        }
    }

    public void reverseExpand() {
        TDataBox box = this.network.getDataBox();
        VisibleFilter filter = box.getLinkBundleFilter();
        if (filter != null && !filter.isVisible(this.element)) {
            return;
        }
        box.reverseBundleExpand(this.D);
        this.network.adjustCanvasSize();
    }

    public boolean isBundleAgent() {
        return !this.bundleExpand && this.bundleSize > 1 && this.bundleIndex == 0;
    }

    public double getAngle() {
        if (this.linkAngle == null) {
            if (this.D.getLinkType() == 2) {
                Point fromPoint = this.getFromInflexion();
                Point toPoint = this.getToInflexion();
                this.linkAngle = new Double(twaver.base.A.E.D.B(fromPoint, toPoint));
            } else if (this.D.getLinkType() == 3) {
                Point fromPoint = this.getFromPoint();
                Point toPoint = this.getToPoint();
                double multiple = twaver.base.A.E.D.B(fromPoint, toPoint) / 1.5707963267948966;
                this.linkAngle = new Double((double)Math.round(multiple) * 1.5707963267948966);
            } else {
                Point fromPoint = this.getFromPoint();
                Point toPoint = this.getToPoint();
                this.linkAngle = new Double(twaver.base.A.E.D.B(fromPoint, toPoint));
            }
        }
        return this.linkAngle;
    }

    public void flowForward() {
        this.C = this.isFlowingConverse ? (this.C + this.linkWidth >= 1000 ? 0 : (this.C += this.linkWidth)) : (this.C - this.linkWidth <= 0 ? 1000 : (this.C -= this.linkWidth));
    }

    public void updateClientProperty(String propertyName) {
        if (!propertyName.startsWith("link.")) {
            super.updateClientProperty(propertyName);
            return;
        }
        if (propertyName.equals("link.color")) {
            this.color = this.D.getLinkColor();
        } else if (propertyName.equals("link.hollow")) {
            this.hollow = this.D.isLinkHollow();
        } else if (propertyName.equals("link.outline.color")) {
            this.outlineColor = this.D.getLinkOutlineColor();
        } else if (propertyName.equals("link.outline.width")) {
            this.outlineWidth = this.D.getLinkOutlineWidth();
        } else if (propertyName.equals("link.width")) {
            this.linkWidth = this.D.getLinkWidth();
        } else if (propertyName.equals("link.flowing.width")) {
            this.flowingWidth = this.D.getLinkFlowingWidth();
        } else if (propertyName.equals("link.fromArrow")) {
            this.fromArrow = this.D.isLinkFromArrow();
        } else if (propertyName.equals("link.toArrow")) {
            this.toArrow = this.D.isLinkToArrow();
        } else if (propertyName.equals("link.flowing")) {
            this.flowing = this.D.isLinkFlowing();
        } else if (propertyName.equals("link.flowing.converse")) {
            this.isFlowingConverse = this.D.isLinkFlowingConverse();
        } else if (propertyName.equals("link.blinking")) {
            this.linkBlinking = this.D.isLinkBlinking();
        } else if (propertyName.equals("link.label.rotatable")) {
            this.labelRotatable = this.D.isLinkLabelRotatable();
        } else if (propertyName.equals("link.antialias")) {
            this.antialias = this.D.isLinkAntialias();
        } else if (propertyName.equals("link.flowing.color")) {
            this.flowingColor = this.D.getLinkFlowingColor();
        } else if (propertyName.equals("link.bundle.expand")) {
            this.bundleExpand = this.D.isLinkBundleExpand();
        } else if (propertyName.equals("link.bundle.index")) {
            this.bundleIndex = this.D.getLinkBundleIndex();
        } else if (propertyName.equals("link.bundle.size")) {
            this.bundleSize = this.D.getLinkBundleSize();
        } else if (propertyName.equals("link.3d")) {
            this.is3d = this.D.isLink3D();
        } else if (propertyName.equals("link.style")) {
            this.styleFactory = K.A(this.D.getLinkStyle());
        } else if (propertyName.equals("link.blinking.color")) {
            this.blinkColor = this.D.getLinkBlinkingColor();
        } else if (propertyName.equals("link.from.position")) {
            this.fromPosition = this.D.getLinkFromPosition();
        } else if (propertyName.equals("link.from.xoffset")) {
            this.fromXOffset = this.D.getLinkFromXOffset();
        } else if (propertyName.equals("link.from.yoffset")) {
            this.fromYOffset = this.D.getLinkFromYOffset();
        } else if (propertyName.equals("link.to.position")) {
            this.toPosition = this.D.getLinkToPosition();
        } else if (propertyName.equals("link.to.xoffset")) {
            this.toXOffset = this.D.getLinkToXOffset();
        } else if (propertyName.equals("link.to.yoffset")) {
            this.toYOffset = this.D.getLinkToYOffset();
        } else if (propertyName.equals("link.extend")) {
            this.extend = this.D.getLinkExtend();
        } else if (propertyName.equals("link.proportion")) {
            this.proportion = this.D.getLinkProportion();
        }
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public boolean isLabelRotatable() {
        return this.labelRotatable;
    }

    public int getBundleSize() {
        return this.bundleSize;
    }

    public boolean isToArrow() {
        return this.toArrow;
    }

    public boolean isFromArrow() {
        return this.fromArrow;
    }

    public boolean isFlowing() {
        return this.flowing;
    }

    public boolean isFlowingConverse() {
        return this.isFlowingConverse;
    }

    public boolean isLinkBlinking() {
        return this.linkBlinking;
    }

    public int getFlowingWidth() {
        return this.flowingWidth;
    }

    public int getBundleIndex() {
        return this.bundleIndex;
    }

    public boolean isBundleExpand() {
        return this.bundleExpand;
    }

    public boolean isHollow() {
        return this.hollow;
    }

    public int getDashPhase() {
        return this.C;
    }

    public boolean is3D() {
        return this.is3d;
    }

    public int getFromPosition() {
        return this.fromPosition;
    }

    public int getFromXOffset() {
        return this.fromXOffset;
    }

    public int getFromYOffset() {
        return this.fromYOffset;
    }

    public int getToPosition() {
        return this.toPosition;
    }

    public int getToXOffset() {
        return this.toXOffset;
    }

    public int getToYOffset() {
        return this.toYOffset;
    }

    public int getExtend() {
        return this.extend;
    }

    public double getProportion() {
        return this.proportion;
    }
}

