/*
 * Decompiled with CFR 0.152.
 */
package twaver.network.ui;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import twaver.BaseElement;
import twaver.TWaverConst;
import twaver.base.A.D.K;
import twaver.base.A.D.O;
import twaver.base.A.E.b;
import twaver.network.TNetwork;
import twaver.network.ui.AbstractElementUI;
import twaver.network.ui.BorderUI;
import twaver.network.ui.DefaultBorderUI;

public class BaseElementUI
extends AbstractElementUI {
    protected BorderUI defaultBorder = null;
    protected Color color;
    protected boolean bodyFill;
    protected boolean bodyRaised;
    protected boolean customDraw;
    protected boolean customDrawDefaultBorder;
    protected boolean customDrawAntialias;
    protected boolean customDrawFill;
    protected boolean customDrawFill3D;
    protected Color customDrawFillColor;
    protected boolean customDrawOutline;
    protected boolean customDrawOutline3D;
    protected Color customDrawOutlineColor;
    protected Stroke customDrawOutlineStroke;
    protected boolean customDrawGradient;
    protected Color customDrawGradientColor;
    protected O gradientFactory;
    protected K shapeFactory;

    public BaseElementUI(TNetwork network, BaseElement element) {
        super(network, element);
        this.color = b.P(element, "body.color");
        this.bodyFill = b.K(element, "body.fill");
        this.bodyRaised = b.K(element, "body.raised");
        this.customDraw = b.K(element, "custom.draw");
        this.customDrawDefaultBorder = b.K(element, "custom.draw.default.border");
        this.customDrawAntialias = b.K(element, "custom.draw.antialias");
        this.customDrawFill = b.K(element, "custom.draw.fill");
        this.customDrawFill3D = b.K(element, "custom.draw.fill.3d");
        this.customDrawFillColor = b.P(element, "custom.draw.fill.color");
        this.customDrawOutline = b.K(element, "custom.draw.outline");
        this.customDrawOutline3D = b.K(element, "custom.draw.outline.3d");
        this.customDrawOutlineColor = b.P(element, "custom.draw.outline.color");
        this.customDrawOutlineStroke = b.F(element, "custom.draw.outline.stroke");
        this.customDrawGradient = b.K(element, "custom.draw.gradient");
        this.customDrawGradientColor = b.P(element, "custom.draw.gradient.color");
        this.shapeFactory = b.H(element, "custom.draw.shape.factory");
        this.gradientFactory = b.I(element, "custom.draw.gradient.factory");
    }

    public BaseElement getBaseElement() {
        return (BaseElement)this.element;
    }

    public BorderUI getBorder() {
        if (this.defaultBorder == null) {
            this.defaultBorder = new DefaultBorderUI(this);
        }
        return this.defaultBorder;
    }

    public Rectangle getUIBounds() {
        Rectangle bounds;
        Rectangle borderRect;
        BorderUI borderUI;
        Rectangle result = this.element.getBounds();
        if (result != null && this.customDraw && this.customDrawOutline && this.customDrawOutlineStroke instanceof BasicStroke) {
            int w = (int)((BasicStroke)this.customDrawOutlineStroke).getLineWidth() / 2 + 1;
            result.grow(w, w);
        }
        if ((borderUI = this.getBorder()) != null && (borderRect = borderUI.getBounds()) != null) {
            result.add(borderRect);
        }
        if ((bounds = this.getAttachementsBounds()) != null) {
            result.add(bounds);
        }
        return result;
    }

    public void paint(Graphics2D g2d) {
        BorderUI border = this.getBorder();
        if (border != null && border.isUnderneath()) {
            this.paintBorder(g2d);
        }
        Composite oldComposite = null;
        if (this.renderAlpha != 1.0f) {
            oldComposite = g2d.getComposite();
            AlphaComposite composite = AlphaComposite.getInstance(3, this.renderAlpha);
            g2d.setComposite(composite);
        }
        if (this.isCustomDraw()) {
            this.paintCustomDraw(g2d);
        } else {
            this.paintBody(g2d);
            this.paintStateOutline(g2d);
        }
        if (oldComposite != null) {
            g2d.setComposite(oldComposite);
        }
        if (border != null && !border.isUnderneath()) {
            this.paintBorder(g2d);
        }
        this.paintAttachments(g2d);
    }

    protected void paintCustomDraw(Graphics2D g2d) {
        Object oldHinds = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        if (this.customDrawAntialias) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        Shape bodyShape = this.shapeFactory.D(this, this.element.getBounds());
        Color stateOutlineColor = this.getStateOutlineColor();
        this.paintCustomDrawBody(g2d, bodyShape);
        this.paintCustomDrawOutline(g2d, bodyShape);
        this.paintCustomDrawStateOutline(g2d, bodyShape, stateOutlineColor);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHinds);
    }

    protected void paintCustomDrawStateOutline(Graphics2D g2d, Shape bodyShape, Color stateOutlineColor) {
        if (stateOutlineColor != null) {
            this.setStateOutline(g2d, stateOutlineColor);
            Rectangle bounds = this.element.getBounds();
            bounds.x -= this.stateOutlineInsets;
            bounds.y -= this.stateOutlineInsets;
            bounds.width += this.stateOutlineInsets * 2;
            bounds.height += this.stateOutlineInsets * 2;
            g2d.draw(this.shapeFactory.A(this, bounds));
        }
    }

    protected void paintCustomDrawOutline(Graphics2D g2d, Shape bodyShape) {
        if (this.customDrawOutline) {
            g2d.setStroke(this.customDrawOutlineStroke);
            Color color = this.getPaintBodyColor(this.customDrawOutlineColor);
            if (this.customDrawOutline3D) {
                AffineTransform at1 = AffineTransform.getTranslateInstance(-1.0, -1.0);
                AffineTransform at2 = AffineTransform.getTranslateInstance(1.0, 1.0);
                Shape shape1 = at1.createTransformedShape(bodyShape);
                Shape shape2 = at2.createTransformedShape(bodyShape);
                g2d.setColor(color.brighter().brighter());
                g2d.draw(shape1);
                g2d.setColor(color.darker().darker());
                g2d.draw(shape2);
            }
            g2d.setColor(color);
            g2d.draw(bodyShape);
        }
    }

    protected void paintCustomDrawBody(Graphics2D g2d, Shape bodyShape) {
        if (this.customDrawFill) {
            if (this.customDrawFill3D) {
                AffineTransform at1 = AffineTransform.getTranslateInstance(-1.0, -1.0);
                AffineTransform at2 = AffineTransform.getTranslateInstance(1.0, 1.0);
                Shape shape1 = at1.createTransformedShape(bodyShape);
                Shape shape2 = at2.createTransformedShape(bodyShape);
                this.A(g2d, this.customDrawFillColor.brighter().brighter(), shape1);
                this.A(g2d, this.customDrawFillColor.darker().darker(), shape2);
            }
            this.A(g2d, this.customDrawFillColor, bodyShape);
            if (!this.customDrawOutline && (this.element.isSelected() || this.getStateOutlineColor() != null)) {
                g2d.setStroke(TWaverConst.BASIC_STROKE);
                g2d.draw(bodyShape);
            }
        }
    }

    private void A(Graphics2D g2d, Color fillColor, Shape shape) {
        Color color = this.getPaintBodyColor(fillColor);
        if (this.customDrawGradient) {
            Paint paint = this.gradientFactory.A(this.element.getBounds(), this.customDrawGradientColor, color);
            g2d.setPaint(paint);
        } else {
            this.setBodyPaint(g2d, color);
        }
        g2d.fill(shape);
    }

    public void paintBody(Graphics2D g2d) {
        Color elementBodyColor = this.getPaintBodyColor(this.color);
        if (elementBodyColor != null) {
            g2d.setStroke(TWaverConst.DOUBLE_WIDTH_STROKE);
            Rectangle bounds = this.element.getBounds();
            if (this.bodyFill) {
                this.setBodyPaint(g2d, elementBodyColor);
                g2d.fillRect(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
            }
            g2d.setColor(elementBodyColor);
            g2d.draw3DRect(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1, this.bodyRaised);
        }
    }

    public void paintStateOutline(Graphics2D g2d) {
        Color stateOutlineColor = this.getStateOutlineColor();
        if (stateOutlineColor != null) {
            Object oldHinds = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.setStateOutline(g2d, stateOutlineColor);
            Rectangle rect = this.element.getBounds();
            rect.grow(this.stateOutlineInsets, this.stateOutlineInsets);
            --rect.width;
            --rect.height;
            g2d.draw(rect);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHinds);
        }
    }

    public Point getHotspot() {
        Point hotspot;
        if (this.isCustomDraw() && (hotspot = this.shapeFactory.B(this, this.element.getBounds())) != null) {
            return hotspot;
        }
        Rectangle bounds = this.element.getBounds();
        Point hotSpot = new Point(bounds.x + bounds.width, bounds.y);
        if (bounds.width > 3) {
            hotSpot.x -= 3;
        }
        if (bounds.height > 3) {
            hotSpot.y += 3;
        }
        return hotSpot;
    }

    public void updateClientProperty(String propertyName) {
        if (propertyName.equals("body.color")) {
            this.color = b.P(this.element, "body.color");
        } else if (propertyName.equals("body.raised")) {
            this.bodyRaised = b.K(this.element, "body.raised");
        } else if (propertyName.equals("body.fill")) {
            this.bodyFill = b.K(this.element, "body.fill");
        } else if (propertyName.equals("custom.draw")) {
            this.customDraw = b.K(this.element, "custom.draw");
        } else if (propertyName.equals("custom.draw.default.border")) {
            this.customDrawDefaultBorder = b.K(this.element, "custom.draw.default.border");
        } else if (propertyName.equals("custom.draw.antialias")) {
            this.customDrawAntialias = b.K(this.element, "custom.draw.antialias");
        } else if (propertyName.equals("custom.draw.fill")) {
            this.customDrawFill = b.K(this.element, "custom.draw.fill");
        } else if (propertyName.equals("custom.draw.fill.3d")) {
            this.customDrawFill3D = b.K(this.element, "custom.draw.fill.3d");
        } else if (propertyName.equals("custom.draw.fill.color")) {
            this.customDrawFillColor = b.P(this.element, "custom.draw.fill.color");
        } else if (propertyName.equals("custom.draw.outline")) {
            this.customDrawOutline = b.K(this.element, "custom.draw.outline");
        } else if (propertyName.equals("custom.draw.outline.3d")) {
            this.customDrawOutline3D = b.K(this.element, "custom.draw.outline.3d");
        } else if (propertyName.equals("custom.draw.outline.color")) {
            this.customDrawOutlineColor = b.P(this.element, "custom.draw.outline.color");
        } else if (propertyName.equals("custom.draw.outline.stroke")) {
            this.customDrawOutlineStroke = b.F(this.element, "custom.draw.outline.stroke");
        } else if (propertyName.equals("custom.draw.gradient")) {
            this.customDrawGradient = b.K(this.element, "custom.draw.gradient");
        } else if (propertyName.equals("custom.draw.gradient.color")) {
            this.customDrawGradientColor = b.P(this.element, "custom.draw.gradient.color");
        } else if (propertyName.equals("custom.draw.shape.factory")) {
            this.shapeFactory = b.H(this.element, "custom.draw.shape.factory");
        } else if (propertyName.equals("custom.draw.gradient.factory")) {
            this.gradientFactory = b.I(this.element, "custom.draw.gradient.factory");
        } else {
            super.updateClientProperty(propertyName);
        }
    }

    public Color getColor() {
        return this.color;
    }

    public boolean isBodyFill() {
        return this.bodyFill;
    }

    public boolean contains(int x, int y) {
        Shape shape;
        if (this.isCustomDraw() ? (shape = this.shapeFactory.D(this, this.element.getBounds())).contains(x, y) : this.element.getBounds().contains(x, y)) {
            return true;
        }
        return this.containInAttachments(x, y);
    }

    protected K getShapeFactory() {
        return this.shapeFactory;
    }

    protected boolean isCustomDraw() {
        return this.customDraw;
    }

    public boolean isCustomDrawDefaultBorder() {
        return this.customDrawDefaultBorder;
    }
}

