/*
 * Decompiled with CFR 0.152.
 */
package twaver.network.ui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import twaver.BTSAntenna;
import twaver.TWaverConst;
import twaver.network.TNetwork;
import twaver.network.ui.BaseEquipmentUI;
import twaver.network.ui.BorderUI;
import twaver.network.ui.DefaultBorderUI;

public class BTSAntennaUI
extends BaseEquipmentUI {
    private BTSAntenna e = null;

    public BTSAntennaUI(TNetwork network, BTSAntenna antenna) {
        super(network, antenna);
        this.e = antenna;
    }

    public Point getHotspot() {
        return this.e.getHotspot();
    }

    public void paintBody(Graphics2D g2) {
        Object oldHinds = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Stroke oldStroke = g2.getStroke();
        Composite oldComposite = null;
        if (this.e.getBeamAlpha() != 1.0f) {
            oldComposite = g2.getComposite();
            AlphaComposite composite = AlphaComposite.getInstance(3, this.e.getBeamAlpha());
            g2.setComposite(composite);
        }
        this.setBodyPaint(g2, this.getPaintBodyColor(this.color));
        g2.fill(this.e.getAntennaShape());
        if (this.e.isBTSAntennaOutlineShow()) {
            g2.setStroke(this.e.getBTSAntennaOutlineStroke());
            g2.setColor(this.e.getBTSAntennaOutlineColor());
            g2.draw(this.e.getAntennaShape());
        }
        if (this.e.isBTSAntennaArrowShow()) {
            g2.setStroke(TWaverConst.BASIC_STROKE);
            g2.setColor(this.e.getBTSAntennaArrowColor());
            g2.fill(this.e.getArrowShape());
            g2.draw(this.e.getArrowShape());
        }
        g2.setStroke(oldStroke);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHinds);
        if (oldComposite != null) {
            g2.setComposite(oldComposite);
        }
    }

    public void paintStateOutline(Graphics2D g2d) {
        Color stateOutlineColor = this.getStateOutlineColor();
        if (stateOutlineColor != null) {
            g2d.setColor(stateOutlineColor);
            g2d.setStroke(TWaverConst.DOUBLE_WIDTH_STROKE);
            g2d.draw(this.e.getAntennaShape());
        }
    }

    public boolean contains(int x, int y) {
        if (this.e.getAntennaShape().contains(x, y)) {
            return true;
        }
        return this.containInAttachments(x, y);
    }

    public BorderUI getBorder() {
        if (this.defaultBorder == null) {
            this.defaultBorder = new DefaultBorderUI(this);
        }
        return this.defaultBorder;
    }

    public Shape getBorderShape() {
        return this.e.getAntennaShape();
    }
}

