/*
 * Decompiled with CFR 0.152.
 */
package twaver.chart;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import twaver.TDataBox;
import twaver.TUIManager;
import twaver.chart.AbstractChart;
import twaver.chart.Marker;
import twaver.web.svg.chart.AbstractSVGChart;
import twaver.web.svg.chart.AbstractSVGXYScaleChart;

public abstract class AbstractXYScaleChart
extends AbstractChart {
    private boolean \u04ab = TUIManager.getBoolean("tchart.xaxis.visible");
    private Color \u04e2 = TUIManager.getColor("tchart.xaxis.fill.color");
    private Color \u04ba = TUIManager.getColor("tchart.xaxis.outline.color");
    private String \u04cc = TUIManager.getString("tchart.xaxis.stroke");
    private String \u04d4 = TUIManager.getString("tchart.xaxis.text");
    private Font \u04ad = TUIManager.getFont("tchart.xaxis.text.font");
    private Color \u04d6 = TUIManager.getColor("tchart.xaxis.text.color");
    private double \u04cb = TUIManager.getDouble("tchart.xaxis.start.position");
    private String \u04e5 = TUIManager.getString("tchart.xaxis.unit");
    private boolean \u04b6 = TUIManager.getBoolean("tchart.xaxis.unit.visible");
    private Color \u04dc = TUIManager.getColor("tchart.xaxis.unit.color");
    private Font \u04c1 = TUIManager.getFont("tchart.xaxis.unit.font");
    private boolean \u04d1 = TUIManager.getBoolean("tchart.yaxis.visible");
    private Color \u04c7 = TUIManager.getColor("tchart.yaxis.fill.color");
    private Color \u04ac = TUIManager.getColor("tchart.yaxis.outline.color");
    private String \u04a7 = TUIManager.getString("tchart.yaxis.stroke");
    private String \u04aa = TUIManager.getString("tchart.yaxis.text");
    private Font \u04e1 = TUIManager.getFont("tchart.yaxis.text.font");
    private Color \u04bb = TUIManager.getColor("tchart.yaxis.text.color");
    private double \u04a6 = TUIManager.getDouble("tchart.yaxis.start.position");
    private String \u04b7 = TUIManager.getString("tchart.yaxis.unit");
    private boolean \u04b4 = TUIManager.getBoolean("tchart.yaxis.unit.visible");
    private Color \u04c2 = TUIManager.getColor("tchart.yaxis.unit.color");
    private Font \u04af = TUIManager.getFont("tchart.yaxis.text.font");
    private boolean \u04a8 = TUIManager.getBoolean("tchart.xscale.text.visible");
    private boolean \u04ee = TUIManager.getBoolean("tchart.xscale.text.ontop");
    private NumberFormat \u04de = TUIManager.getNumberFormat("tchart.xscale.text.format");
    private Color \u04e3 = TUIManager.getColor("tchart.xscale.text.color");
    private Font \u04d3 = TUIManager.getFont("tchart.xscale.text.font");
    private String \u04ef = TUIManager.getString("tchart.xscale.line.stroke");
    private Color \u04a9 = TUIManager.getColor("tchart.xscale.line.color");
    private boolean \u04e7 = TUIManager.getBoolean("tchart.xscale.line.visible");
    private int \u04dd = TUIManager.getInt("tchart.xscale.text.orientation");
    private double \u04ea = TUIManager.getDouble("tchart.xscale.value.gap");
    private double \u04eb = TUIManager.getDouble("tchart.xscale.pixel.gap");
    private double \u04bf = TUIManager.getDouble("tchart.xscale.min.value");
    private double \u04d0 = TUIManager.getDouble("tchart.xscale.max.value");
    private boolean \u04e0 = TUIManager.getBoolean("tchart.yscale.text.visible");
    private boolean \u04d2 = TUIManager.getBoolean("tchart.yscale.text.inside");
    private NumberFormat \u04db = TUIManager.getNumberFormat("tchart.yscale.text.format");
    private Color \u04c4 = TUIManager.getColor("tchart.yscale.text.color");
    private Font \u04bc = TUIManager.getFont("tchart.yscale.text.font");
    private String \u04e9 = TUIManager.getString("tchart.yscale.line.stroke");
    private Color \u04d5 = TUIManager.getColor("tchart.yscale.line.color");
    private boolean \u04da = TUIManager.getBoolean("tchart.yscale.line.visible");
    private int \u04d9 = TUIManager.getInt("tchart.yscale.pixel.gap");
    private double \u04d7 = TUIManager.getDouble("tchart.yscale.value.gap");
    private double \u04b0 = TUIManager.getDouble("tchart.yscale.min.value");
    private double \u04b9 = TUIManager.getDouble("tchart.yscale.max.value");
    private boolean \u04df = TUIManager.getBoolean("tchart.yscale.value.gap.auto.calculate");
    private Rectangle2D.Double \u04b1 = new Rectangle2D.Double();
    private List \u04be = new ArrayList();
    private List \u04b8 = new ArrayList();
    private double \u04b5;
    private double \u04bd;
    private double \u04c3;
    private List \u04ae = null;
    private double \u04b3 = 0.0;
    private double \u04e6 = 0.0;
    private double \u04b2;
    private double \u04e8;
    private double \u04c8 = 0.0;
    private double \u04d8 = -1.7976931348623157E308;
    private double \u04c0 = 0.0;
    private double \u04e4 = 0.0;
    protected List markers = null;

    public AbstractXYScaleChart() {
    }

    public AbstractXYScaleChart(TDataBox box) {
        super(box);
    }

    public AbstractXYScaleChart(TDataBox box, String title, Color backgroundColor) {
        super(box, title, backgroundColor);
    }

    public AbstractXYScaleChart(TDataBox box, String title, Color backgroundColor, Color foregroundColor) {
        super(box, title, backgroundColor, foregroundColor);
    }

    public AbstractXYScaleChart(List elements) {
        super(elements);
    }

    public AbstractXYScaleChart(List elements, String title) {
        super(elements, title);
    }

    public AbstractXYScaleChart(List elements, String title, Color backgroundColor) {
        super(elements, title, backgroundColor);
    }

    public AbstractXYScaleChart(List elements, String title, Color backgroundColor, Color foregroundColor) {
        super(elements, title, backgroundColor, foregroundColor);
    }

    protected void calculate() {
        this.calculateYAxisRange();
        this.calculateYScaleValueGap();
    }

    protected void calculateYAxisRange() {
        this.max = this.\u04b9;
        this.min = this.\u04b0;
        this.range = Math.max(this.max - this.min, 1.0);
    }

    protected void calculateYScaleValueGap() {
        this.\u04d8 = -1.7976931348623157E308;
        if (this.\u04d7 <= 0.0 && this.\u04d9 <= 0) {
            this.\u04d8 = this.D(this.range);
            return;
        }
        if (this.\u04df) {
            this.\u04d8 = this.D(this.range);
        }
    }

    private double D(double range) {
        double gap = 0.0;
        double segment = 15.0;
        if (range <= 0.0) {
            return gap;
        }
        if (range < segment) {
            double rangeTemp;
            int ten = 10;
            if (range < 1.0) {
                String[] str = (range + "").split("\\.");
                String after = str[1];
                int length = after.length();
                for (int i2 = 0; i2 < length && "0".equals(after.substring(i2, i2 + 1)); ++i2) {
                    ten *= 10;
                }
            } else {
                ten = 1;
            }
            if ((rangeTemp = (double)ten * range) >= 4.0) {
                gap = 1.0 / (double)ten;
            } else if (rangeTemp >= segment / 10.0) {
                gap = 0.5 / (double)ten;
            } else if (rangeTemp < segment / 10.0) {
                gap = 0.1 / (double)ten;
            }
        }
        if (range < 25.0 && range >= segment) {
            gap = 5.0;
        }
        if (range >= 25.0) {
            int length = ((int)range + "").trim().length();
            int ten = 1;
            for (int i3 = 0; i3 < length - 1; ++i3) {
                ten *= 10;
            }
            gap = ten;
            double divisor = range / gap;
            if (divisor < 4.0 && (divisor = range / (gap = (double)(ten / 2))) < 4.0 && (divisor = range / (gap = (double)(ten / 5))) < 4.0) {
                gap = ten / 10;
            }
        }
        return gap;
    }

    protected void calculateXScaleTextHeight() {
        String text = this.getFormatedXScaleText(this.\u04d0);
        Dimension dim = this.B(this.\u04dd, text, this.\u04d3);
        this.\u04b3 = dim.getHeight();
        this.\u04e6 = this.B((int)this.\u04dd, (String)this.getFormatedXScaleText((double)this.\u04bf), (Font)this.\u04d3).width;
        if (this.\u04be != null && this.\u04be.contains(new Integer(0))) {
            this.\u04e6 = 0.0;
            return;
        }
        if (!this.\u04ab || !this.\u04a8) {
            this.\u04b3 = 0.0;
            this.\u04e6 = 0.0;
            return;
        }
        if (this.\u04ae != null && this.\u04ae.size() > 0) {
            this.\u04b3 = 0.0;
            this.\u04e6 = 0.0;
            int size = this.\u04ae.size();
            for (int i2 = 0; i2 < size; ++i2) {
                double textHeight;
                Object object;
                if (this.\u04be.contains(new Integer(i2)) || (object = this.\u04ae.get(i2)) == null) continue;
                text = object.toString();
                dim = this.B(this.\u04dd, text, this.\u04d3);
                if (i2 == 0) {
                    this.\u04e6 = dim.getWidth();
                }
                if (!((textHeight = dim.getHeight()) > this.\u04b3)) continue;
                this.\u04b3 = textHeight;
            }
        }
    }

    public void paintChart(Graphics2D g2, int width, int height) {
        this.calculateXScaleTextHeight();
        this.\u04b2 = this.\u04cb;
        if (this.\u04cb < this.min) {
            this.\u04b2 = this.min;
        }
        if (this.\u04cb > this.max) {
            this.\u04b2 = this.max;
        }
        this.\u04e8 = this.\u04a6 < this.\u04bf ? this.\u04bf : this.\u04a6;
        this.\u04e4 = Math.max(this.\u04d0 - this.\u04bf, 1.0);
        this.F(g2, width, height);
        this.E(g2, width, height);
        this.H(g2);
        this.paintContent(g2, width, height);
    }

    protected abstract void paintContent(Graphics2D var1, int var2, int var3);

    private void F(Graphics2D g2, int width, int height) {
        double yAxisTextGapTemp;
        double valueGap;
        double pixelGap;
        double xAxisTextGap;
        boolean drawXAxisText;
        boolean bl = drawXAxisText = this.\u04d4 != null && !this.\u04d4.trim().equals("");
        if (drawXAxisText) {
            Dimension size = this.B(this.\u04d4, this.\u04ad);
            xAxisTextGap = size.getHeight() + (double)this.getXAxisExtraGap(g2) + (double)this.textGap;
        } else {
            xAxisTextGap = this.getXAxisExtraGap(g2);
        }
        Dimension xUnitSize = new Dimension(0, 0);
        if (this.\u04ab && this.\u04b6 && this.\u04e5 != null && this.\u04c1 != null && this.\u04dc != null) {
            Dimension dim = this.B(this.\u04e5, this.\u04c1);
            xUnitSize.setSize(dim.getWidth() + (double)this.textGap, dim.getHeight());
        }
        Dimension yUnitSize = new Dimension(0, 0);
        if (this.\u04d1 && this.\u04b4 && this.\u04b7 != null && this.\u04af != null && this.\u04c2 != null) {
            Dimension dim = this.B(this.\u04b7, this.\u04af);
            yUnitSize.setSize(dim.getWidth() + (double)this.textGap, dim.getHeight() + (double)this.textGap);
        }
        this.\u04c3 = (double)(height - 2 * this.yGap) - xAxisTextGap - (double)this.shadowOffset - yUnitSize.getHeight();
        double xScaleTextUseGap = 0.0;
        if (this.\u04ab && this.\u04a8) {
            double xScaleTextOffset;
            double xScaleTextGap = this.\u04b3;
            if (this.\u04ee) {
                xScaleTextGap = 0.0;
            }
            if (this.\u04b6 && xUnitSize.getHeight() > (double)this.shadowOffset) {
                if (this.\u04ee) {
                    xScaleTextGap = (xUnitSize.getHeight() - (double)this.shadowOffset) / 2.0;
                } else {
                    xScaleTextGap = this.\u04b3;
                    double xScleAndShdowHeight = this.\u04b3 + (double)this.shadowOffset / 2.0;
                    if (xUnitSize.getHeight() / 2.0 > xScleAndShdowHeight) {
                        xScaleTextGap = xUnitSize.getHeight() / 2.0 - xScleAndShdowHeight;
                    }
                }
            }
            if ((xScaleTextOffset = (this.\u04b2 - this.min) / this.range * (this.\u04c3 - xScaleTextGap)) < xScaleTextGap) {
                xScaleTextUseGap = xScaleTextGap - xScaleTextOffset;
            }
            if (this.\u04b2 == this.min) {
                xScaleTextUseGap = xScaleTextGap;
            }
            this.\u04c3 -= xScaleTextUseGap;
        }
        boolean drawYAxisText = false;
        if (this.\u04d8 != -1.7976931348623157E308) {
            pixelGap = Math.max(this.\u04d8 / this.range * this.\u04c3, 1.0);
            valueGap = this.\u04d8;
        } else if (this.\u04d7 > 0.0) {
            pixelGap = Math.max(this.\u04d7 / this.range * this.\u04c3, 1.0);
            valueGap = this.\u04d7;
        } else {
            pixelGap = Math.max(this.\u04d9, 1);
            valueGap = this.range * (pixelGap / this.\u04c3);
        }
        this.\u04c0 = valueGap;
        this.\u04b5 = 0.0;
        if (this.\u04ab) {
            this.\u04b5 = this.\u04e6 / 2.0;
        }
        boolean bl2 = drawYAxisText = this.\u04aa != null && !this.\u04aa.trim().equals("");
        if (drawYAxisText) {
            Dimension size = this.B(3, this.\u04aa, this.\u04e1);
            yAxisTextGapTemp = size.getWidth() + (double)this.textGap;
        } else {
            yAxisTextGapTemp = 0.0;
        }
        this.\u04b5 += yAxisTextGapTemp;
        if (this.\u04d1) {
            double maxYScaleTextGap = 0.0;
            if (this.\u04e0 && this.\u04c4 != null && this.\u04bc != null) {
                if (!this.\u04d2) {
                    double lineCursor = 0.0;
                    double value = this.min;
                    int index = 0;
                    while (lineCursor <= this.\u04c3 + 1.0) {
                        String text;
                        Dimension size;
                        if (!this.\u04b8.contains(new Integer(index)) && (size = this.B(text = this.getFormatedYScaleText(value), this.\u04bc)).getWidth() > maxYScaleTextGap) {
                            maxYScaleTextGap = size.getWidth();
                        }
                        lineCursor += pixelGap;
                        value += valueGap;
                        ++index;
                    }
                }
                maxYScaleTextGap += (double)this.textGap;
            }
            if (maxYScaleTextGap < (yUnitSize.getWidth() - (double)this.shadowOffset) / 2.0) {
                maxYScaleTextGap = (yUnitSize.getWidth() - (double)this.shadowOffset) / 2.0;
            }
            double maxYScaleTextGapTemp = 0.0;
            double yAxisStartUseGap = (this.\u04e8 - this.\u04bf) / this.\u04e4;
            double xAxisTempW = (double)(width - 2 * this.xGap - this.shadowOffset) - xUnitSize.getWidth() - maxYScaleTextGap;
            if (yAxisStartUseGap * xAxisTempW < maxYScaleTextGap) {
                maxYScaleTextGapTemp = maxYScaleTextGap - yAxisStartUseGap * xAxisTempW;
            }
            if (this.\u04e8 == this.\u04bf) {
                maxYScaleTextGapTemp = maxYScaleTextGap;
            }
            if (maxYScaleTextGapTemp < this.\u04e6 / 2.0) {
                maxYScaleTextGapTemp = this.\u04e6 / 2.0;
            }
            this.\u04b5 = yAxisTextGapTemp + maxYScaleTextGapTemp;
        }
        this.\u04bd = (double)(width - 2 * this.xGap - this.shadowOffset) - this.\u04b5 - xUnitSize.getWidth();
        this.backgroundBounds.x = (int)((double)this.xGap + this.\u04b5 + (double)this.shadowOffset);
        this.backgroundBounds.y = (int)((double)this.yGap + yUnitSize.getHeight());
        this.backgroundBounds.width = (int)this.\u04bd;
        this.backgroundBounds.height = (int)this.\u04c3;
        this.paintBackground(g2);
        this.\u04b1.x = (double)this.xGap + this.\u04b5 + (double)this.shadowOffset;
        this.\u04b1.y = (double)this.yGap + yUnitSize.getHeight();
        this.\u04b1.width = this.\u04bd;
        this.\u04b1.height = this.\u04c3;
        double startX = this.\u04b1.x - (double)this.shadowOffset;
        double startY = this.\u04b1.y + this.\u04b1.height + (double)this.shadowOffset;
        if (drawYAxisText) {
            int xText = this.xGap;
            int yText = (int)(this.\u04b1.y + this.\u04b1.height / 2.0);
            this.A(g2, 3, this.\u04aa, this.\u04bb, this.\u04e1, xText, yText, 5);
        }
        double lineCursor = 0.0;
        double value = this.min;
        if (this.\u04da && this.\u04e9 != null && this.\u04d5 != null) {
            while (lineCursor <= this.\u04b1.height + 1.0) {
                if (this.\u04ab && this.\u04b2 == value) {
                    lineCursor += pixelGap;
                    value += valueGap;
                    continue;
                }
                g2.setStroke(TUIManager.getStrokeByType(this.\u04e9));
                g2.setColor(this.\u04d5);
                Line2D.Double line = new Line2D.Double(startX + (double)this.shadowOffset, startY - (double)this.shadowOffset - lineCursor, startX + (double)this.shadowOffset + this.\u04bd, startY - (double)this.shadowOffset - lineCursor);
                g2.draw(line);
                lineCursor += pixelGap;
                value += valueGap;
            }
        }
        lineCursor = 0.0;
        value = this.min;
        if (this.\u04d1) {
            double yStartX = (float)startX;
            if (this.\u04e8 != this.\u04bf) {
                yStartX += (this.\u04e8 - this.\u04bf) / this.\u04e4 * this.\u04bd;
            }
            if (this.\u04b4) {
                this.A(g2, this.\u04b7, this.\u04c2, this.\u04af, (int)(yStartX + (double)(this.shadowOffset / 2)), (int)(this.\u04b1.getY() - (double)this.textGap), 2);
            }
            GeneralPath yAxis = new GeneralPath();
            yAxis.moveTo((float)yStartX, (float)startY);
            yAxis.lineTo((float)(yStartX + (double)this.shadowOffset), (float)(startY - (double)this.shadowOffset));
            yAxis.lineTo((float)(yStartX + (double)this.shadowOffset), (float)this.\u04b1.getY());
            yAxis.lineTo((float)yStartX, (float)(this.\u04b1.getY() + (double)this.shadowOffset));
            yAxis.closePath();
            if (this.\u04c7 != null && this.shadowOffset > 0) {
                g2.setColor(this.\u04c7);
                g2.fill(yAxis);
            }
            if (this.\u04a7 != null && this.\u04ac != null) {
                g2.setStroke(TUIManager.getStrokeByType(this.\u04a7));
                g2.setColor(this.\u04ac);
                g2.draw(yAxis);
            }
            int index = 0;
            while (lineCursor <= this.\u04c3 + 1.0) {
                g2.setStroke(TUIManager.getStrokeByType(this.\u04e9));
                g2.setColor(this.\u04d5);
                if (this.\u04da && this.\u04e9 != null && this.\u04d5 != null && this.shadowOffset > 0) {
                    GeneralPath line = new GeneralPath();
                    line.moveTo((float)yStartX, (float)(startY - lineCursor));
                    line.lineTo((float)(yStartX + (double)this.shadowOffset), (float)(startY - lineCursor - (double)this.shadowOffset));
                    g2.draw(line);
                }
                if (this.\u04e0 && !this.\u04b8.contains(new Integer(index))) {
                    double y;
                    String text = this.getFormatedYScaleText(value);
                    if (this.\u04d2) {
                        double x = yStartX + (double)this.shadowOffset + (double)this.textGap;
                        y = startY - lineCursor - (double)this.shadowOffset;
                        this.A(g2, text, this.\u04c4, this.\u04bc, (int)x, (int)y, 5);
                    } else {
                        double x = yStartX - (double)this.textGap;
                        y = startY - lineCursor;
                        this.A(g2, text, this.\u04c4, this.\u04bc, (int)x, (int)y, 4);
                    }
                }
                lineCursor += pixelGap;
                value += valueGap;
                ++index;
            }
        }
    }

    private void H(Graphics2D g2) {
        if (this.markers == null || this.markers.size() < 1) {
            return;
        }
        int size = this.markers.size();
        for (int i2 = 0; i2 < size; ++i2) {
            Marker marker = (Marker)this.markers.get(i2);
            double value = marker.getValue();
            if (value < this.min || value > this.max) continue;
            double percent = (value - this.min) / this.range;
            double yPosition = this.\u04b1.y + this.\u04b1.height - percent * this.\u04b1.height + (double)marker.getYOffset();
            g2.setStroke(TUIManager.getStrokeByType(marker.getStroke()));
            g2.setColor(marker.getColor());
            Line2D.Double line = new Line2D.Double(this.\u04b1.getX() + (double)marker.getXOffset(), yPosition, this.\u04b1.getX() + this.\u04b1.getWidth(), yPosition);
            g2.draw(line);
            if (marker.getText() == null || marker.getTextColor() == null || marker.getTextFont() == null) continue;
            int x = (int)(this.\u04b1.getX() + (double)marker.getXOffset());
            this.A(g2, marker.getText(), marker.getTextColor(), marker.getTextFont(), x, (int)yPosition, 7);
        }
    }

    private void E(Graphics2D g2, int width, int height) {
        double value;
        boolean useScaleTextList;
        double xValueGap;
        double xPixelGap;
        boolean drawXAxisText;
        boolean bl = drawXAxisText = this.\u04d4 != null && !this.\u04d4.trim().equals("");
        if (drawXAxisText) {
            int xText = (int)(this.\u04b1.getX() + this.\u04b1.getWidth() / 2.0);
            int yText = height - this.yGap;
            this.A(g2, this.\u04d4, this.\u04d6, this.\u04ad, xText, yText, 2);
        }
        double startX = this.\u04b1.getX() - (double)this.shadowOffset;
        double endX = this.\u04b1.getX() + this.\u04b1.getWidth() - (double)this.shadowOffset;
        double xAxisY = this.\u04b1.getY() + this.\u04b1.getHeight() + (double)this.shadowOffset;
        if (this.\u04ea > 0.0) {
            xPixelGap = this.\u04ea / this.\u04e4 * this.\u04bd;
            xValueGap = this.\u04ea;
        } else {
            xPixelGap = this.\u04eb;
            xValueGap = this.\u04e4 * (xPixelGap / this.\u04bd);
        }
        boolean bl2 = useScaleTextList = this.\u04ae != null && this.\u04ae.size() > 0;
        if (useScaleTextList) {
            xPixelGap = this.\u04b1.getWidth() / (double)this.\u04ae.size();
            xValueGap = this.\u04e4 / (double)this.\u04ae.size();
        }
        this.\u04c8 = xValueGap;
        double xAxisBase = useScaleTextList ? startX + xPixelGap / 2.0 : startX;
        double d2 = value = useScaleTextList ? this.\u04bf + xValueGap / 2.0 : this.\u04bf;
        if (this.\u04e7 && this.\u04ef != null && this.\u04a9 != null) {
            while (xAxisBase <= endX + 1.0) {
                if (this.\u04d1 && value == this.\u04e8) {
                    xAxisBase += xPixelGap;
                    value += xValueGap;
                    continue;
                }
                GeneralPath line = new GeneralPath();
                line.moveTo((float)(xAxisBase + (double)this.shadowOffset), (float)(this.\u04b1.getY() + this.\u04b1.getHeight()));
                line.lineTo((float)(xAxisBase + (double)this.shadowOffset), (float)this.\u04b1.getY());
                g2.setStroke(TUIManager.getStrokeByType(this.\u04ef));
                g2.setColor(this.\u04a9);
                g2.draw(line);
                xAxisBase += xPixelGap;
                value += xValueGap;
            }
        }
        if (this.\u04ab) {
            float xStartY = (float)xAxisY;
            if (this.\u04b2 != this.min) {
                xStartY = (float)((double)xStartY - (this.\u04b2 - this.min) / this.range * this.\u04c3);
            }
            if (this.\u04b6) {
                this.A(g2, this.\u04e5, this.\u04dc, this.\u04c1, (int)(this.\u04b1.getX() + this.\u04b1.getWidth() + (double)this.textGap), (int)((double)xStartY - (double)this.shadowOffset / 2.0), 5);
            }
            GeneralPath xAxis = new GeneralPath();
            xAxis.moveTo((float)startX, xStartY);
            xAxis.lineTo((float)startX + (float)this.shadowOffset, xStartY - (float)this.shadowOffset);
            xAxis.lineTo((float)endX + (float)this.shadowOffset, xStartY - (float)this.shadowOffset);
            xAxis.lineTo((float)endX, xStartY);
            xAxis.closePath();
            if (this.\u04e2 != null && this.shadowOffset > 0) {
                g2.setColor(this.\u04e2);
                g2.fill(xAxis);
            }
            if (this.\u04cc != null && this.\u04ba != null) {
                g2.setStroke(TUIManager.getStrokeByType(this.\u04cc));
                g2.setColor(this.\u04ba);
                g2.draw(xAxis);
            }
            xAxisBase = useScaleTextList ? startX + xPixelGap / 2.0 : startX;
            value = useScaleTextList ? this.\u04bf + xValueGap / 2.0 : this.\u04bf;
            int index = 0;
            while (xAxisBase <= endX + 1.0) {
                double x = xAxisBase;
                double y = xStartY;
                if (this.\u04e7 && this.\u04ef != null && this.\u04a9 != null && this.shadowOffset > 0) {
                    GeneralPath line = new GeneralPath();
                    line.moveTo((float)x, (float)y);
                    line.lineTo((float)(x + (double)this.shadowOffset), (float)(y - (double)this.shadowOffset));
                    g2.setStroke(TUIManager.getStrokeByType(this.\u04ef));
                    g2.setColor(this.\u04a9);
                    g2.draw(line);
                }
                if (this.\u04a8 && !this.\u04be.contains(new Integer(index))) {
                    String text = this.getFormatedXScaleText(value);
                    if (this.\u04ae != null && this.\u04ae.size() > 0) {
                        text = this.getXScaleTextFromScaleList(index);
                    }
                    int position = 3;
                    if (this.\u04ee) {
                        position = 2;
                        x += (double)this.shadowOffset;
                        y -= (double)(this.shadowOffset + this.textGap);
                    } else {
                        y += (double)this.textGap;
                    }
                    this.A(g2, this.\u04dd, text, this.\u04e3, this.\u04d3, (int)x, (int)y, position);
                }
                xAxisBase += xPixelGap;
                value += xValueGap;
                ++index;
            }
        }
    }

    protected String getFormatedXScaleText(double value) {
        if (this.\u04de != null) {
            String text = this.\u04de.format(value);
            return text;
        }
        if (this.format != null) {
            String text = this.format.format(value);
            return text;
        }
        return value + "";
    }

    protected String getFormatedYScaleText(double value) {
        if (this.\u04db != null) {
            String text = this.\u04db.format(value);
            return text;
        }
        if (this.format != null) {
            String text = this.format.format(value);
            return text;
        }
        return value + "";
    }

    protected String getXScaleTextFromScaleList(int index) {
        if (this.\u04ae == null) {
            return null;
        }
        if (this.\u04ae.size() <= index || index < 0) {
            return null;
        }
        return (String)this.\u04ae.get(index);
    }

    protected int getXAxisExtraGap(Graphics2D g2d) {
        return 0;
    }

    public double getXScaleActualValueGap() {
        return this.\u04c8;
    }

    public double getYScaleActualValueGap() {
        return this.\u04c0;
    }

    public boolean isXAxisVisible() {
        return this.\u04ab;
    }

    public void setXAxisVisible(boolean axisVisible) {
        this.\u04ab = axisVisible;
        this.chartPane.repaint();
    }

    public Color getXAxisFillColor() {
        return this.\u04e2;
    }

    public void setXAxisFillColor(Color axisFillColor) {
        this.\u04e2 = axisFillColor;
        this.chartPane.repaint();
    }

    public Color getXAxisOutlineColor() {
        return this.\u04ba;
    }

    public void setXAxisOutlineColor(Color axisOutlineColor) {
        this.\u04ba = axisOutlineColor;
        this.chartPane.repaint();
    }

    public Font getXAxisTextFont() {
        return this.\u04ad;
    }

    public void setXAxisTextFont(Font axisTextFont) {
        this.\u04ad = axisTextFont;
        this.chartPane.repaint();
    }

    public Color getXAxisTextColor() {
        return this.\u04d6;
    }

    public void setXAxisTextColor(Color axisTextColor) {
        this.\u04d6 = axisTextColor;
        this.chartPane.repaint();
    }

    public String getXAxisText() {
        return this.\u04d4;
    }

    public void setXAxisText(String axisText) {
        this.\u04d4 = axisText;
        this.chartPane.repaint();
    }

    public String getXAxisStroke() {
        return this.\u04cc;
    }

    public void setXAxisStroke(String axisStroke) {
        this.\u04cc = axisStroke;
        this.chartPane.repaint();
    }

    public String getXAxisUnit() {
        return this.\u04e5;
    }

    public void setXAxisUnit(String axisUnit) {
        this.\u04e5 = axisUnit;
        this.chartPane.repaint();
    }

    public Font getYAxisTextFont() {
        return this.\u04e1;
    }

    public void setYAxisTextFont(Font axisTextFont) {
        this.\u04e1 = axisTextFont;
        this.chartPane.repaint();
    }

    public boolean isYAxisVisible() {
        return this.\u04d1;
    }

    public void setYAxisVisible(boolean axisVisible) {
        this.\u04d1 = axisVisible;
        this.chartPane.repaint();
    }

    public Color getYAxisTextColor() {
        return this.\u04bb;
    }

    public void setYAxisTextColor(Color axisTextColor) {
        this.\u04bb = axisTextColor;
        this.chartPane.repaint();
    }

    public Color getYAxisFillColor() {
        return this.\u04c7;
    }

    public void setYAxisFillColor(Color axisFillColor) {
        this.\u04c7 = axisFillColor;
        this.chartPane.repaint();
    }

    public Color getYAxisOutlineColor() {
        return this.\u04ac;
    }

    public void setYAxisOutlineColor(Color axisOutlineColor) {
        this.\u04ac = axisOutlineColor;
        this.chartPane.repaint();
    }

    public String getYAxisStroke() {
        return this.\u04a7;
    }

    public void setYAxisStroke(String axisStroke) {
        this.\u04a7 = axisStroke;
        this.chartPane.repaint();
    }

    public String getYAxisText() {
        return this.\u04aa;
    }

    public void setYAxisText(String axisText) {
        this.\u04aa = axisText;
        this.chartPane.repaint();
    }

    public boolean isXScaleTextVisible() {
        return this.\u04a8;
    }

    public void setXScaleTextVisible(boolean scaleTextVisible) {
        this.\u04a8 = scaleTextVisible;
        this.chartPane.repaint();
    }

    public NumberFormat getXScaleTextFormat() {
        return this.\u04de;
    }

    public void setXScaleTextFormat(NumberFormat scaleTextFormat) {
        this.\u04de = scaleTextFormat;
        this.chartPane.repaint();
    }

    public Color getXScaleTextColor() {
        return this.\u04e3;
    }

    public void setXScaleTextColor(Color scaleTextColor) {
        this.\u04e3 = scaleTextColor;
        this.chartPane.repaint();
    }

    public Font getXScaleTextFont() {
        return this.\u04d3;
    }

    public void setXScaleTextFont(Font scaleTextFont) {
        this.\u04d3 = scaleTextFont;
        this.chartPane.repaint();
    }

    public double getXScaleValueGap() {
        return this.\u04ea;
    }

    public void setXScaleValueGap(double scaleValueGap) {
        this.\u04ea = scaleValueGap;
        this.chartPane.repaint();
    }

    public double getXScalePixelGap() {
        return this.\u04eb;
    }

    public void setXScalePixelGap(double scalePixelGap) {
        this.\u04eb = scalePixelGap;
        this.chartPane.repaint();
    }

    public double getXScaleMinValue() {
        return this.\u04bf;
    }

    public void setXScaleMinValue(double scaleMinValue) {
        this.\u04bf = scaleMinValue;
        this.publishData(false);
    }

    public double getXScaleMaxValue() {
        return this.\u04d0;
    }

    public void setXScaleMaxValue(double scaleMaxValue) {
        this.\u04d0 = scaleMaxValue;
        this.publishData(false);
    }

    public String getXScaleLineStroke() {
        return this.\u04ef;
    }

    public void setXScaleLineStroke(String scaleLineStroke) {
        this.\u04ef = scaleLineStroke;
        this.chartPane.repaint();
    }

    public Color getXScaleLineColor() {
        return this.\u04a9;
    }

    public void setXScaleLineColor(Color scaleLineColor) {
        this.\u04a9 = scaleLineColor;
        this.chartPane.repaint();
    }

    public boolean isXScaleLineVisible() {
        return this.\u04e7;
    }

    public void setXScaleLineVisible(boolean scaleLineVisible) {
        this.\u04e7 = scaleLineVisible;
        this.chartPane.repaint();
    }

    public boolean isYScaleTextVisible() {
        return this.\u04e0;
    }

    public void setYScaleTextVisible(boolean scaleTextVisible) {
        this.\u04e0 = scaleTextVisible;
        this.chartPane.repaint();
    }

    public boolean isYScaleTextInside() {
        return this.\u04d2;
    }

    public void setYScaleTextInside(boolean scaleTextInside) {
        this.\u04d2 = scaleTextInside;
        this.chartPane.repaint();
    }

    public NumberFormat getYScaleTextFormat() {
        return this.\u04db;
    }

    public void setYScaleTextFormat(NumberFormat scaleTextFormat) {
        this.\u04db = scaleTextFormat;
        this.chartPane.repaint();
    }

    public Color getYScaleTextColor() {
        return this.\u04c4;
    }

    public void setYScaleTextColor(Color scaleTextColor) {
        this.\u04c4 = scaleTextColor;
        this.chartPane.repaint();
    }

    public Font getYScaleTextFont() {
        return this.\u04bc;
    }

    public void setYScaleTextFont(Font scaleTextFont) {
        this.\u04bc = scaleTextFont;
        this.chartPane.repaint();
    }

    public int getYScalePixelGap() {
        return this.\u04d9;
    }

    public void setYScalePixelGap(int scalePixelGap) {
        this.\u04d9 = scalePixelGap;
        this.chartPane.repaint();
    }

    public double getYScaleValueGap() {
        return this.\u04d7;
    }

    public void setYScaleValueGap(double scaleValueGap) {
        this.\u04d7 = scaleValueGap;
        this.chartPane.repaint();
    }

    public String getYScaleLineStroke() {
        return this.\u04e9;
    }

    public void setYScaleLineStroke(String scaleLineStroke) {
        this.\u04e9 = scaleLineStroke;
        this.chartPane.repaint();
    }

    public Color getYScaleLineColor() {
        return this.\u04d5;
    }

    public void setYScaleLineColor(Color scaleLineColor) {
        this.\u04d5 = scaleLineColor;
        this.chartPane.repaint();
    }

    public boolean isYScaleLineVisible() {
        return this.\u04da;
    }

    public void setYScaleLineVisible(boolean scaleLineVisible) {
        this.\u04da = scaleLineVisible;
        this.chartPane.repaint();
    }

    public Rectangle2D.Double getDrawBound() {
        return this.\u04b1;
    }

    public double getXAxisStartPosition() {
        return this.\u04cb;
    }

    public void setXAxisStartPosition(double axisStartPosition) {
        this.\u04cb = axisStartPosition;
        this.chartPane.repaint();
    }

    public double getYAxisStartPosition() {
        return this.\u04a6;
    }

    public void setYAxisStartPosition(double axisStartValue) {
        this.\u04a6 = axisStartValue;
        this.chartPane.repaint();
    }

    public List getXScaleTextList() {
        return this.\u04ae;
    }

    public void setXScaleTextList(List xScaleTextList) {
        this.\u04ae = xScaleTextList;
        this.chartPane.repaint();
    }

    public void addXScaleText(String text) {
        if (this.\u04ae == null) {
            this.\u04ae = new ArrayList();
        }
        this.\u04ae.add(text);
        this.chartPane.repaint();
    }

    public int getXScaleTextOrientation() {
        return this.\u04dd;
    }

    public void setXScaleTextOrientation(int scaleTextOrientation) {
        this.\u04dd = scaleTextOrientation;
        this.chartPane.repaint();
    }

    public List getXScaleHideValueIndex() {
        return this.\u04be;
    }

    public void setXScaleHideValueIndex(List scaleHideValueIndex) {
        this.\u04be = scaleHideValueIndex;
        if (scaleHideValueIndex == null) {
            this.\u04be = new ArrayList();
        }
        this.publishData(false);
    }

    public List getYScaleHideValueIndex() {
        return this.\u04b8;
    }

    public void setYScaleHideValueIndex(List scaleHideValueIndex) {
        this.\u04b8 = scaleHideValueIndex;
        if (scaleHideValueIndex == null) {
            this.\u04b8 = new ArrayList();
        }
        this.publishData(false);
    }

    public boolean isYScaleValueGapAutoCalculate() {
        return this.\u04df;
    }

    public void setYScaleValueGapAutoCalculate(boolean scaleValueGapAutoCaculate) {
        this.\u04df = scaleValueGapAutoCaculate;
        this.publishData(false);
    }

    public boolean isXAxisUnitVisible() {
        return this.\u04b6;
    }

    public void setXAxisUnitVisible(boolean axisUnitVisible) {
        this.\u04b6 = axisUnitVisible;
        this.chartPane.repaint();
    }

    public Color getXAxisUnitColor() {
        return this.\u04dc;
    }

    public void setXAxisUnitColor(Color axisUnitColor) {
        this.\u04dc = axisUnitColor;
        this.chartPane.repaint();
    }

    public Font getXAxisUnitFont() {
        return this.\u04c1;
    }

    public void setXAxisUnitFont(Font axisUnitFont) {
        this.\u04c1 = axisUnitFont;
        this.chartPane.repaint();
    }

    public String getYAxisUnit() {
        return this.\u04b7;
    }

    public void setYAxisUnit(String axisUnit) {
        this.\u04b7 = axisUnit;
        this.chartPane.repaint();
    }

    public boolean isYAxisUnitVisible() {
        return this.\u04b4;
    }

    public void setYAxisUnitVisible(boolean axisUnitVisible) {
        this.\u04b4 = axisUnitVisible;
        this.chartPane.repaint();
    }

    public Color getYAxisUnitColor() {
        return this.\u04c2;
    }

    public void setYAxisUnitColor(Color axisUnitColor) {
        this.\u04c2 = axisUnitColor;
        this.chartPane.repaint();
    }

    public Font getYAxisUnitFont() {
        return this.\u04af;
    }

    public void setYAxisUnitFont(Font axisUnitFont) {
        this.\u04af = axisUnitFont;
        this.chartPane.repaint();
    }

    public double getYScaleMinValue() {
        return this.\u04b0;
    }

    public void setYScaleMinValue(double scaleMinValue) {
        this.\u04b0 = scaleMinValue;
        this.publishData(false);
    }

    public double getYScaleMaxValue() {
        return this.\u04b9;
    }

    public void setYScaleMaxValue(double scaleMaxValue) {
        this.\u04b9 = scaleMaxValue;
        this.publishData(false);
    }

    public boolean isXScaleTextOnTop() {
        return this.\u04ee;
    }

    public List getMarkers() {
        return this.markers;
    }

    public void setMarkers(List markers) {
        this.markers = markers;
        this.chartPane.repaint();
    }

    public void addMarker(double value, Color color) {
        Marker marker = new Marker(value, color);
        this.addMarker(marker);
    }

    public void removeMarker(Marker marker) {
        if (this.markers != null) {
            this.markers.remove(marker);
        }
    }

    public void addMarker(Marker marker) {
        if (marker == null) {
            return;
        }
        if (this.markers == null) {
            this.markers = new ArrayList();
        }
        this.markers.add(marker);
        this.chartPane.repaint();
    }

    public void setXScaleTextOnTop(boolean scaleTextOnTop) {
        this.\u04ee = scaleTextOnTop;
        this.publishData(false);
    }

    protected void setChartSVGAttribute(AbstractSVGChart abschart) {
        super.setChartSVGAttribute(abschart);
        AbstractSVGXYScaleChart chart = (AbstractSVGXYScaleChart)abschart;
        chart.setXAxisVisible(this.isXAxisVisible());
        chart.setXAxisFillColor(this.getXAxisFillColor());
        chart.setXAxisOutlineColor(this.getXAxisOutlineColor());
        chart.setXAxisTextFont(this.getXAxisTextFont());
        chart.setXAxisTextColor(this.getXAxisTextColor());
        chart.setXAxisText(this.getXAxisText());
        chart.setXAxisStroke(this.getXAxisStroke());
        chart.setXAxisUnit(this.getXAxisUnit());
        chart.setYAxisTextFont(this.getYAxisTextFont());
        chart.setYAxisVisible(this.isYAxisVisible());
        chart.setYAxisTextColor(this.getYAxisTextColor());
        chart.setYAxisFillColor(this.getYAxisFillColor());
        chart.setYAxisOutlineColor(this.getYAxisOutlineColor());
        chart.setYAxisStroke(this.getYAxisStroke());
        chart.setYAxisText(this.getYAxisText());
        chart.setXScaleTextVisible(this.isXScaleTextVisible());
        chart.setXScaleTextFormat(this.getXScaleTextFormat());
        chart.setXScaleTextColor(this.getXScaleTextColor());
        chart.setXScaleTextFont(this.getXScaleTextFont());
        chart.setXScaleValueGap(this.getXScaleValueGap());
        chart.setXScalePixelGap(this.getXScalePixelGap());
        chart.setXScaleMinValue(this.getXScaleMinValue());
        chart.setXScaleMaxValue(this.getXScaleMaxValue());
        chart.setXScaleLineStroke(this.getXScaleLineStroke());
        chart.setXScaleLineColor(this.getXScaleLineColor());
        chart.setXScaleLineVisible(this.isXScaleLineVisible());
        chart.setYScaleTextVisible(this.isYScaleTextVisible());
        chart.setYScaleTextInside(this.isYScaleTextInside());
        chart.setYScaleTextFormat(this.getYScaleTextFormat());
        chart.setYScaleTextColor(this.getYScaleTextColor());
        chart.setYScaleTextFont(this.getYScaleTextFont());
        chart.setYScalePixelGap(this.getYScalePixelGap());
        chart.setYScaleValueGap(this.getYScaleValueGap());
        chart.setYScaleLineStroke(this.getYScaleLineStroke());
        chart.setYScaleLineColor(this.getYScaleLineColor());
        chart.setYScaleLineVisible(this.isYScaleLineVisible());
        chart.setXAxisStartPosition(this.getXAxisStartPosition());
        chart.setYAxisStartPosition(this.getYAxisStartPosition());
        chart.setXScaleTextList(this.getXScaleTextList());
        chart.setXScaleTextOrientation(this.getXScaleTextOrientation());
        chart.setXScaleHideValueIndex(this.getXScaleHideValueIndex());
        chart.setYScaleHideValueIndex(this.getYScaleHideValueIndex());
        chart.setYScaleValueGapAutoCalculate(this.isYScaleValueGapAutoCalculate());
        chart.setXAxisUnitVisible(this.isXAxisUnitVisible());
        chart.setXAxisUnitColor(this.getXAxisUnitColor());
        chart.setYAxisUnit(this.getYAxisUnit());
        chart.setYAxisUnitVisible(this.isYAxisUnitVisible());
        chart.setYAxisUnitColor(this.getYAxisUnitColor());
        chart.setYAxisUnitFont(this.getYAxisUnitFont());
        chart.setYScaleMinValue(this.getYScaleMinValue());
        chart.setYScaleMaxValue(this.getYScaleMaxValue());
        chart.setXScaleTextOnTop(this.isXScaleTextOnTop());
    }
}

