/*
 * Decompiled with CFR 0.152.
 */
package y.view;

import java.awt.Cursor;
import y.base.Node;
import y.base.NodeCursor;
import y.view.Graph2D;
import y.view.NodeRealizer;
import y.view.ViewContainer;
import y.view.ViewMode;

public class HotSpotMode
extends ViewMode {
    Graph2D bj;
    double be;
    double bc;
    byte bh;
    double bd;
    double bg;
    boolean bb;
    boolean bf;
    Node bi;

    public HotSpotMode(ViewContainer viewContainer) {
        super(viewContainer);
    }

    public HotSpotMode() {
    }

    public void mousePressedLeft(double d2, double d3) {
        Graph2D graph2D = this.getGraph2D();
        NodeCursor nodeCursor = graph2D.nodes();
        while (nodeCursor.ok()) {
            NodeRealizer nodeRealizer = graph2D.getRealizer(nodeCursor.node());
            if (nodeRealizer.isSelected() && nodeRealizer.hotSpotHit(d2, d3) != 8) {
                this.bf = true;
                this.bi = nodeCursor.node();
                this.bh = nodeRealizer.hotSpotHit(d2, d3);
                this.be = d2;
                this.bc = d3;
                this.a(this.bh);
                this.view.setDrawingMode(1);
                graph2D.backupRealizers(graph2D.selectedNodes());
                break;
            }
            nodeCursor.next();
        }
    }

    public void mouseDraggedLeft(double d2, double d3) {
        if (!this.bf) {
            return;
        }
        Graph2D graph2D = this.getGraph2D();
        double d4 = d2 - this.be;
        double d5 = d3 - this.bc;
        double d6 = d4 > 0.0 ? 1.0 : -1.0;
        double d7 = d5 > 0.0 ? 1.0 : -1.0;
        switch (this.bh) {
            case 0: {
                d4 = -d4;
                d5 = -d5;
                break;
            }
            case 6: {
                d4 = -d4;
                d5 = 0.0;
                d7 = 0.0;
                break;
            }
            case 3: {
                d4 = -d4;
                break;
            }
            case 1: {
                d4 = 0.0;
                d6 = 0.0;
                d5 = -d5;
                break;
            }
            case 4: {
                d4 = 0.0;
                d6 = 0.0;
                break;
            }
            case 2: {
                d5 = -d5;
                break;
            }
            case 7: {
                d5 = 0.0;
                d7 = 0.0;
                break;
            }
        }
        NodeCursor nodeCursor = graph2D.selectedNodes();
        while (nodeCursor.ok()) {
            NodeRealizer nodeRealizer = graph2D.getRealizer(nodeCursor.node());
            double d8 = nodeRealizer.getWidth();
            double d9 = nodeRealizer.getHeight();
            d8 = d8 + d4 < 1.0 ? 1.0 : d8 + d4;
            d9 = d9 + d5 < 1.0 ? 1.0 : d9 + d5;
            double d10 = Math.abs(d8 - nodeRealizer.getWidth()) * d6 / 2.0;
            double d11 = Math.abs(d9 - nodeRealizer.getHeight()) * d7 / 2.0;
            nodeRealizer.moveBy(d10, d11);
            nodeRealizer.setSize(d8, d9);
            if (nodeCursor.node() == this.bi) {
                this.be = d2;
                this.bc = d3;
            }
            nodeCursor.next();
        }
        this.view.updateView();
    }

    public void mouseReleasedLeft(double d2, double d3) {
        this.bf = false;
        this.e();
        this.view.setDrawingMode(0);
        this.getGraph2D().updateViews();
        this.reactivateParent();
    }

    void e() {
        Graph2D graph2D = this.getGraph2D();
        NodeCursor nodeCursor = graph2D.nodes();
        while (nodeCursor.ok()) {
            NodeRealizer nodeRealizer = graph2D.getRealizer(nodeCursor.node());
            if (nodeRealizer.isSelected()) {
                double d2 = nodeRealizer.getCenterX();
                double d3 = nodeRealizer.getCenterY();
                double d4 = this.getGridX(d2);
                double d5 = this.getGridY(d3);
                nodeRealizer.setCenter(d4, d5);
            }
            nodeCursor.next();
        }
    }

    public static Cursor getCursor(byte by) {
        switch (by) {
            case 0: {
                return Cursor.getPredefinedCursor(6);
            }
            case 6: {
                return Cursor.getPredefinedCursor(10);
            }
            case 3: {
                return Cursor.getPredefinedCursor(4);
            }
            case 1: {
                return Cursor.getPredefinedCursor(8);
            }
            case 4: {
                return Cursor.getPredefinedCursor(9);
            }
            case 2: {
                return Cursor.getPredefinedCursor(7);
            }
            case 7: {
                return Cursor.getPredefinedCursor(11);
            }
            case 5: {
                return Cursor.getPredefinedCursor(5);
            }
        }
        return Cursor.getPredefinedCursor(0);
    }

    private void a(byte by) {
        this.view.setViewCursor(HotSpotMode.getCursor(by));
    }
}

