/*
 * Decompiled with CFR 0.152.
 */
package y.layout.hierarchic;

import y.algo.Bfs;
import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeList;
import y.base.Graph;
import y.base.NodeList;
import y.base.NodeMap;
import y.base.YCursor;
import y.layout.LayoutGraph;
import y.layout.hierarchic.Layerer;

public class BFSLayerer
implements Layerer {
    public static final Object CORE_NODES = new Object();

    public int assignNodeLayer(LayoutGraph layoutGraph, NodeMap nodeMap, EdgeList edgeList) {
        YCursor yCursor;
        NodeList[] nodeListArray = null;
        DataProvider dataProvider = layoutGraph.getDataProvider(CORE_NODES);
        NodeList nodeList = new NodeList();
        if (dataProvider != null) {
            yCursor = layoutGraph.nodes();
            while (yCursor.ok()) {
                if (dataProvider.getBool(yCursor.node())) {
                    nodeList.add(yCursor.node());
                }
                yCursor.next();
            }
        }
        if (nodeList.isEmpty()) {
            yCursor = layoutGraph.nodes();
            while (yCursor.ok()) {
                if (yCursor.node().inDegree() == 0) {
                    nodeList.add(yCursor.node());
                }
                yCursor.next();
            }
        }
        if (nodeList.isEmpty() && !layoutGraph.isEmpty()) {
            nodeList.add(layoutGraph.firstNode());
        }
        nodeListArray = Bfs.getLayers((Graph)layoutGraph, nodeList, nodeMap);
        edgeList.clear();
        yCursor = layoutGraph.edges();
        while (yCursor.ok()) {
            Edge edge = yCursor.edge();
            if (nodeMap.getInt(edge.source()) > nodeMap.getInt(edge.target())) {
                edgeList.push(edge);
                layoutGraph.reverseEdge(edge);
            }
            yCursor.next();
        }
        return nodeListArray.length;
    }
}

