/*
 * Decompiled with CFR 0.152.
 */
package y.layout.hierarchic;

import y.base.DataProvider;
import y.base.EdgeCursor;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.base.NodeMap;
import y.geom.YPoint;
import y.layout.LayoutGraph;
import y.layout.hierarchic.Drawer;

public abstract class AbstractDrawer
implements Drawer {
    protected double minimalNodeDistance = 20.0;
    protected double minimalLayerDistance = 60.0;
    protected double minimalEdgeDistance = 5.0;
    protected double minimalMultiEdgeDistance = 0.0;
    protected NodeMap dummyMap;
    protected Object edgeLengthKey;
    protected LayoutGraph graph;

    public void setMinimalEdgeDistance(double d2) {
        this.minimalEdgeDistance = d2;
    }

    public void setMinimalMultiEdgeDistance(double d2) {
        this.minimalMultiEdgeDistance = d2;
    }

    public double getMinimalEdgeDistance() {
        return this.minimalEdgeDistance;
    }

    public double getMinimalMultiEdgeDistance() {
        return this.minimalMultiEdgeDistance;
    }

    public void setMinimalNodeDistance(double d2) {
        this.minimalNodeDistance = d2;
    }

    public void setMinimalLayerDistance(double d2) {
        this.minimalLayerDistance = d2;
    }

    public void setDummyMap(NodeMap nodeMap) {
        this.dummyMap = nodeMap;
    }

    public double getMinimalNodeDistance() {
        return this.minimalNodeDistance;
    }

    public double getMinimalLayerDistance() {
        return this.minimalLayerDistance;
    }

    public void setEdgeLengthKey(Object object) {
        this.edgeLengthKey = object;
    }

    public void assignYCoords(LayoutGraph layoutGraph, NodeList[] nodeListArray) {
        NodeCursor[] nodeCursorArray = new NodeCursor[nodeListArray.length];
        int n = 0;
        while (n < nodeListArray.length) {
            nodeCursorArray[n] = nodeListArray[n].nodes();
            ++n;
        }
        this.assignYCoords(layoutGraph, nodeCursorArray);
    }

    public void assignYCoords(LayoutGraph layoutGraph, NodeCursor[] nodeCursorArray) {
        double[] dArray = new double[nodeCursorArray.length];
        double d2 = 0.0;
        int n = 0;
        while (n < nodeCursorArray.length) {
            DataProvider dataProvider;
            double d3;
            double d4 = 0.0;
            NodeCursor nodeCursor = nodeCursorArray[n];
            nodeCursor.toFirst();
            while (nodeCursor.ok()) {
                d4 = Math.max(d4, layoutGraph.getHeight(nodeCursor.node()));
                nodeCursor.next();
            }
            dArray[n] = d4;
            nodeCursor.toFirst();
            while (nodeCursor.ok()) {
                d3 = (dArray[n] - layoutGraph.getHeight(nodeCursor.node())) / 2.0;
                layoutGraph.setLocation(nodeCursor.node(), new YPoint(layoutGraph.getX(nodeCursor.node()), d2 + d3));
                nodeCursor.next();
            }
            d3 = this.getMinimalLayerDistance();
            if (this.edgeLengthKey != null && (dataProvider = layoutGraph.getDataProvider(this.edgeLengthKey)) != null) {
                nodeCursor.toFirst();
                while (nodeCursor.ok()) {
                    Node node = nodeCursor.node();
                    EdgeCursor edgeCursor = node.outEdges();
                    while (edgeCursor.ok()) {
                        d3 = Math.max(d3, dataProvider.getDouble(edgeCursor.edge()));
                        edgeCursor.next();
                    }
                    nodeCursor.next();
                }
            }
            d2 += dArray[n] + d3;
            nodeCursor.toFirst();
            ++n;
        }
    }

    public void assignCoordinates(LayoutGraph layoutGraph, NodeList[] nodeListArray, DataProvider dataProvider) {
        this.graph = layoutGraph;
        this.assignCoordinates(nodeListArray, dataProvider);
    }

    protected abstract void assignCoordinates(NodeList[] var1, DataProvider var2);

    public double getLeftX(Node node) {
        return this.graph.getX(node) - this.getLeftBorder(node);
    }

    public double getRightX(Node node) {
        return this.graph.getX(node) + this.graph.getWidth(node) + this.getRightBorder(node);
    }

    public double getTopY(Node node) {
        return this.graph.getY(node) - this.getTopBorder(node);
    }

    public double getBottomY(Node node) {
        return this.graph.getY(node) + this.graph.getHeight(node) + this.getBottomBorder(node);
    }

    public double getFullWidth(Node node) {
        return this.graph.getWidth(node) + this.getLeftBorder(node) + this.getRightBorder(node);
    }

    public double getFullHeight(Node node) {
        return this.graph.getHeight(node) + this.getTopBorder(node) + this.getBottomBorder(node);
    }

    public double getLeftBorder(Node node) {
        if (this.dummyMap.get(node) != null) {
            return 0.0;
        }
        DataProvider dataProvider = this.graph.getDataProvider(Drawer.NODE_BORDER_LEFT);
        return dataProvider != null ? dataProvider.getDouble(node) : 0.0;
    }

    public double getRightBorder(Node node) {
        if (this.dummyMap.get(node) != null) {
            return 0.0;
        }
        DataProvider dataProvider = this.graph.getDataProvider(Drawer.NODE_BORDER_RIGHT);
        return dataProvider != null ? dataProvider.getDouble(node) : 0.0;
    }

    public double getTopBorder(Node node) {
        if (this.dummyMap.get(node) != null) {
            return 0.0;
        }
        DataProvider dataProvider = this.graph.getDataProvider(Drawer.NODE_BORDER_TOP);
        return dataProvider != null ? dataProvider.getDouble(node) : 0.0;
    }

    public double getBottomBorder(Node node) {
        if (this.dummyMap.get(node) != null) {
            return 0.0;
        }
        DataProvider dataProvider = this.graph.getDataProvider(Drawer.NODE_BORDER_BOTTOM);
        return dataProvider != null ? dataProvider.getDouble(node) : 0.0;
    }

    public double getLeftHalf(Node node) {
        return this.graph.getWidth(node) / 2.0 + this.getLeftBorder(node);
    }

    public double getRightHalf(Node node) {
        return this.graph.getWidth(node) / 2.0 + this.getRightBorder(node);
    }

    public double getTopHalf(Node node) {
        return this.graph.getHeight(node) / 2.0 + this.getTopBorder(node);
    }

    public double getBottomHalf(Node node) {
        return this.graph.getHeight(node) / 2.0 + this.getBottomBorder(node);
    }
}

