/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.tip.bubble;

import com.nepxion.swing.button.ButtonManager;
import com.nepxion.swing.button.JBasicButton;
import com.nepxion.swing.button.JStyleButton;
import com.nepxion.swing.fullscreen.FullScreenManager;
import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.layout.table.TableLayout;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.panel.decoration.JDecorationPanel;
import com.nepxion.swing.scrollpane.JBasicScrollPane;
import com.nepxion.swing.textarea.JBasicTextArea;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;

public abstract class JBubbleTip {
    public Color background = new Color(255, 255, 225);
    private int width = 300;
    private int height = 140;
    private int step = 30;
    private int stepTime = 30;
    private int displayTime = 10000;
    private int count = 0;
    private int maxCount = 0;
    private int maxCountInSceen;

    public void show(String title, Icon icon, String message) {
        this.show(title, icon, message, null);
    }

    public void show(String title, Icon icon, String message, Object data) {
        BubbleTipWindow bubbleTipWindow = new BubbleTipWindow(data);
        if (title != null) {
            bubbleTipWindow.setTitle(title);
        }
        if (icon != null) {
            bubbleTipWindow.setIcon(icon);
        }
        bubbleTipWindow.setMessage(message);
        BubbleTipAnimation bubbleTipAnimation = new BubbleTipAnimation(bubbleTipWindow);
        bubbleTipAnimation.start();
    }

    public void close(BubbleTipWindow bubbleTipWindow) {
        --this.count;
        bubbleTipWindow.setVisible(false);
        bubbleTipWindow.dispose();
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int step) {
        this.step = step;
    }

    public int getStepTime() {
        return this.stepTime;
    }

    public void setStepTime(int stepTime) {
        this.stepTime = stepTime;
    }

    public int getDisplayTime() {
        return this.displayTime;
    }

    public void setDisplayTime(int displayTime) {
        this.displayTime = displayTime;
    }

    public abstract void viewDetail(Object var1);

    public class BubbleTipAnimation
    extends Thread {
        private BubbleTipWindow bubbleTipWindow;

        public BubbleTipAnimation(BubbleTipWindow tipWindow) {
            this.bubbleTipWindow = tipWindow;
        }

        private void animate(int x, int startY, int endY) throws InterruptedException {
            this.bubbleTipWindow.setLocation(x, startY);
            if (endY < startY) {
                for (int i = startY; i > endY; i -= JBubbleTip.this.step) {
                    this.bubbleTipWindow.setLocation(x, i);
                    Thread.sleep(JBubbleTip.this.stepTime);
                }
            } else {
                for (int i = startY; i < endY; i += JBubbleTip.this.step) {
                    this.bubbleTipWindow.setLocation(x, i);
                    Thread.sleep(JBubbleTip.this.stepTime);
                }
            }
            this.bubbleTipWindow.setLocation(x, endY);
        }

        @Override
        public void run() {
            try {
                int stopY;
                int startY;
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                Rectangle screenRect = ge.getMaximumWindowBounds();
                int screenHeight = screenRect.height;
                boolean isAnimated = true;
                if (screenRect.y > 0) {
                    isAnimated = false;
                }
                JBubbleTip.this.maxCountInSceen = screenHeight / JBubbleTip.this.height;
                int x = screenRect.width - JBubbleTip.this.width - 1;
                this.bubbleTipWindow.setLocation(x, screenHeight);
                this.bubbleTipWindow.setVisible(true);
                if (isAnimated) {
                    startY = screenHeight;
                    stopY = startY - JBubbleTip.this.height - 1;
                    if (JBubbleTip.this.count > 0) {
                        stopY -= JBubbleTip.this.maxCount % JBubbleTip.this.maxCountInSceen * JBubbleTip.this.height;
                    } else {
                        JBubbleTip.this.maxCount = 0;
                    }
                } else {
                    startY = screenRect.y - JBubbleTip.this.height;
                    stopY = screenRect.y;
                    if (JBubbleTip.this.count > 0) {
                        stopY += JBubbleTip.this.maxCount % JBubbleTip.this.maxCountInSceen * JBubbleTip.this.height;
                    } else {
                        JBubbleTip.this.maxCount = 0;
                    }
                }
                JBubbleTip.this.count++;
                JBubbleTip.this.maxCount++;
                this.animate(x, startY, stopY);
                Thread.sleep(JBubbleTip.this.displayTime);
                if (this.bubbleTipWindow.isVisible()) {
                    this.animate(x, stopY, startY);
                    JBubbleTip.this.close(this.bubbleTipWindow);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public class BubbleTipWindow
    extends JWindow {
        private JDecorationPanel decorationPanel;
        private JBasicTextArea messageTextArea;

        public BubbleTipWindow(final Object data) {
            JPanel iconPanel = new JPanel();
            iconPanel.setLayout(new BorderLayout());
            iconPanel.setBackground(JBubbleTip.this.background);
            iconPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
            iconPanel.add((Component)new JLabel(IconFactory.getSwingIcon("tip.png")), "North");
            this.messageTextArea = new JBasicTextArea();
            this.messageTextArea.setBackground(JBubbleTip.this.background);
            this.messageTextArea.setOpaque(true);
            this.messageTextArea.setEditable(false);
            this.messageTextArea.setLineWrap(true);
            this.messageTextArea.setWrapStyleWord(true);
            this.messageTextArea.setFocusable(false);
            this.messageTextArea.setMargin(new Insets(4, 4, 4, 4));
            JBasicScrollPane messageScrollPane = new JBasicScrollPane(this.messageTextArea);
            messageScrollPane.setBorder(null);
            JStyleButton viewDetailButton = new JStyleButton(SwingLocale.getString("view_detail"));
            viewDetailButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JBubbleTip.this.viewDetail(data);
                }
            });
            viewDetailButton.setButtonStyle(3);
            double[][] size = new double[][]{{50.0, -1.0, -2.0}, {-1.0, 30.0}};
            JPanel panel = new JPanel();
            panel.setLayout(new TableLayout(size));
            panel.setBackground(JBubbleTip.this.background);
            panel.add((Component)iconPanel, "0, 0");
            panel.add((Component)messageScrollPane, "1, 0, 2, 0");
            panel.add((Component)((Object)viewDetailButton), "2, 1");
            JBasicButton closeButton = FullScreenManager.createCloseButton(false);
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JBubbleTip.this.close(BubbleTipWindow.this);
                }
            });
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
            buttonPanel.setOpaque(false);
            buttonPanel.add(closeButton);
            ButtonManager.updateUI((Container)buttonPanel, new Dimension(20, 20), true);
            this.decorationPanel = new JDecorationPanel(SwingLocale.getString("message"), (Icon)IconFactory.getSwingIcon("view.png"), SwingLocale.getString("message"), true);
            this.decorationPanel.getHeader().add((Component)buttonPanel, "East");
            this.decorationPanel.setContentPane(panel);
            this.getContentPane().add(this.decorationPanel);
            this.setAlwaysOnTop(true);
            this.setSize(JBubbleTip.this.width, JBubbleTip.this.height);
        }

        public void setTitle(String title) {
            this.decorationPanel.setTitle(title);
        }

        public void setIcon(Icon icon) {
            this.decorationPanel.setIcon(icon);
        }

        public void setMessage(String message) {
            this.messageTextArea.setText(message);
        }
    }
}

