/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.searcher.gis.google.loc;

import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.table.BasicTableModel;
import com.nepxion.util.searcher.gis.google.loc.LocEntity;
import java.util.List;

public class LocTableModel
extends BasicTableModel {
    public static final String[] COLUMN_NAMES = new String[]{SwingLocale.getString("latitude"), SwingLocale.getString("longitude"), SwingLocale.getString("country"), SwingLocale.getString("country_code"), SwingLocale.getString("region"), SwingLocale.getString("city"), SwingLocale.getString("street"), SwingLocale.getString("street_number"), SwingLocale.getString("postal_code")};

    public LocTableModel(List rowDatas) {
        super(rowDatas, COLUMN_NAMES);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return true;
    }

    @Override
    public Object getValueAt(int row, int column) {
        LocEntity entity = (LocEntity)this.rowDatas.get(row);
        switch (column) {
            case 0: {
                return entity.getLatitude() + "";
            }
            case 1: {
                return entity.getLongitude() + "";
            }
            case 2: {
                return entity.getCountry();
            }
            case 3: {
                return entity.getCountryCode();
            }
            case 4: {
                return entity.getRegion();
            }
            case 5: {
                return entity.getCity();
            }
            case 6: {
                return entity.getStreet();
            }
            case 7: {
                return entity.getStreetNumber();
            }
            case 8: {
                return entity.getPostalCode();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        LocEntity entity = (LocEntity)this.rowDatas.get(row);
        switch (column) {
            case 0: {
                entity.setLongitude(Double.parseDouble(value.toString()));
                break;
            }
            case 1: {
                entity.setLatitude(Double.parseDouble(value.toString()));
                break;
            }
            case 2: {
                entity.setCountry(value.toString());
                break;
            }
            case 3: {
                entity.setCountryCode(value.toString());
                break;
            }
            case 4: {
                entity.setRegion(value.toString());
                break;
            }
            case 5: {
                entity.setCity(value.toString());
                break;
            }
            case 6: {
                entity.setStreet(value.toString());
                break;
            }
            case 7: {
                entity.setStreetNumber(value.toString());
                break;
            }
            case 8: {
                entity.setPostalCode(value.toString());
            }
        }
        this.fireTableDataChanged();
    }
}

