/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.ui.explorer;

import com.nepxion.swing.framework.dockable.JDockableView;
import com.nepxion.swing.handle.HandleManager;
import com.nepxion.swing.scrollpane.JBasicScrollPane;
import com.nepxion.swing.table.layoutable.TableCellRendererLayout;
import com.nepxion.swing.ui.explorer.UIExplorerHierarchy;
import com.nepxion.swing.ui.explorer.UIExplorerTable;
import com.nepxion.swing.ui.explorer.UIExplorerTableModel;
import com.nepxion.swing.ui.explorer.UIExplorerTree;
import com.nepxion.swing.ui.explorer.UIExplorerTreeNode;
import java.util.Map;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.tree.TreePath;

public class UIExplorerTreeSelectionListener
implements TreeSelectionListener {
    private UIExplorerTable table;

    @Override
    public void valueChanged(TreeSelectionEvent evt) {
        UIExplorerTree tree = (UIExplorerTree)evt.getSource();
        TreePath treePath = tree.getSelectionPath();
        if (treePath != null) {
            if (this.table == null) {
                UIExplorerHierarchy hierarchy = (UIExplorerHierarchy)HandleManager.getComponent(tree, UIExplorerHierarchy.class);
                JDockableView dockableView = hierarchy.getDockableView(UIExplorerHierarchy.CONTENT_PANE_TITLE);
                JBasicScrollPane scrollPane = (JBasicScrollPane)dockableView.getContentPane();
                this.table = (UIExplorerTable)scrollPane.getViewport().getView();
            }
            UIExplorerTreeNode treeNode = (UIExplorerTreeNode)treePath.getLastPathComponent();
            Object key = treeNode.getKey();
            Object value = treeNode.getValue();
            if (value != null) {
                Map map = (Map)value;
                TableModel tableModel = this.table.getModel();
                if (tableModel != null && tableModel instanceof UIExplorerTableModel) {
                    ((UIExplorerTableModel)tableModel).setRowData(map);
                } else {
                    this.table.setModel(new UIExplorerTableModel(map));
                }
                TableCellRendererLayout layout = new TableCellRendererLayout(this.table);
                layout.doLayout(new int[][]{{300, 400, 100}, new int[0]});
            }
        }
    }
}

