/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.framework.ribbon;

import com.nepxion.swing.action.JAction;
import com.nepxion.swing.border.LineBorder;
import com.nepxion.swing.framework.ribbon.RibbonManager;
import com.nepxion.swing.gradient.JGradientPainter;
import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.toolbar.JBasicToolBar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JRibbon
extends JPanel {
    public static final int BUTTON_STYLE_NORMAL = 0;
    public static final int BUTTON_STYLE_HOVER = 1;
    public static final int BUTTON_STYLE_SELECTED = 2;
    public static final String BUTTON_STYLE = "buttonStyle";
    private JBasicToolBar toolBar = new JBasicToolBar(){

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            int width = this.getWidth();
            int height = this.getHeight();
            JGradientPainter.fastFill(g2d, new Rectangle(0, 0, width, 14), new Color(222, 235, 247), new Color(210, 224, 241), true);
            JGradientPainter.fastFill(g2d, new Rectangle(0, 14, width, height - 14), new Color(199, 216, 237), new Color(231, 242, 255), true);
        }
    };
    private JLabel label;
    private JAction cornerAction;

    public JRibbon() {
        this(null, null);
    }

    public JRibbon(String title, String toolTipText) {
        this(title, null, toolTipText);
    }

    public JRibbon(String title, Icon icon, String toolTipText) {
        this.label = new JLabel(title, icon, 0){

            @Override
            public void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g;
                int width = this.getWidth();
                int height = this.getHeight();
                Rectangle rectangle = new Rectangle(0, 0, width, height);
                JGradientPainter.fastFill(g2d, rectangle, new Color(194, 216, 241), new Color(192, 216, 240), true);
                if (JRibbon.this.cornerAction != null) {
                    Integer buttonStyle = (Integer)JRibbon.this.cornerAction.getValue(JRibbon.BUTTON_STYLE);
                    if (buttonStyle != null) {
                        switch (buttonStyle) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                g2d.drawImage(IconFactory.getSwingIcon("ribbon/button_bg_hover_small.png").getImage(), width - 16, height - 15, null);
                                break;
                            }
                            case 2: {
                                g2d.drawImage(IconFactory.getSwingIcon("ribbon/button_bg_selected_small.png").getImage(), width - 16, height - 15, null);
                            }
                        }
                    }
                    g.setColor(new Color(102, 142, 175));
                    g.drawLine(width - 12, height - 12, width - 7, height - 12);
                    g.drawLine(width - 12, height - 12, width - 12, height - 7);
                    g.drawLine(width - 9, height - 9, width - 9, height - 9);
                    g.drawLine(width - 8, height - 8, width - 6, height - 8);
                    g.drawLine(width - 8, height - 7, width - 6, height - 7);
                    g.drawLine(width - 9, height - 6, width - 6, height - 6);
                    g.drawLine(width - 6, height - 9, width - 6, height - 6);
                    g.setColor(Color.white);
                    g.drawLine(width - 11, height - 11, width - 7, height - 11);
                    g.drawLine(width - 11, height - 11, width - 11, height - 7);
                    g.drawLine(width - 8, height - 9, width - 8, height - 9);
                    g.drawLine(width - 8, height - 5, width - 6, height - 5);
                    g.drawLine(width - 5, height - 9, width - 5, height - 5);
                }
                super.paintComponent(g);
            }
        };
        this.label.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                boolean isAtCorner = JRibbon.this.isAtCorner(e);
                if (isAtCorner) {
                    JRibbon.this.paintCorner(2);
                    if (JRibbon.this.cornerAction != null) {
                        if (JRibbon.this.cornerAction.getSource() == null) {
                            JRibbon.this.cornerAction.setSource(JRibbon.this);
                        }
                        JRibbon.this.cornerAction.actionPerformed(null);
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                boolean isAtCorner = JRibbon.this.isAtCorner(e);
                if (isAtCorner) {
                    JRibbon.this.paintCorner(1);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                JRibbon.this.paintCorner(0);
            }
        });
        this.label.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                boolean isAtCorner = JRibbon.this.isAtCorner(e);
                if (isAtCorner) {
                    JRibbon.this.paintCorner(1);
                } else {
                    JRibbon.this.paintCorner(0);
                }
            }
        });
        this.label.setToolTipText(toolTipText);
        this.label.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 23));
        this.setLayout(new BorderLayout());
        this.setBackground(new Color(231, 239, 248));
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), new LineBorder(RibbonManager.getStyle().getTabbedPaneBorderLineColor())));
        this.add((Component)this.toolBar, "Center");
        this.add((Component)this.label, "South");
        this.setCornerAction(new JAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
    }

    private boolean isAtCorner(MouseEvent e) {
        int width = this.label.getWidth();
        int height = this.label.getHeight();
        int x = e.getX();
        int y = e.getY();
        return x >= width - 16 && x <= width - 2 && y >= 1 && y <= height - 2;
    }

    private void paintCorner(int buttonStyle) {
        if (this.cornerAction == null) {
            return;
        }
        this.cornerAction.putValue(BUTTON_STYLE, buttonStyle);
        this.label.repaint();
    }

    public void setCornerAction(JAction cornerAction) {
        this.cornerAction = cornerAction;
    }

    public JAction getCornerAction() {
        return this.cornerAction;
    }

    public JBasicToolBar getToolBar() {
        return this.toolBar;
    }

    public JLabel getLabel() {
        return this.label;
    }

    public String getTitle() {
        return this.label.getText();
    }

    public void setTitle(String title) {
        this.label.setText(title);
    }

    public Icon getIcon() {
        return this.label.getIcon();
    }

    public void setIcon(Icon icon) {
        this.label.setIcon(icon);
    }

    @Override
    public String getToolTipText() {
        return this.label.getToolTipText();
    }

    @Override
    public void setToolTipText(String toolTipText) {
        this.label.setToolTipText(toolTipText);
    }

    public void toggleFacade(String showType, int showValue) {
        for (int i = 0; i < this.toolBar.getComponentCount(); ++i) {
            AbstractButton button;
            Action action;
            Component ribbonComponent = this.toolBar.getComponent(i);
            if (!(ribbonComponent instanceof AbstractButton) || !((action = (button = (AbstractButton)ribbonComponent).getAction()) instanceof JAction)) continue;
            if (showType.equals("text")) {
                ((JAction)action).showText(showValue);
                continue;
            }
            if (!showType.equals("icon")) continue;
            ((JAction)action).showIcon(showValue);
        }
    }
}

