/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.SwingConstants;
import javax.swing.border.AbstractBorder;

public class LineBorder
extends AbstractBorder
implements SwingConstants {
    private int northThickness;
    private int southThickness;
    private int eastThickness;
    private int westThickness;
    private Color northColor;
    private Color southColor;
    private Color eastColor;
    private Color westColor;

    public LineBorder(Color color) {
        this(color, 1);
    }

    public LineBorder(Color color, int thickness) {
        this.setColor(color);
        this.setThickness(thickness);
    }

    public LineBorder(Color color, Insets insets) {
        this.setColor(color);
        this.setThickness(insets);
    }

    public void setColor(Color color) {
        this.northColor = color;
        this.southColor = color;
        this.eastColor = color;
        this.westColor = color;
    }

    public void setColor(Color color, int direction) {
        switch (direction) {
            case 1: {
                this.northColor = color;
                break;
            }
            case 5: {
                this.southColor = color;
                break;
            }
            case 3: {
                this.eastColor = color;
                break;
            }
            case 7: {
                this.westColor = color;
                break;
            }
        }
    }

    public void setThickness(int thickness) {
        this.northThickness = thickness;
        this.southThickness = thickness;
        this.eastThickness = thickness;
        this.westThickness = thickness;
    }

    public void setThickness(Insets insets) {
        this.northThickness = insets.top;
        this.southThickness = insets.bottom;
        this.eastThickness = insets.right;
        this.westThickness = insets.left;
    }

    public void setThickness(int thickness, int direction) {
        switch (direction) {
            case 1: {
                this.northThickness = thickness;
                break;
            }
            case 5: {
                this.southThickness = thickness;
                break;
            }
            case 3: {
                this.eastThickness = thickness;
                break;
            }
            case 7: {
                this.westThickness = thickness;
                break;
            }
        }
    }

    public void append(LineBorder border, boolean replaced) {
        if (replaced) {
            this.northThickness = border.northThickness;
            this.southThickness = border.southThickness;
            this.eastThickness = border.eastThickness;
            this.westThickness = border.westThickness;
        } else {
            this.northThickness = Math.max(this.northThickness, border.northThickness);
            this.southThickness = Math.max(this.southThickness, border.southThickness);
            this.eastThickness = Math.max(this.eastThickness, border.eastThickness);
            this.westThickness = Math.max(this.westThickness, border.westThickness);
        }
    }

    public void append(Insets insets, boolean replaced) {
        if (replaced) {
            this.northThickness = insets.top;
            this.southThickness = insets.bottom;
            this.eastThickness = insets.right;
            this.westThickness = insets.left;
        } else {
            this.northThickness = Math.max(this.northThickness, insets.top);
            this.southThickness = Math.max(this.southThickness, insets.bottom);
            this.eastThickness = Math.max(this.eastThickness, insets.right);
            this.westThickness = Math.max(this.westThickness, insets.left);
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(this.northThickness, this.westThickness, this.southThickness, this.eastThickness);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        return new Insets(this.northThickness, this.westThickness, this.southThickness, this.eastThickness);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int i;
        Color oldColor = g.getColor();
        if (this.northColor != null) {
            g.setColor(this.northColor);
            for (i = 0; i < this.northThickness; ++i) {
                g.drawLine(x, y + i, x + width - 1, y + i);
            }
        }
        if (this.southColor != null) {
            g.setColor(this.southColor);
            for (i = 0; i < this.southThickness; ++i) {
                g.drawLine(x, y + height - i - 1, x + width - 1, y + height - i - 1);
            }
        }
        if (this.eastColor != null) {
            g.setColor(this.eastColor);
            for (i = 0; i < this.westThickness; ++i) {
                g.drawLine(x + i, y, x + i, y + height - 1);
            }
        }
        if (this.westColor != null) {
            g.setColor(this.westColor);
            for (i = 0; i < this.eastThickness; ++i) {
                g.drawLine(x + width - i - 1, y, x + width - i - 1, y + height - 1);
            }
        }
        g.setColor(oldColor);
    }
}

