/*
 * Decompiled with CFR 0.152.
 */
package twaver.web.svg.chart;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import twaver.TDataBox;
import twaver.TUIManager;
import twaver.base.A.H.I;
import twaver.web.svg.chart.AbstractSVGChart;
import twaver.web.svg.network.SVGContext;

public abstract class AbstractSVGXYScaleChart
extends AbstractSVGChart {
    private boolean \u0179 = TUIManager.getBoolean("tchart.xaxis.visible");
    private Color \u01a9 = TUIManager.getColor("tchart.xaxis.fill.color");
    private Color \u0188 = TUIManager.getColor("tchart.xaxis.outline.color");
    private String \u0196 = TUIManager.getString("tchart.xaxis.stroke");
    private String \u019b = TUIManager.getString("tchart.xaxis.text");
    private Font \u017b = TUIManager.getFont("tchart.xaxis.text.font");
    private Color \u019d = TUIManager.getColor("tchart.xaxis.text.color");
    private double \u0195 = TUIManager.getDouble("tchart.xaxis.start.position");
    private String \u01ac = TUIManager.getString("tchart.xaxis.unit");
    private boolean \u0184 = TUIManager.getBoolean("tchart.xaxis.unit.visible");
    private Color \u01a3 = TUIManager.getColor("tchart.xaxis.unit.color");
    private Font \u018f = TUIManager.getFont("tchart.xaxis.unit.font");
    private boolean \u0198 = TUIManager.getBoolean("tchart.yaxis.visible");
    private Color \u0193 = TUIManager.getColor("tchart.yaxis.fill.color");
    private Color \u017a = TUIManager.getColor("tchart.yaxis.outline.color");
    private String \u0175 = TUIManager.getString("tchart.yaxis.stroke");
    private String \u0178 = TUIManager.getString("tchart.yaxis.text");
    private Font \u01a8 = TUIManager.getFont("tchart.yaxis.text.font");
    private Color \u0189 = TUIManager.getColor("tchart.yaxis.text.color");
    private double \u0174 = TUIManager.getDouble("tchart.yaxis.start.position");
    private String \u0185 = TUIManager.getString("tchart.yaxis.unit");
    private boolean \u0182 = TUIManager.getBoolean("tchart.yaxis.unit.visible");
    private Color \u0190 = TUIManager.getColor("tchart.yaxis.unit.color");
    private Font \u017d = TUIManager.getFont("tchart.yaxis.text.font");
    private boolean \u0176 = TUIManager.getBoolean("tchart.xscale.text.visible");
    private boolean \u01b3 = TUIManager.getBoolean("tchart.xscale.text.ontop");
    private NumberFormat \u01a5 = TUIManager.getNumberFormat("tchart.xscale.text.format");
    private Color \u01aa = TUIManager.getColor("tchart.xscale.text.color");
    private Font \u019a = TUIManager.getFont("tchart.xscale.text.font");
    private String \u01b4 = TUIManager.getString("tchart.xscale.line.stroke");
    private Color \u0177 = TUIManager.getColor("tchart.xscale.line.color");
    private boolean \u01ae = TUIManager.getBoolean("tchart.xscale.line.visible");
    private int \u01a4 = TUIManager.getInt("tchart.xscale.text.orientation");
    private double \u01b1 = TUIManager.getDouble("tchart.xscale.value.gap");
    private double \u01b2 = TUIManager.getDouble("tchart.xscale.pixel.gap");
    private double \u018d = TUIManager.getDouble("tchart.xscale.min.value");
    private double \u0197 = TUIManager.getDouble("tchart.xscale.max.value");
    private boolean \u01a7 = TUIManager.getBoolean("tchart.yscale.text.visible");
    private boolean \u0199 = TUIManager.getBoolean("tchart.yscale.text.inside");
    private NumberFormat \u01a2 = TUIManager.getNumberFormat("tchart.yscale.text.format");
    private Color \u0192 = TUIManager.getColor("tchart.yscale.text.color");
    private Font \u018a = TUIManager.getFont("tchart.yscale.text.font");
    private String \u01b0 = TUIManager.getString("tchart.yscale.line.stroke");
    private Color \u019c = TUIManager.getColor("tchart.yscale.line.color");
    private boolean \u01a1 = TUIManager.getBoolean("tchart.yscale.line.visible");
    private int \u01a0 = TUIManager.getInt("tchart.yscale.pixel.gap");
    private double \u019e = TUIManager.getDouble("tchart.yscale.value.gap");
    private double \u017e = TUIManager.getDouble("tchart.yscale.min.value");
    private double \u0187 = TUIManager.getDouble("tchart.yscale.max.value");
    private boolean \u01a6 = TUIManager.getBoolean("tchart.yscale.value.gap.auto.calculate");
    private Rectangle2D.Double \u017f = new Rectangle2D.Double();
    private List \u018c = new ArrayList();
    private List \u0186 = new ArrayList();
    private double \u0183;
    private double \u018b;
    private double \u0191;
    private List \u017c = null;
    private double \u0181 = 0.0;
    private double \u01ad = 0.0;
    private double \u0180;
    private double \u01af;
    private double \u0194 = 0.0;
    private double \u019f = -1.7976931348623157E308;
    private double \u018e = 0.0;
    private double \u01ab = 0.0;

    public AbstractSVGXYScaleChart() {
    }

    public AbstractSVGXYScaleChart(TDataBox box) {
        super(box);
    }

    public AbstractSVGXYScaleChart(TDataBox box, String title, Color backgroundColor) {
        super(box, title, backgroundColor);
    }

    public AbstractSVGXYScaleChart(TDataBox box, String title, Color backgroundColor, Color foregroundColor) {
        super(box, title, backgroundColor, foregroundColor);
    }

    public StringBuffer toSVGContent(SVGContext context, int width, int height) {
        StringBuffer result = new StringBuffer();
        this.paintChart(context, result, width, height);
        return result;
    }

    protected void calculate() {
        this.calculateYAxisRange();
        this.calculateYScaleValueGap();
    }

    protected void calculateYAxisRange() {
        this.max = this.\u0187;
        this.min = this.\u017e;
        this.range = Math.max(this.max - this.min, 1.0);
    }

    protected void calculateYScaleValueGap() {
        this.\u019f = -1.7976931348623157E308;
        if (this.\u019e <= 0.0 && this.\u01a0 <= 0) {
            this.\u019f = this.B(this.range);
            return;
        }
        if (this.\u01a6) {
            this.\u019f = this.B(this.range);
        }
    }

    private double B(double range) {
        double gap = 0.0;
        double segment = 15.0;
        if (range <= 0.0) {
            return gap;
        }
        if (range < segment) {
            double rangeTemp;
            int ten = 10;
            if (range < 1.0) {
                String[] str = (range + "").split("\\.");
                String after = str[1];
                int length = after.length();
                for (int i2 = 0; i2 < length && "0".equals(after.substring(i2, i2 + 1)); ++i2) {
                    ten *= 10;
                }
            } else {
                ten = 1;
            }
            if ((rangeTemp = (double)ten * range) >= 4.0) {
                gap = 1.0 / (double)ten;
            } else if (rangeTemp >= segment / 10.0) {
                gap = 0.5 / (double)ten;
            } else if (rangeTemp < segment / 10.0) {
                gap = 0.1 / (double)ten;
            }
        }
        if (range < 25.0 && range >= segment) {
            gap = 5.0;
        }
        if (range >= 25.0) {
            int length = ((int)range + "").trim().length();
            int ten = 1;
            for (int i3 = 0; i3 < length - 1; ++i3) {
                ten *= 10;
            }
            gap = ten;
            double divisor = range / gap;
            if (divisor < 4.0 && (divisor = range / (gap = (double)(ten / 2))) < 4.0 && (divisor = range / (gap = (double)(ten / 5))) < 4.0) {
                gap = ten / 10;
            }
        }
        return gap;
    }

    protected void calculateXScaleTextHeight() {
        String text = this.getFormatedXScaleText(this.\u0197);
        Dimension dim = this.A(this.\u01a4, text, this.\u019a);
        this.\u0181 = dim.getHeight();
        this.\u01ad = this.A((int)this.\u01a4, (String)this.getFormatedXScaleText((double)this.\u018d), (Font)this.\u019a).width;
        if (this.\u018c != null && this.\u018c.contains(new Integer(0))) {
            this.\u01ad = 0.0;
            return;
        }
        if (!this.\u0179 || !this.\u0176) {
            this.\u0181 = 0.0;
            this.\u01ad = 0.0;
            return;
        }
        if (this.\u017c != null && this.\u017c.size() > 0) {
            this.\u0181 = 0.0;
            this.\u01ad = 0.0;
            int size = this.\u017c.size();
            for (int i2 = 0; i2 < size; ++i2) {
                double textHeight;
                Object object;
                if (this.\u018c.contains(new Integer(i2)) || (object = this.\u017c.get(i2)) == null) continue;
                text = object.toString();
                dim = this.A(this.\u01a4, text, this.\u019a);
                if (i2 == 0) {
                    this.\u01ad = dim.getWidth();
                }
                if (!((textHeight = dim.getHeight()) > this.\u0181)) continue;
                this.\u0181 = textHeight;
            }
        }
    }

    public void paintChart(SVGContext context, StringBuffer result, int width, int height) {
        this.calculateXScaleTextHeight();
        this.\u0180 = this.\u0195;
        if (this.\u0195 < this.min) {
            this.\u0180 = this.min;
        }
        if (this.\u0195 > this.max) {
            this.\u0180 = this.max;
        }
        this.\u01af = this.\u0174 < this.\u018d ? this.\u018d : this.\u0174;
        this.\u01ab = Math.max(this.\u0197 - this.\u018d, 1.0);
        this.H(context, result, width, height);
        this.G(context, result, width, height);
        this.paintContent(context, result, width, height);
    }

    protected abstract void paintContent(SVGContext var1, StringBuffer var2, int var3, int var4);

    private void H(SVGContext context, StringBuffer result, int width, int height) {
        double yAxisTextGapTemp;
        double valueGap;
        double pixelGap;
        double xAxisTextGap;
        boolean drawXAxisText;
        boolean bl = drawXAxisText = this.\u019b != null && !this.\u019b.trim().equals("");
        if (drawXAxisText) {
            Dimension size = this.A(this.\u019b, this.\u017b);
            xAxisTextGap = size.getHeight() + (double)this.getXAxisExtraGap(context, result) + (double)this.textGap;
        } else {
            xAxisTextGap = this.getXAxisExtraGap(context, result);
        }
        Dimension xUnitSize = new Dimension(0, 0);
        if (this.\u0179 && this.\u0184 && this.\u01ac != null && this.\u018f != null && this.\u01a3 != null) {
            Dimension dim = this.A(this.\u01ac, this.\u018f);
            xUnitSize.setSize(dim.getWidth() + (double)this.textGap, dim.getHeight());
        }
        Dimension yUnitSize = new Dimension(0, 0);
        if (this.\u0198 && this.\u0182 && this.\u0185 != null && this.\u017d != null && this.\u0190 != null) {
            Dimension dim = this.A(this.\u0185, this.\u017d);
            yUnitSize.setSize(dim.getWidth() + (double)this.textGap, dim.getHeight() + (double)this.textGap);
        }
        this.\u0191 = (double)(height - 2 * this.yGap) - xAxisTextGap - (double)this.shadowOffset - yUnitSize.getHeight();
        double xScaleTextUseGap = 0.0;
        if (this.\u0179 && this.\u0176) {
            double xScaleTextOffset;
            double xScaleTextGap = this.\u0181;
            if (this.\u01b3) {
                xScaleTextGap = 0.0;
            }
            if (this.\u0184 && xUnitSize.getHeight() > (double)this.shadowOffset) {
                if (this.\u01b3) {
                    xScaleTextGap = (xUnitSize.getHeight() - (double)this.shadowOffset) / 2.0;
                } else {
                    xScaleTextGap = this.\u0181;
                    double xScleAndShdowHeight = this.\u0181 + (double)this.shadowOffset / 2.0;
                    if (xUnitSize.getHeight() / 2.0 > xScleAndShdowHeight) {
                        xScaleTextGap = xUnitSize.getHeight() / 2.0 - xScleAndShdowHeight;
                    }
                }
            }
            if ((xScaleTextOffset = (this.\u0180 - this.min) / this.range * (this.\u0191 - xScaleTextGap)) < xScaleTextGap) {
                xScaleTextUseGap = xScaleTextGap - xScaleTextOffset;
            }
            if (this.\u0180 == this.min) {
                xScaleTextUseGap = xScaleTextGap;
            }
            this.\u0191 -= xScaleTextUseGap;
        }
        boolean drawYAxisText = false;
        if (this.\u019f != -1.7976931348623157E308) {
            pixelGap = Math.max(this.\u019f / this.range * this.\u0191, 1.0);
            valueGap = this.\u019f;
        } else if (this.\u019e > 0.0) {
            pixelGap = Math.max(this.\u019e / this.range * this.\u0191, 1.0);
            valueGap = this.\u019e;
        } else {
            pixelGap = Math.max(this.\u01a0, 1);
            valueGap = this.range * (pixelGap / this.\u0191);
        }
        this.\u018e = valueGap;
        this.\u0183 = 0.0;
        if (this.\u0179) {
            this.\u0183 = this.\u01ad / 2.0;
        }
        boolean bl2 = drawYAxisText = this.\u0178 != null && !this.\u0178.trim().equals("");
        if (drawYAxisText) {
            Dimension size = this.A(3, this.\u0178, this.\u01a8);
            yAxisTextGapTemp = size.getWidth() + (double)this.textGap;
        } else {
            yAxisTextGapTemp = 0.0;
        }
        this.\u0183 += yAxisTextGapTemp;
        if (this.\u0198) {
            double maxYScaleTextGap = 0.0;
            if (this.\u01a7 && this.\u0192 != null && this.\u018a != null) {
                if (!this.\u0199) {
                    double lineCursor = 0.0;
                    double value = this.min;
                    int index = 0;
                    while (lineCursor <= this.\u0191 + 1.0) {
                        String text;
                        Dimension size;
                        if (!this.\u0186.contains(new Integer(index)) && (size = this.A(text = this.getFormatedYScaleText(value), this.\u018a)).getWidth() > maxYScaleTextGap) {
                            maxYScaleTextGap = size.getWidth();
                        }
                        lineCursor += pixelGap;
                        value += valueGap;
                        ++index;
                    }
                }
                maxYScaleTextGap += (double)this.textGap;
            }
            if (maxYScaleTextGap < (yUnitSize.getWidth() - (double)this.shadowOffset) / 2.0) {
                maxYScaleTextGap = (yUnitSize.getWidth() - (double)this.shadowOffset) / 2.0;
            }
            double maxYScaleTextGapTemp = 0.0;
            double yAxisStartUseGap = (this.\u01af - this.\u018d) / this.\u01ab;
            double xAxisTempW = (double)(width - 2 * this.xGap - this.shadowOffset) - xUnitSize.getWidth() - maxYScaleTextGap;
            if (yAxisStartUseGap * xAxisTempW < maxYScaleTextGap) {
                maxYScaleTextGapTemp = maxYScaleTextGap - yAxisStartUseGap * xAxisTempW;
            }
            if (this.\u01af == this.\u018d) {
                maxYScaleTextGapTemp = maxYScaleTextGap;
            }
            if (maxYScaleTextGapTemp < this.\u01ad / 2.0) {
                maxYScaleTextGapTemp = this.\u01ad / 2.0;
            }
            this.\u0183 = yAxisTextGapTemp + maxYScaleTextGapTemp;
        }
        this.\u018b = (double)(width - 2 * this.xGap - this.shadowOffset) - this.\u0183 - xUnitSize.getWidth();
        this.backgroundBounds.x = (int)((double)this.xGap + this.\u0183 + (double)this.shadowOffset);
        this.backgroundBounds.y = (int)((double)this.yGap + yUnitSize.getHeight());
        this.backgroundBounds.width = (int)this.\u018b;
        this.backgroundBounds.height = (int)this.\u0191;
        this.appendSVGBackground(context, result);
        this.\u017f.x = (double)this.xGap + this.\u0183 + (double)this.shadowOffset;
        this.\u017f.y = (double)this.yGap + yUnitSize.getHeight();
        this.\u017f.width = this.\u018b;
        this.\u017f.height = this.\u0191;
        double startX = this.\u017f.x - (double)this.shadowOffset;
        double startY = this.\u017f.y + this.\u017f.height + (double)this.shadowOffset;
        if (drawYAxisText) {
            int xText = (int)((double)this.xGap + this.A(this.\u0178, this.\u01a8).getHeight() - 2.0);
            int yText = (int)(this.\u017f.y + this.\u017f.height / 2.0 + this.A(this.\u0178, this.\u01a8).getWidth() / 2.0);
            I.A(context, result, this.\u0178, this.\u0189, this.\u01a8, xText, yText, 3, 5);
        }
        double lineCursor = 0.0;
        double value = this.min;
        if (this.\u01a1 && this.\u01b0 != null && this.\u019c != null) {
            while (lineCursor <= this.\u017f.height + 1.0) {
                if (this.\u0179 && this.\u0180 == value) {
                    lineCursor += pixelGap;
                    value += valueGap;
                    continue;
                }
                Line2D.Double line = new Line2D.Double(startX + (double)this.shadowOffset, startY - (double)this.shadowOffset - lineCursor, startX + (double)this.shadowOffset + this.\u018b, startY - (double)this.shadowOffset - lineCursor);
                I.A(context, result, line, this.\u019c, TUIManager.getStrokeByType(this.\u01b0));
                lineCursor += pixelGap;
                value += valueGap;
            }
        }
        lineCursor = 0.0;
        value = this.min;
        if (this.\u0198) {
            double yStartX = (float)startX;
            if (this.\u01af != this.\u018d) {
                yStartX += (this.\u01af - this.\u018d) / this.\u01ab * this.\u018b;
            }
            if (this.\u0182) {
                I.A(context, result, this.\u0185, this.\u0190, this.\u017d, (int)(yStartX + (double)(this.shadowOffset / 2)), (int)(this.\u017f.getY() - (double)this.textGap), 2);
            }
            GeneralPath yAxis = new GeneralPath();
            yAxis.moveTo((float)yStartX, (float)startY);
            yAxis.lineTo((float)(yStartX + (double)this.shadowOffset), (float)(startY - (double)this.shadowOffset));
            yAxis.lineTo((float)(yStartX + (double)this.shadowOffset), (float)this.\u017f.getY());
            yAxis.lineTo((float)yStartX, (float)(this.\u017f.getY() + (double)this.shadowOffset));
            yAxis.closePath();
            if (this.\u0193 != null && this.shadowOffset > 0) {
                I.A(context, result, yAxis, this.\u0193);
            }
            if (this.\u0175 != null && this.\u017a != null) {
                I.A(context, result, yAxis, this.\u017a, TUIManager.getStrokeByType(this.\u0175));
            }
            int index = 0;
            while (lineCursor <= this.\u0191 + 1.0) {
                if (this.\u01a1 && this.\u01b0 != null && this.\u019c != null && this.shadowOffset > 0) {
                    GeneralPath line = new GeneralPath();
                    line.moveTo((float)yStartX, (float)(startY - lineCursor));
                    line.lineTo((float)(yStartX + (double)this.shadowOffset), (float)(startY - lineCursor - (double)this.shadowOffset));
                    I.A(context, result, line, this.\u019c, TUIManager.getStrokeByType(this.\u01b0));
                }
                if (this.\u01a7 && !this.\u0186.contains(new Integer(index))) {
                    double y;
                    String text = this.getFormatedYScaleText(value);
                    if (this.\u0199) {
                        double x = yStartX + (double)this.shadowOffset + (double)this.textGap;
                        y = startY - lineCursor - (double)this.shadowOffset;
                        I.A(context, result, text, this.\u0192, this.\u018a, (int)x, (int)y, 5);
                    } else {
                        double x = yStartX - (double)this.textGap;
                        y = startY - lineCursor;
                        I.A(context, result, text, this.\u0192, this.\u018a, (int)x, (int)y, 4);
                    }
                }
                lineCursor += pixelGap;
                value += valueGap;
                ++index;
            }
        }
    }

    private void G(SVGContext context, StringBuffer result, int width, int height) {
        double value;
        boolean useScaleTextList;
        double xValueGap;
        double xPixelGap;
        boolean drawXAxisText;
        boolean bl = drawXAxisText = this.\u019b != null && !this.\u019b.trim().equals("");
        if (drawXAxisText) {
            int xText = (int)(this.\u017f.getX() + this.\u017f.getWidth() / 2.0);
            int yText = height - this.yGap;
            I.A(context, result, this.\u019b, this.\u019d, this.\u017b, xText, yText, 2);
        }
        double startX = this.\u017f.getX() - (double)this.shadowOffset;
        double endX = this.\u017f.getX() + this.\u017f.getWidth() - (double)this.shadowOffset;
        double xAxisY = this.\u017f.getY() + this.\u017f.getHeight() + (double)this.shadowOffset;
        if (this.\u01b1 > 0.0) {
            xPixelGap = this.\u01b1 / this.\u01ab * this.\u018b;
            xValueGap = this.\u01b1;
        } else {
            xPixelGap = this.\u01b2;
            xValueGap = this.\u01ab * (xPixelGap / this.\u018b);
        }
        boolean bl2 = useScaleTextList = this.\u017c != null && this.\u017c.size() > 0;
        if (useScaleTextList) {
            xPixelGap = this.\u017f.getWidth() / (double)this.\u017c.size();
            xValueGap = this.\u01ab / (double)this.\u017c.size();
        }
        this.\u0194 = xValueGap;
        double xAxisBase = useScaleTextList ? startX + xPixelGap / 2.0 : startX;
        double d2 = value = useScaleTextList ? this.\u018d + xValueGap / 2.0 : this.\u018d;
        if (this.\u01ae && this.\u01b4 != null && this.\u0177 != null) {
            while (xAxisBase <= endX + 1.0) {
                if (this.\u0198 && value == this.\u01af) {
                    xAxisBase += xPixelGap;
                    value += xValueGap;
                    continue;
                }
                GeneralPath line = new GeneralPath();
                line.moveTo((float)(xAxisBase + (double)this.shadowOffset), (float)(this.\u017f.getY() + this.\u017f.getHeight()));
                line.lineTo((float)(xAxisBase + (double)this.shadowOffset), (float)this.\u017f.getY());
                I.A(context, result, line, this.\u0177, TUIManager.getStrokeByType(this.\u01b4));
                xAxisBase += xPixelGap;
                value += xValueGap;
            }
        }
        if (this.\u0179) {
            float xStartY = (float)xAxisY;
            if (this.\u0180 != this.min) {
                xStartY = (float)((double)xStartY - (this.\u0180 - this.min) / this.range * this.\u0191);
            }
            if (this.\u0184) {
                I.A(context, result, this.\u01ac, this.\u01a3, this.\u018f, (int)(this.\u017f.getX() + this.\u017f.getWidth() + (double)this.textGap), (int)((double)xStartY - (double)this.shadowOffset / 2.0), 5);
            }
            GeneralPath xAxis = new GeneralPath();
            xAxis.moveTo((float)startX, xStartY);
            xAxis.lineTo((float)startX + (float)this.shadowOffset, xStartY - (float)this.shadowOffset);
            xAxis.lineTo((float)endX + (float)this.shadowOffset, xStartY - (float)this.shadowOffset);
            xAxis.lineTo((float)endX, xStartY);
            xAxis.closePath();
            if (this.\u01a9 != null && this.shadowOffset > 0) {
                I.A(context, result, new Area(xAxis), this.\u01a9);
            }
            if (this.\u0196 != null && this.\u0188 != null) {
                I.A(context, result, xAxis, this.\u0188, TUIManager.getStrokeByType(this.\u0196));
            }
            xAxisBase = useScaleTextList ? startX + xPixelGap / 2.0 : startX;
            value = useScaleTextList ? this.\u018d + xValueGap / 2.0 : this.\u018d;
            int index = 0;
            while (xAxisBase <= endX + 1.0) {
                double x = xAxisBase;
                double y = xStartY;
                if (this.\u01ae && this.\u01b4 != null && this.\u0177 != null && this.shadowOffset > 0) {
                    GeneralPath line = new GeneralPath();
                    line.moveTo((float)x, (float)y);
                    line.lineTo((float)(x + (double)this.shadowOffset), (float)(y - (double)this.shadowOffset));
                    I.A(context, result, line, this.\u0177, TUIManager.getStrokeByType(this.\u01b4));
                }
                if (this.\u0176 && !this.\u018c.contains(new Integer(index))) {
                    String text = this.getFormatedXScaleText(value);
                    if (this.\u017c != null && this.\u017c.size() > 0) {
                        text = this.getXScaleTextFromScaleList(index);
                    }
                    int position = 3;
                    if (this.\u01b3) {
                        position = 2;
                        x += (double)this.shadowOffset;
                        y -= (double)(this.shadowOffset + this.textGap);
                    } else {
                        y += (double)this.textGap;
                    }
                    I.A(context, result, text, this.\u01aa, this.\u019a, (int)x, (int)y, this.\u01a4, position);
                }
                xAxisBase += xPixelGap;
                value += xValueGap;
                ++index;
            }
        }
    }

    protected String getFormatedXScaleText(double value) {
        if (this.\u01a5 != null) {
            String text = this.\u01a5.format(value);
            return text;
        }
        if (this.format != null) {
            String text = this.format.format(value);
            return text;
        }
        return value + "";
    }

    protected String getFormatedYScaleText(double value) {
        if (this.\u01a2 != null) {
            String text = this.\u01a2.format(value);
            return text;
        }
        if (this.format != null) {
            String text = this.format.format(value);
            return text;
        }
        return value + "";
    }

    protected String getXScaleTextFromScaleList(int index) {
        if (this.\u017c == null) {
            return null;
        }
        if (this.\u017c.size() <= index || index < 0) {
            return null;
        }
        return (String)this.\u017c.get(index);
    }

    protected int getXAxisExtraGap(SVGContext context, StringBuffer result) {
        return 0;
    }

    public double getXScaleActualValueGap() {
        return this.\u0194;
    }

    public double getYScaleActualValueGap() {
        return this.\u018e;
    }

    public boolean isXAxisVisible() {
        return this.\u0179;
    }

    public void setXAxisVisible(boolean axisVisible) {
        this.\u0179 = axisVisible;
    }

    public Color getXAxisFillColor() {
        return this.\u01a9;
    }

    public void setXAxisFillColor(Color axisFillColor) {
        this.\u01a9 = axisFillColor;
    }

    public Color getXAxisOutlineColor() {
        return this.\u0188;
    }

    public void setXAxisOutlineColor(Color axisOutlineColor) {
        this.\u0188 = axisOutlineColor;
    }

    public Font getXAxisTextFont() {
        return this.\u017b;
    }

    public void setXAxisTextFont(Font axisTextFont) {
        this.\u017b = axisTextFont;
    }

    public Color getXAxisTextColor() {
        return this.\u019d;
    }

    public void setXAxisTextColor(Color axisTextColor) {
        this.\u019d = axisTextColor;
    }

    public String getXAxisText() {
        return this.\u019b;
    }

    public void setXAxisText(String axisText) {
        this.\u019b = axisText;
    }

    public String getXAxisStroke() {
        return this.\u0196;
    }

    public void setXAxisStroke(String axisStroke) {
        this.\u0196 = axisStroke;
    }

    public String getXAxisUnit() {
        return this.\u01ac;
    }

    public void setXAxisUnit(String axisUnit) {
        this.\u01ac = axisUnit;
    }

    public Font getYAxisTextFont() {
        return this.\u01a8;
    }

    public void setYAxisTextFont(Font axisTextFont) {
        this.\u01a8 = axisTextFont;
    }

    public boolean isYAxisVisible() {
        return this.\u0198;
    }

    public void setYAxisVisible(boolean axisVisible) {
        this.\u0198 = axisVisible;
    }

    public Color getYAxisTextColor() {
        return this.\u0189;
    }

    public void setYAxisTextColor(Color axisTextColor) {
        this.\u0189 = axisTextColor;
    }

    public Color getYAxisFillColor() {
        return this.\u0193;
    }

    public void setYAxisFillColor(Color axisFillColor) {
        this.\u0193 = axisFillColor;
    }

    public Color getYAxisOutlineColor() {
        return this.\u017a;
    }

    public void setYAxisOutlineColor(Color axisOutlineColor) {
        this.\u017a = axisOutlineColor;
    }

    public String getYAxisStroke() {
        return this.\u0175;
    }

    public void setYAxisStroke(String axisStroke) {
        this.\u0175 = axisStroke;
    }

    public String getYAxisText() {
        return this.\u0178;
    }

    public void setYAxisText(String axisText) {
        this.\u0178 = axisText;
    }

    public boolean isXScaleTextVisible() {
        return this.\u0176;
    }

    public void setXScaleTextVisible(boolean scaleTextVisible) {
        this.\u0176 = scaleTextVisible;
    }

    public NumberFormat getXScaleTextFormat() {
        return this.\u01a5;
    }

    public void setXScaleTextFormat(NumberFormat scaleTextFormat) {
        this.\u01a5 = scaleTextFormat;
    }

    public Color getXScaleTextColor() {
        return this.\u01aa;
    }

    public void setXScaleTextColor(Color scaleTextColor) {
        this.\u01aa = scaleTextColor;
    }

    public Font getXScaleTextFont() {
        return this.\u019a;
    }

    public void setXScaleTextFont(Font scaleTextFont) {
        this.\u019a = scaleTextFont;
    }

    public double getXScaleValueGap() {
        return this.\u01b1;
    }

    public void setXScaleValueGap(double scaleValueGap) {
        this.\u01b1 = scaleValueGap;
    }

    public double getXScalePixelGap() {
        return this.\u01b2;
    }

    public void setXScalePixelGap(double scalePixelGap) {
        this.\u01b2 = scalePixelGap;
    }

    public double getXScaleMinValue() {
        return this.\u018d;
    }

    public void setXScaleMinValue(double scaleMinValue) {
        this.\u018d = scaleMinValue;
        this.publishData();
    }

    public double getXScaleMaxValue() {
        return this.\u0197;
    }

    public void setXScaleMaxValue(double scaleMaxValue) {
        this.\u0197 = scaleMaxValue;
        this.publishData();
    }

    public String getXScaleLineStroke() {
        return this.\u01b4;
    }

    public void setXScaleLineStroke(String scaleLineStroke) {
        this.\u01b4 = scaleLineStroke;
    }

    public Color getXScaleLineColor() {
        return this.\u0177;
    }

    public void setXScaleLineColor(Color scaleLineColor) {
        this.\u0177 = scaleLineColor;
    }

    public boolean isXScaleLineVisible() {
        return this.\u01ae;
    }

    public void setXScaleLineVisible(boolean scaleLineVisible) {
        this.\u01ae = scaleLineVisible;
    }

    public boolean isYScaleTextVisible() {
        return this.\u01a7;
    }

    public void setYScaleTextVisible(boolean scaleTextVisible) {
        this.\u01a7 = scaleTextVisible;
    }

    public boolean isYScaleTextInside() {
        return this.\u0199;
    }

    public void setYScaleTextInside(boolean scaleTextInside) {
        this.\u0199 = scaleTextInside;
    }

    public NumberFormat getYScaleTextFormat() {
        return this.\u01a2;
    }

    public void setYScaleTextFormat(NumberFormat scaleTextFormat) {
        this.\u01a2 = scaleTextFormat;
    }

    public Color getYScaleTextColor() {
        return this.\u0192;
    }

    public void setYScaleTextColor(Color scaleTextColor) {
        this.\u0192 = scaleTextColor;
    }

    public Font getYScaleTextFont() {
        return this.\u018a;
    }

    public void setYScaleTextFont(Font scaleTextFont) {
        this.\u018a = scaleTextFont;
    }

    public int getYScalePixelGap() {
        return this.\u01a0;
    }

    public void setYScalePixelGap(int scalePixelGap) {
        this.\u01a0 = scalePixelGap;
    }

    public double getYScaleValueGap() {
        return this.\u019e;
    }

    public void setYScaleValueGap(double scaleValueGap) {
        this.\u019e = scaleValueGap;
    }

    public String getYScaleLineStroke() {
        return this.\u01b0;
    }

    public void setYScaleLineStroke(String scaleLineStroke) {
        this.\u01b0 = scaleLineStroke;
    }

    public Color getYScaleLineColor() {
        return this.\u019c;
    }

    public void setYScaleLineColor(Color scaleLineColor) {
        this.\u019c = scaleLineColor;
    }

    public boolean isYScaleLineVisible() {
        return this.\u01a1;
    }

    public void setYScaleLineVisible(boolean scaleLineVisible) {
        this.\u01a1 = scaleLineVisible;
    }

    public Rectangle2D.Double getDrawBound() {
        return this.\u017f;
    }

    public double getXAxisStartPosition() {
        return this.\u0195;
    }

    public void setXAxisStartPosition(double axisStartPosition) {
        this.\u0195 = axisStartPosition;
    }

    public double getYAxisStartPosition() {
        return this.\u0174;
    }

    public void setYAxisStartPosition(double axisStartValue) {
        this.\u0174 = axisStartValue;
    }

    public List getXScaleTextList() {
        return this.\u017c;
    }

    public void setXScaleTextList(List xScaleTextList) {
        this.\u017c = xScaleTextList;
    }

    public void addXScaleText(String text) {
        if (this.\u017c == null) {
            this.\u017c = new ArrayList();
        }
        this.\u017c.add(text);
    }

    public int getXScaleTextOrientation() {
        return this.\u01a4;
    }

    public void setXScaleTextOrientation(int scaleTextOrientation) {
        this.\u01a4 = scaleTextOrientation;
    }

    public List getXScaleHideValueIndex() {
        return this.\u018c;
    }

    public void setXScaleHideValueIndex(List scaleHideValueIndex) {
        this.\u018c = scaleHideValueIndex;
        if (scaleHideValueIndex == null) {
            this.\u018c = new ArrayList();
        }
        this.publishData();
    }

    public List getYScaleHideValueIndex() {
        return this.\u0186;
    }

    public void setYScaleHideValueIndex(List scaleHideValueIndex) {
        this.\u0186 = scaleHideValueIndex;
        if (scaleHideValueIndex == null) {
            this.\u0186 = new ArrayList();
        }
        this.publishData();
    }

    public boolean isYScaleValueGapAutoCalculate() {
        return this.\u01a6;
    }

    public void setYScaleValueGapAutoCalculate(boolean scaleValueGapAutoCaculate) {
        this.\u01a6 = scaleValueGapAutoCaculate;
        this.publishData();
    }

    public boolean isXAxisUnitVisible() {
        return this.\u0184;
    }

    public void setXAxisUnitVisible(boolean axisUnitVisible) {
        this.\u0184 = axisUnitVisible;
    }

    public Color getXAxisUnitColor() {
        return this.\u01a3;
    }

    public void setXAxisUnitColor(Color axisUnitColor) {
        this.\u01a3 = axisUnitColor;
    }

    public Font getXAxisUnitFont() {
        return this.\u018f;
    }

    public void setXAxisUnitFont(Font axisUnitFont) {
        this.\u018f = axisUnitFont;
    }

    public String getYAxisUnit() {
        return this.\u0185;
    }

    public void setYAxisUnit(String axisUnit) {
        this.\u0185 = axisUnit;
    }

    public boolean isYAxisUnitVisible() {
        return this.\u0182;
    }

    public void setYAxisUnitVisible(boolean axisUnitVisible) {
        this.\u0182 = axisUnitVisible;
    }

    public Color getYAxisUnitColor() {
        return this.\u0190;
    }

    public void setYAxisUnitColor(Color axisUnitColor) {
        this.\u0190 = axisUnitColor;
    }

    public Font getYAxisUnitFont() {
        return this.\u017d;
    }

    public void setYAxisUnitFont(Font axisUnitFont) {
        this.\u017d = axisUnitFont;
    }

    public double getYScaleMinValue() {
        return this.\u017e;
    }

    public void setYScaleMinValue(double scaleMinValue) {
        this.\u017e = scaleMinValue;
        this.publishData();
    }

    public double getYScaleMaxValue() {
        return this.\u0187;
    }

    public void setYScaleMaxValue(double scaleMaxValue) {
        this.\u0187 = scaleMaxValue;
        this.publishData();
    }

    public boolean isXScaleTextOnTop() {
        return this.\u01b3;
    }

    public void setXScaleTextOnTop(boolean scaleTextOnTop) {
        this.\u01b3 = scaleTextOnTop;
        this.publishData();
    }
}

